/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.dh.DHPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DHKeyAgreement
extends KeyAgreementSpi {
    private byte[] b;
    private BigInteger e;
    private BigInteger d;
    private DHPrivateKey c;
    private SecureRandom a;

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        this.a = secureRandom;
        if (key instanceof DHPrivateKey) {
            this.c = (DHPrivateKey)key;
            this.d = this.c.getParams().getP();
            this.e = this.c.getParams().getG();
            return;
        }
        throw new InvalidKeyException("Only DH private keys are allowed.");
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(key, null, secureRandom);
    }

    protected int engineGenerateSecret(byte[] byArray, int n) throws ShortBufferException, IllegalStateException {
        if (byArray.length - n < this.b.length) {
            throw new ShortBufferException("Output buffer is to small for holding the secret.");
        }
        System.arraycopy(this.b, 0, byArray, n, this.b.length);
        return this.b.length;
    }

    protected SecretKey engineGenerateSecret(String string) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.b, string);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            return secretKeyFactory.generateSecret(secretKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Invalid key: " + invalidKeySpecException.toString());
        }
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.b;
    }

    protected Key engineDoPhase(Key key, boolean bl) throws IllegalStateException, InvalidKeyException {
        if (key instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)key;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            if (!this.d.equals(dHParameterSpec.getP()) && !this.e.equals(dHParameterSpec.getG())) {
                throw new InvalidKeyException("DH parameters are not equal.");
            }
            BigInteger bigInteger = dHPublicKey.getY().modPow(this.c.getX(), this.d);
            if (bl) {
                this.b = bigInteger.toByteArray();
                if (this.b[0] == 0) {
                    byte[] byArray = new byte[this.b.length - 1];
                    System.arraycopy(this.b, 1, byArray, 0, this.b.length - 1);
                    this.b = byArray;
                }
                return null;
            }
            return new DHPublicKey(bigInteger, this.c.getParams());
        }
        throw new InvalidKeyException("DH public key needed.");
    }
}

