/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.security.cipher.PBEKey;
import iaik.security.cipher.PBEKeyBMP;
import iaik.security.pbe.PBEGenParameterSpec;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public class EncryptedDataStream
implements ContentStream {
    static /* synthetic */ Class b;
    private EncryptedContentInfoStream a;
    protected int block_size = -1;
    protected int version = 0;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream, int n) throws IOException {
        try {
            DerCoder.encodeTo(this.toASN1Object(n), outputStream);
            return;
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo(this.toASN1Object(), outputStream);
            return;
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        stringBuffer.append("EncryptedContentInfo:\n");
        stringBuffer.append(this.a.toString());
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    protected ASN1Object toASN1Object(int n) throws PKCSException {
        if (n <= 0) {
            n = this.block_size;
        }
        if (n > 0) {
            this.a.setBlockSize(n);
        }
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        sEQUENCE.addComponent(new INTEGER(this.version));
        sEQUENCE.addComponent(this.a.toASN1Object());
        return sEQUENCE;
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.toASN1Object(-1);
    }

    Key a(char[] cArray, AlgorithmID algorithmID) {
        if (algorithmID.equals(AlgorithmID.pbeWithMD5AndDES_CBC)) {
            return new PBEKey(cArray);
        }
        return new PBEKeyBMP(cArray);
    }

    public void setupCipher(char[] cArray) throws InvalidKeyException, InvalidParameterSpecException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        AlgorithmID algorithmID = this.a.getContentEncryptionAlgorithm();
        AlgorithmParameters algorithmParameters = algorithmID.getAlgorithmParameters("PBE");
        Object t = algorithmParameters.getParameterSpec(b != null ? b : (b = EncryptedDataStream.a("javax.crypto.spec.PBEParameterSpec")));
        Key key = this.a(cArray, this.a.getContentEncryptionAlgorithm());
        this.a.setupCipher(key, (AlgorithmParameterSpec)t);
    }

    public void setupCipher(AlgorithmID algorithmID, char[] cArray, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            AlgorithmParameterSpec algorithmParameterSpec = this.a(algorithmID, n);
            Key key = this.a(cArray, algorithmID);
            this.a.setupCipher(algorithmID, key, algorithmParameterSpec);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalErrorException(invalidAlgorithmParameterException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InternalErrorException(invalidParameterSpecException);
        }
    }

    public void setupCipher(AlgorithmID algorithmID, char[] cArray) throws InvalidKeyException, NoSuchAlgorithmException {
        this.setupCipher(algorithmID, cArray, 1);
    }

    AlgorithmParameterSpec a(AlgorithmID algorithmID, int n) throws InvalidParameterSpecException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PBEGenParameterSpec pBEGenParameterSpec = new PBEGenParameterSpec(8, n);
        AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("PBE");
        algorithmParameterGenerator.init(pBEGenParameterSpec);
        AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
        PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameters.getParameterSpec(b != null ? b : (b = EncryptedDataStream.a("javax.crypto.spec.PBEParameterSpec")));
        algorithmID.setAlgorithmParameters(algorithmParameters);
        return pBEParameterSpec;
    }

    public void setBlockSize(int n) {
        this.block_size = n;
    }

    public int getVersion() {
        return this.version;
    }

    public InputStream getInputStream() {
        return this.a.getInputStream();
    }

    public Object getEncryptedContentInfo() {
        return this.a;
    }

    public ObjectID getContentType() {
        return ObjectID.pkcs7_encryptedData;
    }

    public int getBlockSize() {
        return this.block_size;
    }

    public void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = ((DerInputStream)inputStream).readSequence();
        this.version = derInputStream.readInteger().intValue();
        this.a = new EncryptedContentInfoStream(derInputStream);
    }

    public EncryptedDataStream(InputStream inputStream, int n) {
        this();
        this.a = new EncryptedContentInfoStream(ObjectID.pkcs7_data, inputStream);
        this.block_size = n;
    }

    public EncryptedDataStream(InputStream inputStream) throws PKCSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public EncryptedDataStream(EncryptedContentInfoStream encryptedContentInfoStream) {
        this();
        this.a = encryptedContentInfoStream;
    }

    protected EncryptedDataStream() {
    }
}

