/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.pkcs.pkcs12.SafeBag;

public class SafeContentsBag
extends SafeBag {
    protected SafeBag[] bags;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        int n = 0;
        while (n < this.bags.length) {
            stringBuffer.append("Safe bag #" + n + "\n");
            stringBuffer.append(this.bags[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        return SafeBag.encodeSafeContentsAsASN1Object(this.bags);
    }

    public SafeBag[] getSafeBags() {
        return this.bags;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.bags = SafeBag.parseSafeContents(aSN1Object);
    }

    public SafeContentsBag(SafeBag[] safeBagArray, String string, byte[] byArray) {
        super(string, byArray);
        if (safeBagArray == null) {
            throw new NullPointerException("Argument \"bags\" must not be null.");
        }
        this.bags = safeBagArray;
        this.b = ObjectID.pkcs12_safeContentsBag;
    }

    public SafeContentsBag(SafeBag[] safeBagArray) {
        if (safeBagArray == null) {
            throw new NullPointerException("Argument \"bags\" must not be null.");
        }
        this.bags = safeBagArray;
        this.b = ObjectID.pkcs12_safeContentsBag;
    }

    protected SafeContentsBag() {
        this.b = ObjectID.pkcs12_safeContentsBag;
    }
}

