/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AVA;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;
import iaik.utils.RFC2253NameParserException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;

public class Name
implements ASN1Type,
Principal {
    private Vector a = new Vector();

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.a.size() - 1;
        while (n >= 0) {
            RDN rDN = (RDN)this.a.elementAt(n);
            stringBuffer.append(rDN.toString(bl));
            if (n > 0) {
                stringBuffer.append(",");
            }
            if (bl) {
                stringBuffer.append("\n");
            }
            --n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        int n = 0;
        while (n < this.a.size()) {
            sEQUENCE.addComponent(((RDN)this.a.elementAt(n)).toASN1Object());
            ++n;
        }
        return sEQUENCE;
    }

    public boolean removeRDN(ObjectID objectID) {
        boolean bl = false;
        int n = 0;
        while (n < this.a.size()) {
            RDN rDN = (RDN)this.a.elementAt(n);
            if (rDN.getAVA(objectID) != null) {
                this.a.removeElementAt(n--);
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public int hashCode() {
        int n;
        int n2 = n = this.a.size();
        int n3 = 0;
        while (n3 < n) {
            RDN rDN = (RDN)this.a.elementAt(n3);
            n2 = n2 << 7 | n2 >>> 25;
            n2 += rDN.hashCode();
            ++n3;
        }
        return n2;
    }

    public String getRFC2253String() throws RFC2253NameParserException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.a.size() - 1;
        while (n >= 0) {
            RDN rDN = (RDN)this.a.elementAt(n);
            stringBuffer.append(rDN.getRFC2253String());
            if (n > 0) {
                stringBuffer.append(",");
            }
            --n;
        }
        return stringBuffer.toString();
    }

    public String[] getRDNs(ObjectID objectID) {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            AVA aVA = objectArray.getAVA(objectID);
            if (aVA == null) continue;
            vector.addElement((String)aVA.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object[] getRDNValues(ObjectID objectID) {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            AVA aVA = objectArray.getAVA(objectID);
            if (aVA == null) continue;
            vector.addElement(aVA.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object getRDNValue(ObjectID objectID) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            RDN rDN = (RDN)enumeration.nextElement();
            AVA aVA = rDN.getAVA(objectID);
            if (aVA == null) continue;
            return aVA.getValue();
        }
        return null;
    }

    public String getRDN(ObjectID objectID) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            RDN rDN = (RDN)enumeration.nextElement();
            AVA aVA = rDN.getAVA(objectID);
            if (aVA == null) continue;
            return (String)aVA.getValue();
        }
        return null;
    }

    public String getName() {
        return this.toString(false);
    }

    public byte[] getEncoded() {
        try {
            return new ASN1(this.toASN1Object()).toByteArray();
        }
        catch (Exception exception) {
            throw new InternalErrorException(exception.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        int n = this.a.size();
        if (n != name.a.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            RDN rDN;
            RDN rDN2 = (RDN)this.a.elementAt(n2);
            if (!rDN2.equals(rDN = (RDN)name.a.elementAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Enumeration elements() {
        return this.a.elements();
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object.isA(ASN.SET)) {
            RDN rDN = new RDN(aSN1Object);
            this.a.addElement(rDN);
            return;
        }
        int n = 0;
        while (n < aSN1Object.countComponents()) {
            RDN rDN = new RDN(aSN1Object.getComponentAt(n));
            this.a.addElement(rDN);
            ++n;
        }
    }

    public void addRDN(RDN rDN) {
        this.a.addElement(rDN);
    }

    public void addRDN(ObjectID objectID, Object object) {
        this.a.addElement(new RDN(objectID, object));
    }

    public Name(byte[] byArray) throws CodingException {
        this(new ASN1(byArray).toASN1Object());
    }

    public Name(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public Name() {
    }
}

