/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.RelationDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.edo.IEdoIndexTable;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelectByRelation;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.AbstractServiceModule;
import com.sap.tc.col.servicemanager.core.CoolFeature;
import com.sap.tc.col.servicemanager.core.SrvMgrMessageHandler;
import com.sap.tc.col.servicemanager.core.calls.AbstractAspectCall;
import com.sap.tc.col.servicemanager.core.typeinfo.RelationType;
import java.util.ArrayList;

public class SrvMgrSelectByRelation
extends AbstractAspectCall
implements ISrvMgrSelectByRelation {
    private RelationDescriptor mRelationDescriptor;
    private RelationType mRelationTypeInfo;
    private IEdoTable mInRecords;
    private IEdoIndexTable mRelations;
    private IEdoTable mInSortingOptions;
    private IEdoStructure mInOptions;
    private int mLockMode;
    private IEdoTable mLockMessageTable;
    private ISrvMgrMessage[] mLockMessages;
    private IEdoTable mLockReturnCodesTable;

    public SrvMgrSelectByRelation(ISrvMgrServiceModule serviceModule, String aspectName, String relationName) {
        super(serviceModule, aspectName);
        this.mRelationDescriptor = (RelationDescriptor)this.mAspectDescriptor.getRelationDescriptor(relationName);
        if (this.mRelationDescriptor == null) {
            throw new RuntimeException("Unknown relation requested " + relationName + " on aspect " + this.mAspectDescriptor.getName());
        }
        this.mRelationTypeInfo = new RelationType(this.mAspectDescriptor, this.mRelationDescriptor, (ServiceModuleDescriptor)serviceModule.getDescriptor());
    }

    public IRelationDescriptor getRelationDescriptor() {
        return this.mRelationDescriptor;
    }

    public void setInRecords(IEdoTable inRecords) {
        this.mInRecords = inRecords;
    }

    public IEdoTable getInRecords() {
        if (this.mInRecords == null) {
            this.mInRecords = this.createInRecordsTable();
        }
        return this.mInRecords;
    }

    public void setLockMode(int lockMode) {
        this.mLockMode = lockMode;
    }

    public int getLockMode() {
        return this.mLockMode;
    }

    private void setRelations(IEdoIndexTable relations) {
        this.mRelations = relations;
    }

    public IEdoIndexTable getRelations() {
        if (this.mRelations == null) {
            this.mRelations = this.createRelations();
        }
        return this.mRelations;
    }

    public IEdoTable createInRecordsTable() {
        return this.mServiceModule.createTable((IStructureDescriptor)((StructureDescriptor)this.mRelationDescriptor.getSourceAspectDescriptor().getStructure()));
    }

    public IEdoTable getLockMessageTable() {
        if (this.mLockMessageTable == null) {
            this.mLockMessageTable = this.createMessageTable();
        }
        return this.mLockMessageTable;
    }

    public IEdoTable getLockReturnCodes() {
        if (this.mLockReturnCodesTable == null) {
            this.mLockReturnCodesTable = this.createReturnCodesTable();
        }
        return this.mLockReturnCodesTable;
    }

    public void processCall() {
        this.validateStateForProcessing();
        if (this.mInRecords == null) {
            throw new RuntimeException("inrecords can not be null on selectByRelation");
        }
        AbstractServiceManager sm = (AbstractServiceManager)this.mServiceModule.getServiceManager();
        RpeParameter relation = sm.createParameter("RELATION", "STRING", "I", "A", this.mRelationTypeInfo.relationName);
        RpeParameter inRecords = sm.createParameter("INRECORDS", this.mRelationTypeInfo.type_inrecords.getName(), "I", "T", this.getInRecords());
        RpeParameter aspect = sm.createParameter("ASPECT", "STRING", "I", "A", this.mRelationTypeInfo.sourceAspectName);
        RpeParameter serviceModule = sm.createParameter("SERVICE_MODULE", "STRING", "I", "A", this.mRelationTypeInfo.smName);
        RpeParameter lockMode = this.getLockModeParameter(sm, this.mLockMode);
        RpeParameter outRecords = sm.createParameter("OUTRECORDS", this.mRelationTypeInfo.type_outrecords.getName(), "E", "T", this.getOutRecords());
        RpeParameter indexTable = sm.createParameter("INDEX", ((ServiceModuleDescriptor)this.mServiceModule.getDescriptor()).getRelationIndexStructure().getName(), "E", "T", (IEdoValue)this.getRelations());
        ArrayList<RpeParameter> inp = new ArrayList<RpeParameter>();
        inp.add(relation);
        inp.add(inRecords);
        if (this.mInOptions != null) {
            inp.add(sm.createParameter("OPTIONS", this.getRelationDescriptor().getInputOptions().getName(), "I", "S", this.getInOptions()));
        }
        if (this.mInSortingOptions != null) {
            inp.add(sm.createParameter("OPTIONS_SORTING", this.getRelationDescriptor().getSortingOptions().getName(), "I", "T", this.getInSortingOptions()));
        }
        inp.add(lockMode);
        inp.add(aspect);
        inp.add(serviceModule);
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        out.add(outRecords);
        out.add(indexTable);
        if (sm.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
            out.add(this.getReturnCodeParameter(sm));
            out.add(this.getRejectedParameter(sm));
            RpeParameter pLockRetCodes = sm.createParameter("LOCK_RETURN_CODES", this.getLockReturnCodes().getDescriptor().getName(), "E", "T", this.getLockReturnCodes());
            out.add(pLockRetCodes);
        } else {
            out.add(this.getMessageParameter(sm));
            RpeParameter pLockMsgOut = sm.createParameter("LOCK_MESSAGES", this.getLockMessageTable().getDescriptor().getName(), "E", "T", this.getLockMessageTable());
            out.add(pLockMsgOut);
        }
        sm.callMethod("IF_COL_SERVICE_MANAGER~ASPECT_SELECT_BY_RELATION", inp, out);
        sm.queueCall(this);
    }

    public void reset() {
        this.mInOptions = null;
        this.mInRecords = null;
        this.mInSortingOptions = null;
        this.mLockMessages = null;
        this.mLockMessageTable = null;
        this.mLockMode = 0;
        this.mLockReturnCodesTable = null;
        this.mRelations = null;
        super.reset();
    }

    private IEdoIndexTable createRelations() {
        return ((AbstractServiceModule)this.mServiceModule).createIndexTable();
    }

    protected IEdoTable createOutRecordsTable() {
        return this.mServiceModule.createTable((IStructureDescriptor)this.mRelationTypeInfo.type_outrecords);
    }

    public ISrvMgrMessage[] getLockMessages() {
        if (this.getState() != 2) {
            throw new IllegalStateException("Operation not permitted: call is not completed.");
        }
        if (this.mLockMessages == null) {
            this.mLockMessages = SrvMgrMessageHandler.getMessages(this.mLockMessageTable);
            if (this.mLockMessageTable != null) {
                this.mLockMessageTable.clear();
                this.mLockMessageTable = null;
            }
        }
        return this.mLockMessages;
    }

    public IEdoStructure createInOptionsStructure() {
        return ((AbstractServiceModule)this.mServiceModule).createInOptionsStructure();
    }

    public IEdoTable createInSortingOptionsTable() {
        return ((AbstractServiceModule)this.mServiceModule).createInSortingOptionsTable();
    }

    public IEdoStructure getInOptions() {
        if (this.mInOptions == null && (this.getState() == 0 || this.getState() == 1)) {
            this.mInOptions = this.createInOptionsStructure();
        }
        return this.mInOptions;
    }

    public IEdoTable getInSortingOptions() {
        if (this.mInSortingOptions == null && (this.getState() == 0 || this.getState() == 1)) {
            this.mInSortingOptions = this.createInSortingOptionsTable();
        }
        return this.mInSortingOptions;
    }

    public void setInOptions(IEdoStructure inOptions) {
        this.mInOptions = inOptions;
    }

    public void setInSortingOptions(IEdoTable inSortingOptions) {
        this.mInSortingOptions = inSortingOptions;
    }

    public void cleanupMessages() {
    }
}

