/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelect;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.CoolFeature;
import com.sap.tc.col.servicemanager.core.SrvMgrMessageHandler;
import com.sap.tc.col.servicemanager.core.calls.AbstractAspectCall;
import java.util.ArrayList;

public class SrvMgrSelect
extends AbstractAspectCall
implements ISrvMgrSelect {
    private IEdoTable mInKeys;
    private int mLockMode;
    private IEdoTable mLockMessageTable;
    private IEdoTable mLockReturnCodesTable;
    private ISrvMgrMessage[] mLockMessages;

    public SrvMgrSelect(ISrvMgrServiceModule serviceModule, String aspectName) {
        super(serviceModule, aspectName);
    }

    public void setInKeys(IEdoTable inKeys) {
        this.mInKeys = inKeys;
    }

    public IEdoTable getInKeys() {
        if (this.mInKeys == null) {
            this.mInKeys = this.createInKeysTable();
        }
        return this.mInKeys;
    }

    public void setLockMode(int lockMode) {
        this.mLockMode = lockMode;
    }

    public int getLockMode() {
        return this.mLockMode;
    }

    public IEdoTable createInKeysTable() {
        return this.createAspectInKeysTable();
    }

    public IEdoTable getLockMessageTable() {
        if (this.mLockMessageTable == null) {
            this.mLockMessageTable = this.createMessageTable();
        }
        return this.mLockMessageTable;
    }

    public IEdoTable getLockReturnCodes() {
        if (this.mLockReturnCodesTable == null) {
            this.mLockReturnCodesTable = this.createReturnCodesTable();
        }
        return this.mLockReturnCodesTable;
    }

    public void processCall() {
        this.validateStateForProcessing();
        AbstractServiceManager sm = (AbstractServiceManager)this.mServiceModule.getServiceManager();
        RpeParameter inKeys = this.getInKeysParameter(sm, this.getInKeys());
        RpeParameter lockMode = this.getLockModeParameter(sm, this.mLockMode);
        RpeParameter aspect = this.getAspectNameParameter(sm);
        RpeParameter serviceModule = this.getServiceModuleParameter(sm);
        RpeParameter outRecords = this.getOutRecordsParameter(sm);
        ArrayList<RpeParameter> inp = new ArrayList<RpeParameter>();
        inp.add(inKeys);
        inp.add(lockMode);
        inp.add(aspect);
        inp.add(serviceModule);
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        out.add(outRecords);
        if (sm.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
            out.add(this.getReturnCodeParameter(sm));
            out.add(this.getRejectedParameter(sm));
            RpeParameter pLockRetCodes = sm.createParameter("LOCK_RETURN_CODES", this.getLockReturnCodes().getDescriptor().getName(), "E", "T", this.getLockReturnCodes());
            out.add(pLockRetCodes);
        } else {
            out.add(this.getMessageParameter(sm));
            RpeParameter pLockMsgOut = sm.createParameter("LOCK_MESSAGES", this.getLockMessageTable().getDescriptor().getName(), "E", "T", this.getLockMessageTable());
            out.add(pLockMsgOut);
        }
        sm.callMethod("IF_COL_SERVICE_MANAGER~ASPECT_SELECT", inp, out);
        sm.queueCall(this);
    }

    public void reset() {
        this.mInKeys = null;
        this.mLockMessages = null;
        this.mLockMessageTable = null;
        this.mLockMode = 0;
        this.mLockReturnCodesTable = null;
        super.reset();
    }

    public ISrvMgrMessage[] getLockMessages() {
        if (this.getState() != 2) {
            throw new IllegalStateException("Operation not permitted: call is not completed.");
        }
        if (this.mLockMessages == null) {
            this.mLockMessages = SrvMgrMessageHandler.getMessages(this.mLockMessageTable);
            if (this.mLockMessageTable != null) {
                this.mLockMessageTable.clear();
                this.mLockMessageTable = null;
            }
        }
        return this.mLockMessages;
    }

    public void cleanupMessages() {
    }
}

