/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.QueryDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrQuery;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.AbstractServiceModule;
import com.sap.tc.col.servicemanager.core.CoolFeature;
import com.sap.tc.col.servicemanager.core.calls.AbstractCall;
import com.sap.tc.col.servicemanager.core.typeinfo.QueryType;
import java.util.ArrayList;

public class SrvMgrQuery
extends AbstractCall
implements ISrvMgrQuery {
    private QueryDescriptor mQueryDescriptor;
    private IEdoTable mInKeys;
    private IEdoStructure mInParameters;
    private IEdoTable mInSelections;
    private IEdoTable mInSortingOptions;
    private IEdoStructure mInOptions;
    private QueryType mQueryTypeInfo;

    public SrvMgrQuery(ISrvMgrServiceModule serviceModule, String queryName) {
        this(serviceModule, (QueryDescriptor)serviceModule.getDescriptor().getQueryDescriptor(queryName));
    }

    public SrvMgrQuery(ISrvMgrServiceModule serviceModule, QueryDescriptor queryDescriptor) {
        super(serviceModule);
        this.mQueryDescriptor = queryDescriptor;
        this.mQueryTypeInfo = new QueryType(this.mQueryDescriptor);
    }

    public void setInParameters(IEdoStructure inParameters) {
        if (!this.getQueryDescriptor().hasInputParameters()) {
            throw new UnsupportedOperationException("This query does not have input parameters!");
        }
        this.mInParameters = inParameters;
    }

    public IEdoStructure getInParameters() {
        if (this.getQueryDescriptor().hasInputParameters()) {
            if (this.mInParameters == null) {
                this.mInParameters = this.createInParameterList();
            }
            return this.mInParameters;
        }
        throw new UnsupportedOperationException("This query does not have input parameters!");
    }

    public void addInParameter(String name, String value) {
        if (!this.getQueryDescriptor().hasInputParameters()) {
            throw new UnsupportedOperationException("This query does not have input parameters!");
        }
        this.getInParameters().setStringValue(name, value);
    }

    public IEdoTable createInKeysTable() {
        if (this.getQueryDescriptor().hasInputKeys()) {
            return this.mServiceModule.createTable((IStructureDescriptor)this.mQueryTypeInfo.i1Type_input_keys);
        }
        throw new UnsupportedOperationException("This query does not have input keys!");
    }

    public void setInKeys(IEdoTable inKeys) {
        if (!this.getQueryDescriptor().hasInputKeys()) {
            throw new UnsupportedOperationException("This query does not have input keys!");
        }
        this.mInKeys = inKeys;
    }

    public IEdoTable getInKeys() {
        if (this.getQueryDescriptor().hasInputKeys()) {
            if (this.mInKeys == null) {
                this.mInKeys = this.createInKeysTable();
            }
            return this.mInKeys;
        }
        throw new UnsupportedOperationException("This query does not have input keys!");
    }

    public IQueryDescriptor getQueryDescriptor() {
        return this.mQueryDescriptor;
    }

    public void setQueryDescriptor(QueryDescriptor queryDescriptor) {
        this.mQueryDescriptor = queryDescriptor;
    }

    public void processCall() {
        this.validateStateForProcessing();
        AbstractServiceManager sm = (AbstractServiceManager)this.mServiceModule.getServiceManager();
        RpeParameter query = sm.createParameter("QUERY", "STRING", "I", "A", this.mQueryTypeInfo.qName);
        RpeParameter serviceModule = sm.createParameter("SERVICE_MODULE", "STRING", "I", "A", this.mQueryTypeInfo.smName);
        RpeParameter outRecords = sm.createParameter("OUTRECORDS", this.mQueryTypeInfo.e4Type_result_keys.getName(), "E", "T", this.getOutRecords());
        ArrayList<RpeParameter> inp = new ArrayList<RpeParameter>();
        inp.add(query);
        inp.add(serviceModule);
        if (this.getQueryDescriptor().hasInputKeys()) {
            inp.add(sm.createParameter("INKEYS", this.mQueryTypeInfo.i1Type_input_keys.getName(), "I", "T", this.getInKeys()));
        }
        if (this.mInOptions != null) {
            inp.add(sm.createParameter("OPTIONS", this.getQueryDescriptor().getInputOptions().getName(), "I", "S", this.getInOptions()));
        }
        if (this.mInSortingOptions != null) {
            inp.add(sm.createParameter("OPTIONS_SORTING", this.getQueryDescriptor().getSortingOptions().getName(), "I", "T", this.getInSortingOptions()));
        }
        if (sm.isFeatureActive(CoolFeature.QUERY_SELECTION_PARAM) && this.mInSelections != null) {
            inp.add(sm.createParameter("SELECTIONS", this.getQueryDescriptor().getSelections().getName(), "I", "T", this.getInSelections()));
        }
        if (this.getQueryDescriptor().hasInputParameters()) {
            RpeParameter inParams = sm.createParameter("INPARAM", this.mQueryTypeInfo.i2Type_input_parameters.getName(), "I", "S", this.getInParameters());
            inp.add(inParams);
        }
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        out.add(outRecords);
        if (sm.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
            out.add(this.getRejectedParameter(sm));
        } else {
            out.add(this.getMessageParameter(sm));
        }
        sm.callMethod("IF_COL_SERVICE_MANAGER~QUERY_EXECUTE", inp, out);
        sm.queueCall(this);
    }

    public void reset() {
        this.mInKeys = null;
        this.mInOptions = null;
        this.mInParameters = null;
        this.mInSelections = null;
        this.mInSortingOptions = null;
        super.reset();
    }

    public IEdoStructure createInParameterList() {
        if (this.getQueryDescriptor().hasInputParameters()) {
            return this.mServiceModule.createStructure((IStructureDescriptor)this.mQueryTypeInfo.i2Type_input_parameters);
        }
        throw new UnsupportedOperationException("This query does not have input parameters!");
    }

    protected IEdoTable createOutRecordsTable() {
        return this.mServiceModule.createTable((IStructureDescriptor)this.mQueryTypeInfo.e4Type_result_keys);
    }

    public IEdoStructure createInOptionsStructure() {
        return ((AbstractServiceModule)this.mServiceModule).createInOptionsStructure();
    }

    public IEdoTable createInSortingOptionsTable() {
        return ((AbstractServiceModule)this.mServiceModule).createInSortingOptionsTable();
    }

    public IEdoStructure getInOptions() {
        if (this.mInOptions == null && (this.getState() == 0 || this.getState() == 1)) {
            this.mInOptions = this.createInOptionsStructure();
        }
        return this.mInOptions;
    }

    public IEdoTable getInSortingOptions() {
        if (this.mInSortingOptions == null && (this.getState() == 0 || this.getState() == 1)) {
            this.mInSortingOptions = this.createInSortingOptionsTable();
        }
        return this.mInSortingOptions;
    }

    public void setInOptions(IEdoStructure inOptions) {
        this.mInOptions = inOptions;
    }

    public void setInSortingOptions(IEdoTable inSortingOptions) {
        this.mInSortingOptions = inSortingOptions;
    }

    public IEdoTable createInSelectionsTable() {
        AbstractServiceManager sm = (AbstractServiceManager)this.mServiceModule.getServiceManager();
        if (sm.isFeatureActive(CoolFeature.QUERY_SELECTION_PARAM)) {
            return this.mServiceModule.createTable(this.getQueryDescriptor().getSelections());
        }
        throw new UnsupportedOperationException("The feature '" + CoolFeature.QUERY_SELECTION_PARAM.getName() + "' is not supported in the active <cool> version (" + sm.getActiveVersion() + ")");
    }

    public IEdoTable getInSelections() {
        if (this.mInSelections == null && (this.getState() == 0 || this.getState() == 1)) {
            this.mInSelections = this.createInSelectionsTable();
        }
        return this.mInSelections;
    }

    public void setInSelections(IEdoTable inSelections) {
        this.mInSelections = inSelections;
    }

    public void cleanupMessages() {
    }
}

