/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core.calls;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.api.IValueSetDescriptor;
import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.core.ValueSetDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.rpe.RpeParameter;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrGetValueSet;
import com.sap.tc.col.servicemanager.core.AbstractServiceManager;
import com.sap.tc.col.servicemanager.core.AbstractServiceModule;
import com.sap.tc.col.servicemanager.core.CoolFeature;
import com.sap.tc.col.servicemanager.core.calls.AbstractAspectCall;
import com.sap.tc.col.servicemanager.core.typeinfo.ValueSetType;
import java.util.ArrayList;

public class SrvMgrGetValueSet
extends AbstractAspectCall
implements ISrvMgrGetValueSet {
    private ValueSetDescriptor mValueSetDescriptor;
    private FieldDescriptor mFieldDescriptor;
    private IEdoStructure mInParameters;
    private IEdoStructure mInOptions;
    private ValueSetType mValueSetTypeInfo;

    public SrvMgrGetValueSet(ISrvMgrServiceModule serviceModule, String aspectName, String fieldName) {
        super(serviceModule, aspectName);
        this.mFieldDescriptor = (FieldDescriptor)this.mAspectDescriptor.getStructure().getFieldDescriptor(fieldName);
        this.mValueSetDescriptor = (ValueSetDescriptor)this.mAspectDescriptor.getValueSetDescriptor(fieldName);
        this.mValueSetTypeInfo = new ValueSetType(this.mAspectDescriptor, this.mValueSetDescriptor, (ServiceModuleDescriptor)serviceModule.getDescriptor());
    }

    public IFieldDescriptor getFieldDescriptor() {
        return this.mFieldDescriptor;
    }

    public IEdoStructure createInParameterList() {
        if (this.getValueSetDescriptor().hasInputParameters()) {
            return this.mServiceModule.createStructure((IStructureDescriptor)this.mValueSetTypeInfo.type_input_parameters);
        }
        throw new UnsupportedOperationException("This value set does not have input parameters!");
    }

    public void setInParameters(IEdoStructure inParameters) {
        if (!this.getValueSetDescriptor().hasInputParameters()) {
            throw new UnsupportedOperationException("This value set does not have input parameters!");
        }
        this.mInParameters = inParameters;
    }

    public IEdoStructure getInParameters() {
        if (this.getValueSetDescriptor().hasInputParameters()) {
            if (this.mInParameters == null) {
                this.mInParameters = this.createInParameterList();
            }
            return this.mInParameters;
        }
        throw new UnsupportedOperationException("This value set does not have input parameters!");
    }

    public void addInParameter(String field, String value) {
        if (!this.getValueSetDescriptor().hasInputParameters()) {
            throw new UnsupportedOperationException("This value set does not have input parameters!");
        }
        this.getInParameters().setStringValue(field, value);
    }

    public void processCall() {
        this.validateStateForProcessing();
        AbstractServiceManager sm = (AbstractServiceManager)this.mServiceModule.getServiceManager();
        RpeParameter aspect = sm.createParameter("ASPECT", "STRING", "I", "A", this.mValueSetTypeInfo.aspectName);
        RpeParameter serviceModule = sm.createParameter("SERVICE_MODULE", "STRING", "I", "A", this.mValueSetTypeInfo.smName);
        RpeParameter field = sm.createParameter("FIELD", "STRING", "I", "A", this.mFieldDescriptor.getName());
        RpeParameter outValues = sm.createParameter("OUTVALUES", this.mValueSetTypeInfo.type_outvalues.getName(), "E", "T", this.getOutRecords());
        ArrayList<RpeParameter> inp = new ArrayList<RpeParameter>();
        inp.add(aspect);
        inp.add(serviceModule);
        inp.add(field);
        if (this.getValueSetDescriptor().hasInputParameters()) {
            RpeParameter inParams = sm.createParameter("INPARAM", this.mValueSetTypeInfo.type_input_parameters.getName(), "I", "S", this.getInParameters());
            inp.add(inParams);
        }
        ArrayList<RpeParameter> out = new ArrayList<RpeParameter>();
        out.add(outValues);
        if (sm.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
            out.add(this.getRejectedParameter(sm));
        }
        sm.callMethod("IF_COL_SERVICE_MANAGER~GET_VALUE_SET", inp, out);
        sm.queueCall(this);
    }

    protected IEdoTable createOutRecordsTable() {
        return this.mServiceModule.createTable(this.mValueSetDescriptor.getResultStructureDescriptor());
    }

    public IEdoStructure createInOptionsStructure() {
        return ((AbstractServiceModule)this.mServiceModule).createInOptionsStructure();
    }

    public IEdoStructure getInOptions() {
        if (this.mInOptions == null && (this.getState() == 0 || this.getState() == 1)) {
            this.mInOptions = this.createInOptionsStructure();
        }
        return this.mInOptions;
    }

    public void setInOptions(IEdoStructure inOptions) {
        this.mInOptions = inOptions;
    }

    public IValueSetDescriptor getValueSetDescriptor() {
        return this.mValueSetDescriptor;
    }

    public void reset() {
        this.mInOptions = null;
        this.mInParameters = null;
        super.reset();
    }

    public void cleanupMessages() {
    }
}

