/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core;

import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.core.AspectActionDescriptor;
import com.sap.tc.col.client.metadata.core.AspectDescriptor;
import com.sap.tc.col.client.metadata.core.AspectGroupDescriptor;
import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.KeyAspectDescriptor;
import com.sap.tc.col.client.metadata.core.QueryDescriptor;
import com.sap.tc.col.client.metadata.core.RelationDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleGroupDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import com.sap.tc.col.client.metadata.core.ValueSetDescriptor;
import com.sap.tc.col.edo.IEdoIndexTable;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrAction;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrQuery;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrSelectByRelation;
import com.sap.tc.col.servicemanager.core.AbstractServiceModule;
import com.sap.tc.col.servicemanager.core.CoolFeature;
import com.sap.tc.col.servicemanager.core.RepositoryManager;
import com.sap.tc.col.servicemanager.core.ServiceManager;
import com.sap.tc.logging.Location;

public class SrvMgrServiceModule
extends AbstractServiceModule
implements ISrvMgrServiceModule {
    private static final Location _logger = Location.getLocation((Class)(class$com$sap$tc$col$servicemanager$core$SrvMgrServiceModule == null ? (class$com$sap$tc$col$servicemanager$core$SrvMgrServiceModule = SrvMgrServiceModule.class$("com.sap.tc.col.servicemanager.core.SrvMgrServiceModule")) : class$com$sap$tc$col$servicemanager$core$SrvMgrServiceModule));
    private String mServiceModuleName;
    private String mConfigurationName;
    private ISrvMgrQuery mSvcModsQuery;
    private ISrvMgrAction mConfigAction;
    private ISrvMgrSelectByRelation mAspectStructFieldRel;
    private ISrvMgrSelectByRelation mQueryStructFieldRel;
    private ISrvMgrSelectByRelation mActionStructFieldRel;
    private ISrvMgrSelectByRelation mAspectRel;
    private ISrvMgrSelectByRelation mAspectActionRel;
    private ISrvMgrSelectByRelation mAspectRelationRel;
    private ISrvMgrSelectByRelation mQueryRel;
    private ISrvMgrSelectByRelation mServiceModulePropertyRel;
    private ISrvMgrSelectByRelation mRelationPropertyRel;
    private ISrvMgrSelectByRelation mAspectPropertyRel;
    private ISrvMgrSelectByRelation mServiceModuleGroupsRel;
    private ISrvMgrSelectByRelation mServiceModuleGroupMembersRel;
    private ISrvMgrSelectByRelation mAspectGroupsRel;
    private ISrvMgrSelectByRelation mAspectGroupMembersRel;
    private ISrvMgrSelectByRelation mAspectValueHelpRel;
    private ISrvMgrSelectByRelation mValueSetTableStructFieldRel;
    private ISrvMgrSelectByRelation mValueSetParamStructFieldRel;
    private ISrvMgrSelectByRelation valueSetTableStruct;
    static /* synthetic */ Class class$com$sap$tc$col$servicemanager$core$SrvMgrServiceModule;

    public SrvMgrServiceModule(String pName, String pConfName, ServiceManager pSMgr) {
        this.mServiceManager = pSMgr;
        this.mServiceModuleName = pName;
        this.mConfigurationName = pConfName;
        this.mServiceModuleDescriptor = (ServiceModuleDescriptor)this.mServiceManager.getServiceModuleDescriptor(this.mServiceModuleName, pConfName);
    }

    SrvMgrServiceModule() {
        this.clearCallObjects();
    }

    private void clearCallObjects() {
        this.mSvcModsQuery = null;
        this.mConfigAction = null;
        this.mAspectStructFieldRel = null;
        this.mQueryStructFieldRel = null;
        this.mActionStructFieldRel = null;
        this.mAspectRel = null;
        this.mAspectActionRel = null;
        this.mAspectRelationRel = null;
        this.mQueryRel = null;
        this.mServiceModulePropertyRel = null;
        this.mRelationPropertyRel = null;
        this.mAspectPropertyRel = null;
        this.mServiceModuleGroupsRel = null;
        this.mServiceModuleGroupMembersRel = null;
        this.mAspectGroupsRel = null;
        this.mAspectGroupMembersRel = null;
        this.mAspectValueHelpRel = null;
        this.mValueSetTableStructFieldRel = null;
        this.mValueSetParamStructFieldRel = null;
    }

    void queueRepositoryCalls(String serviceModuleName, String configurationName, ServiceManager serviceManager) {
        String _methodName = "queueRepositoryCalls";
        _logger.pathT("queueRepositoryCalls");
        this.mServiceManager = serviceManager;
        this.mServiceModuleName = serviceModuleName;
        this.mConfigurationName = configurationName;
        ISrvMgrServiceModule repSvcMod = serviceManager.getRepositoryManager().getRepositoryServiceModule();
        this.mSvcModsQuery = repSvcMod.createQuery("COL_SERVICE_MODULE_QUERY_RUNT");
        IEdoTable svcModKeys = this.mSvcModsQuery.createInKeysTable();
        svcModKeys.append(1);
        svcModKeys.setStringValue(svcModKeys.getRecordCount() - 1, "SVC_MODULE_NAME", serviceModuleName);
        this.mSvcModsQuery.setInKeys(svcModKeys);
        this.mSvcModsQuery.processCall();
        if (!"".equals(configurationName)) {
            this.mConfigAction = repSvcMod.createAction("COL_CONFIGURATION_RUNT", "GET_CONFIGURATION");
            this.mConfigAction.getInParameters().setStringValue("SVC_MODULENAME", serviceModuleName);
            this.mConfigAction.getInParameters().setStringValue("CONFIGURATION", configurationName);
            this.mConfigAction.processCall();
        }
        this.mAspectRel = repSvcMod.createSelectByRelation("COL_SERVICE_MODULE_RUNT", "COL_ASPECTS_RUNT");
        this.mAspectRel.setInRecords(this.mSvcModsQuery.getOutRecords());
        this.mAspectRel.processCall();
        this.mAspectActionRel = repSvcMod.createSelectByRelation("COL_ASPECT_RUNT", "COL_ASPECT_ACTIONS_RUNT");
        this.mAspectActionRel.setInRecords(this.mAspectRel.getOutRecords());
        this.mAspectActionRel.processCall();
        if (this.mServiceManager.isFeatureActive(CoolFeature.ASPECT_RELATIONS)) {
            this.mAspectRelationRel = repSvcMod.createSelectByRelation("COL_ASPECT_RUNT", "COL_ASPECT_RELATIONS_RUNT");
            this.mAspectRelationRel.setInRecords(this.mAspectRel.getOutRecords());
            this.mAspectRelationRel.processCall();
        } else {
            this.mAspectRelationRel = repSvcMod.createSelectByRelation("COL_ASPECT_RUNT", "COL_RELATIONS_RUNT");
            this.mAspectRelationRel.setInRecords(this.mAspectRel.getOutRecords());
            this.mAspectRelationRel.processCall();
        }
        this.mQueryRel = repSvcMod.createSelectByRelation("COL_SERVICE_MODULE_RUNT", "COL_QUERIES_RUNT");
        this.mQueryRel.setInRecords(this.mSvcModsQuery.getOutRecords());
        this.mQueryRel.processCall();
        this.mServiceModuleGroupsRel = repSvcMod.createSelectByRelation("COL_SERVICE_MODULE_RUNT", "COL_SERVICE_MODULE_GROUPS_RUNT");
        this.mServiceModuleGroupsRel.setInRecords(this.mSvcModsQuery.getOutRecords());
        this.mServiceModuleGroupsRel.processCall();
        this.mServiceModuleGroupMembersRel = repSvcMod.createSelectByRelation("COL_GROUP_RUNT", "COL_GROUP_MEMBERS_RUNT");
        this.mServiceModuleGroupMembersRel.setInRecords(this.mServiceModuleGroupsRel.getOutRecords());
        this.mServiceModuleGroupMembersRel.processCall();
        this.mServiceModulePropertyRel = repSvcMod.createSelectByRelation("COL_SERVICE_MODULE_RUNT", "COL_SVC_MOD_PROPERTIES_RUNT");
        this.mServiceModulePropertyRel.setInRecords(this.mSvcModsQuery.getOutRecords());
        this.mServiceModulePropertyRel.processCall();
        this.mAspectGroupsRel = repSvcMod.createSelectByRelation("COL_ASPECT_RUNT", "COL_ASPECT_GROUPS_RUNT");
        this.mAspectGroupsRel.setInRecords(this.mAspectRel.getOutRecords());
        this.mAspectGroupsRel.processCall();
        this.mAspectGroupMembersRel = repSvcMod.createSelectByRelation("COL_GROUP_RUNT", "COL_GROUP_MEMBERS_RUNT");
        this.mAspectGroupMembersRel.setInRecords(this.mAspectGroupsRel.getOutRecords());
        this.mAspectGroupMembersRel.processCall();
        this.mAspectPropertyRel = repSvcMod.createSelectByRelation("COL_ASPECT_RUNT", "COL_ASPECT_PROPERTIES_RUNT");
        this.mAspectPropertyRel.setInRecords(this.mAspectRel.getOutRecords());
        this.mAspectPropertyRel.processCall();
        if (!this.mServiceManager.isFeatureActive(CoolFeature.ASPECT_RELATIONS)) {
            this.mRelationPropertyRel = repSvcMod.createSelectByRelation("COL_RELATION_RUNT", "COL_RELATION_PROPERTIES_RUNT");
            this.mRelationPropertyRel.setInRecords(this.mAspectRelationRel.getOutRecords());
            this.mRelationPropertyRel.processCall();
        }
        ISrvMgrSelectByRelation aspectStructRel = repSvcMod.createSelectByRelation("COL_ASPECT_RUNT", "COL_ASPECT_STRUCTURE_RUNT");
        aspectStructRel.setInRecords(this.mAspectRel.getOutRecords());
        aspectStructRel.processCall();
        this.mAspectStructFieldRel = repSvcMod.createSelectByRelation("COL_STRUCTURE_RUNT", "COL_STRUCTURE_FIELDS_RUNT");
        this.mAspectStructFieldRel.setInRecords(aspectStructRel.getOutRecords());
        this.mAspectStructFieldRel.processCall();
        ISrvMgrSelectByRelation queryStructRel = repSvcMod.createSelectByRelation("COL_QUERY_RUNT", "COL_QUERY_INP_STRUCT_RUNT");
        queryStructRel.setInRecords(this.mQueryRel.getOutRecords());
        queryStructRel.processCall();
        this.mQueryStructFieldRel = repSvcMod.createSelectByRelation("COL_STRUCTURE_RUNT", "COL_STRUCTURE_FIELDS_RUNT");
        this.mQueryStructFieldRel.setInRecords(queryStructRel.getOutRecords());
        this.mQueryStructFieldRel.processCall();
        ISrvMgrSelectByRelation actionStructRel = repSvcMod.createSelectByRelation("COL_ASPECT_ACTION_RUNT", "COL_ASP_ACT_INP_STRU_RUNT");
        actionStructRel.setInRecords(this.mAspectActionRel.getOutRecords());
        actionStructRel.processCall();
        this.mActionStructFieldRel = repSvcMod.createSelectByRelation("COL_STRUCTURE_RUNT", "COL_STRUCTURE_FIELDS_RUNT");
        this.mActionStructFieldRel.setInRecords(actionStructRel.getOutRecords());
        this.mActionStructFieldRel.processCall();
        if (this.mServiceManager.isFeatureActive(CoolFeature.VALUE_HELP)) {
            this.mAspectValueHelpRel = repSvcMod.createSelectByRelation("COL_ASPECT_RUNT", "COL_VALUE_SETS_RUNT");
            this.mAspectValueHelpRel.setInRecords(this.mAspectRel.getOutRecords());
            this.mAspectValueHelpRel.processCall();
            this.valueSetTableStruct = repSvcMod.createSelectByRelation("COL_VALUE_SET_RUNT", "COL_VALUE_SET_OUTVAL_STR_RUNT");
            this.valueSetTableStruct.setInRecords(this.mAspectValueHelpRel.getOutRecords());
            this.valueSetTableStruct.processCall();
            this.mValueSetTableStructFieldRel = repSvcMod.createSelectByRelation("COL_STRUCTURE_RUNT", "COL_STRUCTURE_FIELDS_RUNT");
            this.mValueSetTableStructFieldRel.setInRecords(this.valueSetTableStruct.getOutRecords());
            this.mValueSetTableStructFieldRel.processCall();
            ISrvMgrSelectByRelation valueSetParamStruct = repSvcMod.createSelectByRelation("COL_VALUE_SET_RUNT", "COL_VALUE_SET_INPARAM_STR_RUNT");
            valueSetParamStruct.setInRecords(this.mAspectValueHelpRel.getOutRecords());
            valueSetParamStruct.processCall();
            this.mValueSetParamStructFieldRel = repSvcMod.createSelectByRelation("COL_STRUCTURE_RUNT", "COL_STRUCTURE_FIELDS_RUNT");
            this.mValueSetParamStructFieldRel.setInRecords(valueSetParamStruct.getOutRecords());
            this.mValueSetParamStructFieldRel.processCall();
        }
    }

    IServiceModuleDescriptor buildRepository() {
        int[] propIndices;
        AspectDescriptor anAspectDesc;
        RepositoryManager repositoryManager = ((ServiceManager)this.mServiceManager).getRepositoryManager();
        IEdoTable outTable = this.mSvcModsQuery.getOutRecords();
        if (outTable.getRecordCount() < 1) {
            ISrvMgrMessage[] errors;
            if (this.mServiceManager.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
                errors = this.mServiceManager.getAspectMessages(this.mSvcModsQuery.getQueryDescriptor().getResultAspectDescriptor().getName(), true);
            }
            errors = this.mSvcModsQuery.getMessages();
            int i = 0;
            while (i < errors.length) {
                _logger.errorT("Message " + i + ": " + errors[i].getText());
                ++i;
            }
            IllegalArgumentException ex = new IllegalArgumentException("No such service module '" + this.mServiceModuleName + "'");
            _logger.throwing((Throwable)ex);
            throw ex;
        }
        if (outTable.getRecordCount() > 1) {
            throw new IllegalStateException("Multiple ServiceModules found for " + this.mServiceModuleName);
        }
        if (!outTable.getStringValue(0, "SVC_MODULE_NAME").equalsIgnoreCase(this.mServiceModuleName)) {
            throw new IllegalArgumentException("ServiceModule name mismatch for " + outTable.getStringValue(0, "SVC_MODULE_NAME") + "!!");
        }
        String configurationDescriptor = "";
        if (this.mConfigAction != null) {
            if (this.mConfigAction.getOutRecords().getRecordCount() > 0) {
                configurationDescriptor = this.mConfigAction.getOutRecords().getStringValue(0, "DESCRIPTION");
            } else {
                ISrvMgrMessage[] errors;
                if (this.mServiceManager.isFeatureActive(CoolFeature.MESSAGES_OUT_OF_BAND_ONLY)) {
                    errors = this.mServiceManager.getAspectMessages(this.mConfigAction.getAspectDescriptor().getName(), true);
                }
                errors = this.mConfigAction.getMessages();
                int i = 0;
                while (i < errors.length) {
                    _logger.errorT("Message " + i + ": " + errors[i].getText());
                    ++i;
                }
                IllegalArgumentException ex = new IllegalArgumentException("No such service module configuration '" + this.mConfigurationName + "' in service module '" + this.mServiceModuleName + "'");
                _logger.throwing((Throwable)ex);
                throw ex;
            }
        }
        ServiceModuleDescriptor smDesc = new ServiceModuleDescriptor(outTable.getStringValue(0, "SVC_MODULE_NAME"), outTable.getStringValue(0, "DESCRIPTION"), this.mConfigurationName, configurationDescriptor, this.mServiceManager.getLocale());
        try {
            repositoryManager.createStructureDesc(smDesc, this.mAspectStructFieldRel);
        }
        catch (RuntimeException rte) {
            throw new RuntimeException(rte.getMessage() + " in an aspect ");
        }
        try {
            repositoryManager.createStructureDesc(smDesc, this.mQueryStructFieldRel);
        }
        catch (RuntimeException rte) {
            throw new RuntimeException(rte.getMessage() + " in an query input param ");
        }
        try {
            repositoryManager.createStructureDesc(smDesc, this.mActionStructFieldRel);
        }
        catch (RuntimeException rte) {
            throw new RuntimeException(rte.getMessage() + " in an action input param ");
        }
        if (this.mServiceManager.isFeatureActive(CoolFeature.VALUE_HELP)) {
            try {
                repositoryManager.createStructureDesc(smDesc, this.mValueSetTableStructFieldRel);
            }
            catch (RuntimeException rte) {
                throw new RuntimeException(rte.getMessage() + " in a value set output structure");
            }
            try {
                repositoryManager.createStructureDesc(smDesc, this.mValueSetParamStructFieldRel);
            }
            catch (RuntimeException rte) {
                throw new RuntimeException(rte.getMessage() + " in a value set parameter structure");
            }
        }
        IEdoTable aspectTable = this.mAspectRel.getOutRecords();
        int count = aspectTable.getRecordCount();
        int i = 0;
        while (i < count) {
            if (aspectTable.getStringValue(i, "ASPECT_CATEGORY").equals("1")) {
                String aspectName = aspectTable.getStringValue(i, "ASPECT_NAME");
                StructureDescriptor structDesc = repositoryManager.getStructureDescriptor(aspectTable.getStringValue(i, "STRUCTURE"));
                if (structDesc == null) {
                    throw new RuntimeException("StructureDescriptor: " + aspectTable.getStringValue(i, "STRUCTURE") + " for Aspect " + aspectName + " not found ");
                }
                anAspectDesc = repositoryManager.getAspectDescriptor(aspectName);
                if (anAspectDesc != null) {
                    throw new IllegalStateException("Aspect '" + aspectName + "' already used in service module " + anAspectDesc.getServiceModuleDescriptor().getName() + "'");
                }
                anAspectDesc = new KeyAspectDescriptor(smDesc, aspectName, aspectTable.getStringValue(i, "DESCRIPTION"), structDesc);
                repositoryManager.putAspectDescriptor(anAspectDesc.getName(), anAspectDesc);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < count) {
            if (!aspectTable.getStringValue(i2, "ASPECT_CATEGORY").equals("1")) {
                String aspectName = aspectTable.getStringValue(i2, "ASPECT_NAME");
                StructureDescriptor structDesc = repositoryManager.getStructureDescriptor(aspectTable.getStringValue(i2, "STRUCTURE"));
                if (structDesc == null) {
                    throw new RuntimeException("StructureDescriptor: " + aspectTable.getStringValue(i2, "STRUCTURE") + " for Aspect " + aspectName + " not found ");
                }
                KeyAspectDescriptor aKeyDesc = (KeyAspectDescriptor)smDesc.getAspectDescriptor(aspectTable.getStringValue(i2, "KEY_ASPECT"));
                if (aKeyDesc == null) {
                    throw new RuntimeException("KeyDescriptor: " + aspectTable.getStringValue(i2, "KEY_ASPECT") + " for Aspect " + aspectName + " not found ");
                }
                anAspectDesc = repositoryManager.getAspectDescriptor(aspectName);
                if (anAspectDesc != null) {
                    throw new IllegalStateException("Aspect '" + aspectName + "' already used in service module " + anAspectDesc.getServiceModuleDescriptor().getName() + "'");
                }
                anAspectDesc = new AspectDescriptor(smDesc, aspectName, aspectTable.getStringValue(i2, "DESCRIPTION"), structDesc, aKeyDesc);
                aKeyDesc.addAspectDescriptor(anAspectDesc);
                repositoryManager.putAspectDescriptor(anAspectDesc.getName(), anAspectDesc);
            }
            ++i2;
        }
        IEdoIndexTable aspectActionIndex = this.mAspectActionRel.getRelations();
        IEdoTable aspectActionTable = this.mAspectActionRel.getOutRecords();
        count = aspectTable.getRecordCount();
        int aspectIndex = 0;
        while (aspectIndex < count) {
            int[] targetIndex = aspectActionIndex.getRelatedIndexes(aspectIndex);
            int j = 0;
            while (j < targetIndex.length) {
                int actionIndex = targetIndex[j];
                String actionName = aspectActionTable.getStringValue(actionIndex, "ACTION_NAME");
                String aspectName = aspectTable.getStringValue(aspectIndex, "ASPECT_NAME");
                anAspectDesc = (AspectDescriptor)smDesc.getAspectDescriptor(aspectName);
                if (anAspectDesc == null) {
                    _logger.warningT("Aspect '" + aspectName + "' for action '" + actionName + "' not found, skipping.");
                } else {
                    StructureDescriptor structDesc = null;
                    String structName = aspectActionTable.getStringValue(actionIndex, "PARAM_STRUCTURE");
                    if (!"".equals(structName) && (structDesc = repositoryManager.getStructureDescriptor(structName)) == null) {
                        throw new RuntimeException("StructureDescriptor: " + aspectActionTable.getStringValue(actionIndex, "PARAM_STRUCTURE") + " for Action '" + actionName + "' on Aspect '" + anAspectDesc.getName() + "' not found ");
                    }
                    AspectActionDescriptor actionDesc = new AspectActionDescriptor(actionName, structDesc, anAspectDesc);
                    anAspectDesc.addAspectActionDescriptor(actionDesc);
                }
                ++j;
            }
            ++aspectIndex;
        }
        IEdoTable aspectRelationTable = this.mAspectRelationRel.getOutRecords();
        IEdoIndexTable aspectRelationIndex = this.mAspectRelationRel.getRelations();
        count = aspectTable.getRecordCount();
        int aspectIndex2 = 0;
        while (aspectIndex2 < count) {
            int[] targetIndex = aspectRelationIndex.getRelatedIndexes(aspectIndex2);
            int j = 0;
            while (j < targetIndex.length) {
                int relationIndex = targetIndex[j];
                String relName = aspectRelationTable.getStringValue(relationIndex, "RELATION_NAME");
                String aspectName = aspectTable.getStringValue(aspectIndex2, "ASPECT_NAME");
                anAspectDesc = (AspectDescriptor)smDesc.getAspectDescriptor(aspectName);
                if (anAspectDesc == null) {
                    _logger.warningT("Source aspect '" + aspectName + "' of relation '" + relName + "' not found, skipping.");
                } else {
                    AspectDescriptor targetAspect = (AspectDescriptor)smDesc.getAspectDescriptor(aspectRelationTable.getStringValue(relationIndex, "TARGET_ASPECT"));
                    if (targetAspect == null) {
                        throw new RuntimeException("TargetAspectDescriptor: '" + aspectRelationTable.getStringValue(relationIndex, "TARGET_ASPECT") + "' for Relation '" + relName + "' on Aspect '" + anAspectDesc.getName() + "' not found ");
                    }
                    RelationDescriptor relDesc = new RelationDescriptor(relName, anAspectDesc, targetAspect);
                    anAspectDesc.addRelationDescriptor(relDesc);
                }
                ++j;
            }
            ++aspectIndex2;
        }
        IEdoTable queryRelTable0 = this.mQueryRel.getOutRecords();
        count = queryRelTable0.getRecordCount();
        int i3 = 0;
        while (i3 < count) {
            AspectDescriptor resultAspect = (AspectDescriptor)smDesc.getAspectDescriptor(queryRelTable0.getStringValue(i3, "RESULT_ASPECT"));
            if (resultAspect == null) {
                throw new RuntimeException("ResultAspect: " + queryRelTable0.getStringValue(i3, "RESULT_ASPECT") + " for Query " + queryRelTable0.getStringValue(i3, "QUERY_NAME") + " not found ");
            }
            StructureDescriptor structDesc = null;
            String structName = queryRelTable0.getStringValue(i3, "PARAM_STRUCTURE");
            if (!"".equals(structName) && (structDesc = repositoryManager.getStructureDescriptor(structName)) == null) {
                throw new RuntimeException("StructureDescriptor: " + queryRelTable0.getStringValue(i3, "PARAM_STRUCTURE") + " for Query " + queryRelTable0.getStringValue(i3, "QUERY_NAME") + " not found ");
            }
            QueryDescriptor aQueryDesc = new QueryDescriptor(queryRelTable0.getStringValue(i3, "QUERY_NAME"), queryRelTable0.getStringValue(i3, "DESCRIPTION"), (KeyAspectDescriptor)smDesc.getAspectDescriptor(queryRelTable0.getStringValue(i3, "INPUT_KEY_ASPECT")), structDesc, resultAspect, smDesc);
            smDesc.addQueryDescriptor(aQueryDesc);
            ++i3;
        }
        if (this.mServiceManager.isFeatureActive(CoolFeature.VALUE_HELP)) {
            IEdoTable valueSets = this.mAspectValueHelpRel.getOutRecords();
            int i4 = 0;
            while (i4 < valueSets.getRecordCount()) {
                String valueSetName = valueSets.getStringValue(i4, "VALUE_SET_NAME");
                String aspectName = valueSets.getStringValue(i4, "ASPECT_NAME");
                String fieldName = valueSets.getStringValue(i4, "FIELDNAME");
                String inparamStructName = valueSets.getStringValue(i4, "PARAM_STRUCTURE");
                String outvalStructName = valueSets.getStringValue(i4, "OUTVAL_STRUCTURE");
                AspectDescriptor aspect = (AspectDescriptor)smDesc.getAspectDescriptor(aspectName);
                if (aspect == null) {
                    throw new RuntimeException("AspectDescriptor " + aspectName + " not found for Value Set " + valueSetName + " in Field " + fieldName);
                }
                FieldDescriptor field = (FieldDescriptor)aspect.getStructure().getFieldDescriptor(fieldName);
                if (field == null) {
                    throw new RuntimeException("FieldDescriptor " + fieldName + " not found for Value Set " + valueSetName + " in Aspect " + aspectName);
                }
                StructureDescriptor inparamStruct = repositoryManager.getStructureDescriptor(inparamStructName);
                StructureDescriptor outvalStruct = repositoryManager.getStructureDescriptor(outvalStructName);
                if (field == null) {
                    throw new RuntimeException("StructureDescriptor " + outvalStruct + " not found for Output Values of Value Set " + valueSetName + " in Aspect " + aspectName + ", Field " + fieldName);
                }
                ValueSetDescriptor valueSet = new ValueSetDescriptor(valueSetName, aspect, field, inparamStruct, outvalStruct);
                ++i4;
            }
        }
        IEdoTable modPropertyResult = this.mServiceModulePropertyRel.getOutRecords();
        boolean subSubLevel = modPropertyResult.getDescriptor().hasField("SUBSUB_ELEM_NAME");
        int i5 = 0;
        while (i5 < modPropertyResult.getRecordCount()) {
            int subElemType = modPropertyResult.getIntValue(i5, "SUB_ELEM_TYPE");
            String subElemName = modPropertyResult.getStringValue(i5, "SUB_ELEM_NAME");
            int subSubType = 0;
            String subSubName = "";
            if (subSubLevel) {
                subSubType = modPropertyResult.getIntValue(i5, "SUBSUB_ELEM_TYPE");
                subSubName = modPropertyResult.getStringValue(i5, "SUBSUB_ELEM_NAME");
            }
            String attributeName = modPropertyResult.getStringValue(i5, "PROPERTY_NAME");
            String attributeValue = modPropertyResult.getStringValue(i5, "PROPERTY_VALUE");
            block5 : switch (subElemType) {
                case 0: {
                    smDesc.addAttribute(attributeName, attributeValue);
                    break;
                }
                case 15: {
                    QueryDescriptor query = (QueryDescriptor)smDesc.getQueryDescriptor(subElemName);
                    if (query == null) {
                        if (!_logger.beWarning()) break;
                        _logger.warningT("No such query: '" + subElemName + "' (skipped)");
                        break;
                    }
                    if (!subSubLevel) {
                        subSubType = 0;
                    }
                    switch (subSubType) {
                        case 0: {
                            query.addAttribute(attributeName, attributeValue);
                            break block5;
                        }
                        case 16: {
                            query.addFieldAttribute(subSubName, attributeName, attributeValue);
                            break block5;
                        }
                    }
                    if (!_logger.beWarning()) break;
                    _logger.warningT("Illegal sub sub element type: " + subSubType + " for aspect action property, skipping");
                    break;
                }
                default: {
                    if (!_logger.beWarning()) break;
                    _logger.warningT("Illegal sub element type: " + subElemType + " for service module property (skipped)");
                }
            }
            ++i5;
        }
        if (!this.mServiceManager.isFeatureActive(CoolFeature.ASPECT_RELATIONS)) {
            IEdoTable relPropertyResult = this.mRelationPropertyRel.getOutRecords();
            IEdoIndexTable relPropertyIndex = this.mRelationPropertyRel.getRelations();
            int relIndex = 0;
            while (relIndex < aspectRelationTable.getRecordCount()) {
                String relName = aspectRelationTable.getStringValue(relIndex, "RELATION_NAME");
                RelationDescriptor relDesc = (RelationDescriptor)smDesc.getRelationDescriptor(relName);
                if (relDesc != null) {
                    propIndices = relPropertyIndex.getRelatedIndexes(relIndex);
                    int i6 = 0;
                    while (i6 < propIndices.length) {
                        int propIndex = propIndices[i6];
                        int subElemType = relPropertyResult.getIntValue(propIndex, "SUB_ELEM_TYPE");
                        if (subElemType == 0) {
                            relDesc.addAttribute(relPropertyResult.getStringValue(propIndex, "PROPERTY_NAME"), relPropertyResult.getStringValue(propIndex, "PROPERTY_VALUE"));
                        } else if (_logger.beWarning()) {
                            _logger.warningT("Illegal sub element type: " + subElemType + " for relation property, skipping");
                        }
                        ++i6;
                    }
                } else if (_logger.beWarning()) {
                    _logger.warningT("Relation '" + relName + "' not found, skipping");
                }
                ++relIndex;
            }
        }
        IEdoTable aspectPropertyResult = this.mAspectPropertyRel.getOutRecords();
        IEdoIndexTable aspectPropertyIndex = this.mAspectPropertyRel.getRelations();
        subSubLevel = aspectPropertyResult.getDescriptor().hasField("SUBSUB_ELEM_NAME");
        int aspIndex = 0;
        while (aspIndex < aspectTable.getRecordCount()) {
            String aspName = aspectTable.getStringValue(aspIndex, "ASPECT_NAME");
            AspectDescriptor aspDesc = (AspectDescriptor)smDesc.getAspectDescriptor(aspName);
            if (aspDesc != null) {
                propIndices = aspectPropertyIndex.getRelatedIndexes(aspIndex);
                int i7 = 0;
                while (i7 < propIndices.length) {
                    int propIndex = propIndices[i7];
                    int subElemType = aspectPropertyResult.getIntValue(propIndex, "SUB_ELEM_TYPE");
                    String subElemName = aspectPropertyResult.getStringValue(propIndex, "SUB_ELEM_NAME");
                    int subSubType = 0;
                    String subSubName = "";
                    if (subSubLevel) {
                        subSubType = aspectPropertyResult.getIntValue(propIndex, "SUBSUB_ELEM_TYPE");
                        subSubName = aspectPropertyResult.getStringValue(propIndex, "SUBSUB_ELEM_NAME");
                    }
                    String attributeName = aspectPropertyResult.getStringValue(propIndex, "PROPERTY_NAME");
                    String attributeValue = aspectPropertyResult.getStringValue(propIndex, "PROPERTY_VALUE");
                    block13 : switch (subElemType) {
                        case 0: {
                            aspDesc.addAttribute(attributeName, attributeValue);
                            break;
                        }
                        case 13: {
                            aspDesc.addFieldAttribute(subElemName, attributeName, attributeValue);
                            break;
                        }
                        case 11: {
                            if (!subSubLevel) {
                                subSubType = 0;
                            }
                            switch (subSubType) {
                                case 0: {
                                    aspDesc.addActionAttribute(subElemName, attributeName, attributeValue);
                                    break;
                                }
                                case 14: {
                                    AspectActionDescriptor actionDesc = (AspectActionDescriptor)aspDesc.getAspectActionDescriptor(subElemName);
                                    if (actionDesc == null) {
                                        if (!_logger.beWarning()) break block13;
                                        _logger.warningT("No such aspect action: '" + subElemName + "' in ascpect '" + aspName + "' (skipped)");
                                        break;
                                    }
                                    actionDesc.addFieldAttribute(subSubName, attributeName, attributeValue);
                                    break;
                                }
                                default: {
                                    if (!_logger.beWarning()) break block13;
                                    _logger.warningT("Illegal sub sub element type: " + subSubType + " for aspect action property, skipping");
                                    break;
                                }
                            }
                            break;
                        }
                        case 3: {
                            RelationDescriptor relDesc = (RelationDescriptor)aspDesc.getRelationDescriptor(subElemName);
                            if (relDesc == null) {
                                if (!_logger.beWarning()) break;
                                _logger.warningT("No such aspect relation: '" + subElemName + "' in ascpect '" + aspName + "' (skipped)");
                                break;
                            }
                            relDesc.addAttribute(attributeName, attributeValue);
                            break;
                        }
                        default: {
                            if (!_logger.beWarning()) break;
                            _logger.warningT("Illegal sub element type: " + subElemType + " for aspect property, skipping");
                        }
                    }
                    ++i7;
                }
            } else if (_logger.beWarning()) {
                _logger.warningT("Aspect '" + aspName + "' not found, skipping");
            }
            ++aspIndex;
        }
        IEdoTable modGroupsResult = this.mServiceModuleGroupsRel.getOutRecords();
        IEdoIndexTable modGroupMemberIndex = this.mServiceModuleGroupMembersRel.getRelations();
        IEdoTable modGroupMemberTable = this.mServiceModuleGroupMembersRel.getOutRecords();
        int groupIndex = 0;
        while (groupIndex < modGroupsResult.getRecordCount()) {
            ServiceModuleGroupDescriptor modGroup = new ServiceModuleGroupDescriptor(modGroupsResult.getStringValue(groupIndex, "GROUP_NAME"), smDesc);
            int[] memberIndices = modGroupMemberIndex.getRelatedIndexes(groupIndex);
            int j = 0;
            while (j < memberIndices.length) {
                int memberIndex = memberIndices[j];
                String membername = modGroupMemberTable.getStringValue(memberIndex, "MEMBER");
                int membertype = new Integer(modGroupMemberTable.getStringValue(memberIndex, "MEMBER_TYPE"));
                switch (membertype) {
                    case 2: {
                        AspectDescriptor aspdesc = (AspectDescriptor)smDesc.getAspectDescriptor(membername);
                        if (aspdesc != null) {
                            modGroup.addAspectDescriptor(aspdesc);
                            break;
                        }
                        _logger.warningT("No such aspect: '" + membername + "' (skipped)");
                        break;
                    }
                    case 15: {
                        modGroup.addQueryDescriptor((QueryDescriptor)smDesc.getQueryDescriptor(membername));
                        QueryDescriptor qrdesc = (QueryDescriptor)smDesc.getQueryDescriptor(membername);
                        if (qrdesc != null) {
                            modGroup.addQueryDescriptor(qrdesc);
                            break;
                        }
                        _logger.warningT("No such query: '" + membername + "' (skipped)");
                        break;
                    }
                    default: {
                        _logger.warningT("Group member type " + membertype + " not allowed for service module groups, skipping member '" + membername + "'");
                    }
                }
                ++j;
            }
            ++groupIndex;
        }
        IEdoTable aspectGroupTable = this.mAspectGroupsRel.getOutRecords();
        IEdoIndexTable aspectGroupIndex = this.mAspectGroupsRel.getRelations();
        IEdoTable aspectGroupMemberTable = this.mAspectGroupMembersRel.getOutRecords();
        IEdoIndexTable aspectGroupMemberIndex = this.mAspectGroupMembersRel.getRelations();
        count = aspectTable.getRecordCount();
        int aspectIndex3 = 0;
        while (aspectIndex3 < count) {
            AspectDescriptor aspectDesc = (AspectDescriptor)smDesc.getAspectDescriptor(aspectTable.getStringValue(aspectIndex3, "ASPECT_NAME"));
            int[] groupIndices = aspectGroupIndex.getRelatedIndexes(aspectIndex3);
            int i8 = 0;
            while (i8 < groupIndices.length) {
                int groupIndex2 = groupIndices[i8];
                AspectGroupDescriptor aspectGroup = new AspectGroupDescriptor(aspectGroupTable.getStringValue(groupIndex2, "GROUP_NAME"), aspectDesc);
                int[] memberIndices = aspectGroupMemberIndex.getRelatedIndexes(groupIndex2);
                int j = 0;
                while (j < memberIndices.length) {
                    int memberIndex = memberIndices[j];
                    String membername = aspectGroupMemberTable.getStringValue(memberIndex, "MEMBER");
                    int membertype = new Integer(aspectGroupMemberTable.getStringValue(memberIndex, "MEMBER_TYPE"));
                    switch (membertype) {
                        case 3: {
                            RelationDescriptor reldesc = (RelationDescriptor)aspectDesc.getRelationDescriptor(membername);
                            if (reldesc != null) {
                                aspectGroup.addRelationDescriptor(reldesc);
                                break;
                            }
                            _logger.warningT("No such relation: '" + membername + "' (skipped)");
                            break;
                        }
                        case 11: {
                            AspectActionDescriptor actdesc = (AspectActionDescriptor)aspectDesc.getAspectActionDescriptor(membername);
                            if (actdesc != null) {
                                aspectGroup.addAspectActionDescriptor(actdesc);
                                break;
                            }
                            _logger.warningT("No such aspect action: '" + membername + "' in aspect '" + aspectDesc.getName() + "' (skipped)");
                            break;
                        }
                        case 13: {
                            FieldDescriptor fielddesc = (FieldDescriptor)aspectDesc.getStructure().getFieldDescriptor(membername);
                            if (fielddesc != null) {
                                aspectGroup.addFieldDescriptor(fielddesc);
                                break;
                            }
                            _logger.warningT("No such aspect action: '" + membername + "' in aspect '" + aspectDesc.getName() + "' (skipped)");
                            break;
                        }
                        default: {
                            _logger.warningT("Group member type " + membertype + " not allowed for aspect groups, skipping member '" + membername + "'");
                        }
                    }
                    ++j;
                }
                ++i8;
            }
            ++aspectIndex3;
        }
        repositoryManager.putServiceModuleDescriptor(this.mServiceModuleName, smDesc);
        this.clearCallObjects();
        return smDesc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

