/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core;

import com.sap.tc.col.servicemanager.api.ICoolObjectKey;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.core.CoolObjectKey;
import com.sap.tc.logging.Location;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SrvMgrMessage
implements ISrvMgrMessage {
    private static final Location _logger = Location.getLocation((Class)(class$com$sap$tc$col$servicemanager$core$SrvMgrMessageHandler == null ? (class$com$sap$tc$col$servicemanager$core$SrvMgrMessageHandler = SrvMgrMessage.class$("com.sap.tc.col.servicemanager.core.SrvMgrMessageHandler")) : class$com$sap$tc$col$servicemanager$core$SrvMgrMessageHandler));
    private boolean outbound;
    private int mMessageType;
    private int mMessageCategory;
    private String mMessageCode;
    private String mMessageText;
    private boolean mFailed;
    private int mInRecordIndex;
    private String mMessageVariables;
    private String mAspectName;
    private String mFieldName;
    private ICoolObjectKey mObjectKey;
    private String mExtension;
    private HashMap mfieldValues;
    static /* synthetic */ Class class$com$sap$tc$col$servicemanager$core$SrvMgrMessageHandler;

    SrvMgrMessage(int messageType, int messageCategory, String messageCode, String messageText, boolean failed, int inRecordIndex, String messageVariables, String aspectName, String fieldName, String aspectRowKey, String extension) {
        this.mMessageType = messageType;
        this.mMessageCategory = messageCategory;
        this.mMessageCode = messageCode;
        this.mMessageText = messageText;
        this.mFailed = failed;
        this.mInRecordIndex = inRecordIndex;
        this.mMessageVariables = messageVariables;
        this.mAspectName = aspectName;
        this.mFieldName = fieldName;
        this.mObjectKey = new CoolObjectKey(aspectRowKey);
        this.mExtension = extension;
        this.mfieldValues = null;
    }

    private String typeToString() {
        switch (this.mMessageType) {
            case 0: {
                return "Info";
            }
            case 1: {
                return "Warning";
            }
            case 2: {
                return "Error";
            }
        }
        return "";
    }

    public String toString() {
        String str = "Text: " + this.mMessageText + "\ntype: " + this.typeToString() + "  OutOfBand: " + this.isOutbound() + "  failed:" + this.mFailed + "  inrecordIndex::" + this.mInRecordIndex + "  code:" + this.mMessageCode + "  vars:" + this.mMessageVariables + "\naspect:" + this.mAspectName + "\naspectField:" + this.mFieldName + "  aspectKey:" + this.getAspectKey() + "\nExtension" + this.mExtension;
        return str;
    }

    public boolean isOutbound() {
        return this.outbound;
    }

    public void setOutbound(boolean outbound) {
        this.outbound = outbound;
    }

    public String getAspectName() {
        return this.mAspectName;
    }

    public String getAspectField() {
        return this.mFieldName;
    }

    public ICoolObjectKey getCoolObjectKey() {
        return this.mObjectKey;
    }

    public String getCode() {
        return this.mMessageCode;
    }

    public Object getExtension() {
        return this.mExtension;
    }

    public boolean isFailed() {
        return this.mFailed;
    }

    public int getInrecordIndex() {
        return this.mInRecordIndex;
    }

    public String getText() {
        return this.mMessageText;
    }

    public int getType() {
        return this.mMessageType;
    }

    public int getCategory() {
        return this.mMessageCategory;
    }

    public String getVars() {
        return this.mMessageVariables;
    }

    public String[] getVarsAsArray() {
        String varStr = this.getVars();
        if (varStr == null || varStr.length() == 0) {
            return new String[0];
        }
        StringTokenizer varTok = new StringTokenizer(varStr, "&");
        String[] allVars = null;
        int varNum = varTok.countTokens();
        allVars = new String[varNum];
        int i = 0;
        while (i < varNum) {
            allVars[i] = URLDecoder.decode(varTok.nextToken());
            ++i;
        }
        return allVars;
    }

    public boolean isError() {
        return this.getType() == 2;
    }

    public boolean isWarning() {
        return this.getType() == 1;
    }

    public boolean isInfo() {
        return this.getType() == 0;
    }

    public String getAspectKey() {
        return this.mObjectKey.getUrl();
    }

    public String getAspectKeySID() {
        return "";
    }

    public String getAspectKeyServiceModule() {
        return "";
    }

    public String getAspectKeyAspect() {
        return this.mObjectKey.getAspect();
    }

    public String[] getAspectKeyFields() {
        return this.mObjectKey.getFieldValues();
    }

    public boolean equals(Object obj) {
        SrvMgrMessage message = (SrvMgrMessage)obj;
        return this == message || (this.mMessageCode == message.mMessageCode || this.mMessageCode != null && this.mMessageCode.equals(message.mMessageCode)) && (this.mMessageText == message.mMessageText || this.mMessageText != null && this.mMessageText.equals(message.mMessageText)) && (this.mExtension == message.mExtension || this.mExtension != null && this.mExtension.equals(message.mExtension)) && (this.mAspectName == message.mAspectName || this.mAspectName != null && this.mAspectName.equals(message.mAspectName)) && (this.mObjectKey == message.mObjectKey || this.mObjectKey != null && this.mObjectKey.equals(message.mObjectKey)) && (this.mFieldName == message.mFieldName || this.mFieldName != null && this.mFieldName.equals(message.mFieldName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.cool.servicemanager").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_servicemanager/java/com/sap/tc/col/servicemanager/core/SrvMgrMessage.java#1 $");
    }
}

