/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core;

import com.sap.tc.col.servicemanager.core.CoolFeature;
import java.util.HashMap;

class CoolVersion
implements Comparable {
    public static final String VERSION_0_1 = "0000000000.0000000001";
    public static final String VERSION_0_2 = "0000000000.0000000002";
    public static final String VERSION_640 = "640.";
    public static final String VERSION_700 = "700.0000000001";
    private static CoolVersion theCurrentFrontendVersion = null;
    private String mVersion;
    private String mImplementationVersion;
    private HashMap mSupportedFeatures;

    public static CoolVersion getCurrentCoolVersion() {
        if (theCurrentFrontendVersion == null) {
            theCurrentFrontendVersion = new CoolVersion(VERSION_640);
        }
        return theCurrentFrontendVersion;
    }

    CoolVersion(String versionNumber) {
        int dot = versionNumber.indexOf(46);
        int dot2 = versionNumber.indexOf(46, dot + 1);
        if (dot2 >= 0) {
            this.mVersion = versionNumber.substring(0, dot2);
            this.mImplementationVersion = versionNumber.substring(dot2 + 1);
        } else {
            this.mVersion = versionNumber;
            this.mImplementationVersion = "";
        }
        this.mSupportedFeatures = null;
    }

    public String getVersionNumber() {
        return this.mVersion;
    }

    public CoolFeature[] getSupportedFeatures() {
        if (this.mSupportedFeatures == null) {
            this.buildFeatureMap();
        }
        CoolFeature[] supportedFeatures = new CoolFeature[this.mSupportedFeatures.size()];
        this.mSupportedFeatures.values().toArray(supportedFeatures);
        return supportedFeatures;
    }

    public String[] getSupportedFeatureNames() {
        if (this.mSupportedFeatures == null) {
            this.buildFeatureMap();
        }
        String[] supportedFeatures = new String[this.mSupportedFeatures.size()];
        this.mSupportedFeatures.keySet().toArray(supportedFeatures);
        return supportedFeatures;
    }

    public boolean isFeatureSupported(String featureName) {
        return CoolFeature.isSupportedInVersion(featureName, this.mVersion);
    }

    public int compareTo(Object o) {
        return this.getVersionNumber().compareTo(((CoolVersion)o).getVersionNumber());
    }

    private void buildFeatureMap() {
        this.mSupportedFeatures = new HashMap();
        CoolFeature[] knownFeatures = CoolFeature.getKnownFeatures();
        int i = 0;
        while (i < knownFeatures.length) {
            if (knownFeatures[i].isSupportedInVersion(this.mVersion)) {
                this.mSupportedFeatures.put(knownFeatures[i].getName(), knownFeatures[i]);
            }
            ++i;
        }
    }
}

