/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.servicemanager.core;

import com.sap.tc.col.servicemanager.api.ICoolObjectKey;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.Vector;

public class CoolObjectKey
implements ICoolObjectKey {
    private String mUrl;
    private String mAspect;
    private String[] mFieldValues;
    private static final String SEPERATOR = "1KEY";

    CoolObjectKey(String url) {
        this.mUrl = url;
        this.mAspect = null;
        this.mFieldValues = null;
    }

    public String getUrl() {
        if (this.mAspect == null) {
            this.decodeUrlFields();
        }
        return CoolObjectKey.buildRelativeAspectRowKey(this.mAspect, this.mFieldValues);
    }

    public String getAspect() {
        if (this.mAspect == null) {
            this.decodeUrlFields();
        }
        return this.mAspect;
    }

    public String[] getFieldValues() {
        if (this.mFieldValues == null) {
            this.decodeUrlFields();
        }
        return this.mFieldValues;
    }

    private void decodeUrlFields() {
        Vector<String> tokens = new Vector<String>();
        StringTokenizer aspectTok = new StringTokenizer(this.mUrl, "/", true);
        String lastToken = "";
        while (aspectTok.hasMoreTokens()) {
            String thisToken = aspectTok.nextToken();
            if ("/".equals(thisToken)) {
                if ("/".equals(lastToken)) {
                    tokens.add("");
                }
            } else {
                tokens.add(URLDecoder.decode(thisToken));
            }
            lastToken = thisToken;
        }
        int sepIndex = tokens.indexOf(SEPERATOR);
        if (sepIndex < 1) {
            this.mAspect = "";
            this.mFieldValues = new String[0];
        } else {
            this.mAspect = (String)tokens.get(sepIndex - 1);
            this.mFieldValues = new String[tokens.size() - (sepIndex + 1)];
            tokens.subList(sepIndex + 1, tokens.size()).toArray(this.mFieldValues);
        }
    }

    public boolean equals(Object obj) {
        CoolObjectKey key = (CoolObjectKey)obj;
        return this == key || this.mUrl == key.mUrl || this.mUrl != null && this.mUrl.equals(key.mUrl);
    }

    static String buildRelativeAspectRowKey(String aspectName, String[] values) {
        if (aspectName == null || "".equals(aspectName)) {
            return "";
        }
        StringBuffer buf = new StringBuffer(100);
        buf.append("/").append(URLEncoder.encode(aspectName)).append("/1KEY");
        int i = 0;
        while (i < values.length) {
            buf.append("/");
            if (values[i] != null) {
                buf.append(URLEncoder.encode(values[i]));
            }
            ++i;
        }
        return buf.toString();
    }
}

