/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.webservices;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.PPCollector;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildplugin.util.Descriptors;
import com.sap.tc.buildplugin.util.JlinUtils;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    File pluginRoot;
    DirsAndFiles daf;
    FileCreator fCreator;
    int currentStep;
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$webservices$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$webservices$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.webservices.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$webservices$CreateBuildFileAction));
    int br = 0;
    String errMsg = "";
    private IBuildInfo buildInfo;
    Descriptors descriptors = new Descriptors();
    JlinUtils jlinUtils;
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$webservices$CreateBuildFileAction;

    CreateBuildFileAction(FileCreator fc, int step, IBuildInfo buildInfo) {
        this.fCreator = fc;
        this.daf = fc.getDaf();
        this.currentStep = step;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
        this.jlinUtils = new JlinUtils(buildInfo);
    }

    public BuildActionResult execute() {
        this.loc.infoT("Web Service Plugin starts creating the build file");
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        switch (this.currentStep) {
            case 1: {
                this.daf.setBuildFile("prebuild.xml");
                this.fCreator.setMacroName("prebuild.vm");
                break;
            }
            case 2: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
                break;
            }
            case 3: {
                this.daf.setBuildFile("postbuild.xml");
                this.fCreator.setMacroName("postbuild.vm");
                break;
            }
            default: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
            }
        }
        String prebuildDir = this.daf.getTempDir() + File.separator + "pre";
        this.fCreator.setStrContext("dc_prebuild_Dir", prebuildDir);
        File prebuildDirF = new File(prebuildDir);
        if (prebuildDirF.exists()) {
            this.fCreator.setStrContext("dc_prebuild_Dir_exist", "true");
        }
        String dcSubType = this.daf.getDcSubtype();
        this.fCreator.setStrContext("dc_sub_type", dcSubType);
        Map ppMap = this.daf.getPublicParts();
        if (ppMap != null) {
            PPCollector pp = new PPCollector(componentInfo);
            this.br = pp.addData(ppMap);
            this.errMsg = pp.getErrorMsg();
            this.fCreator.setListContext("dc_public_parts", pp.getList());
        }
        this.fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        List dependDirs = this.daf.getDependDirs();
        HashMap<String, String> AntPropsDependDirs = new HashMap<String, String>();
        ArrayList<String> AntPropsDependJars = new ArrayList<String>();
        if (dependDirs != null) {
            Iterator it = dependDirs.iterator();
            int no = 0;
            while (it.hasNext()) {
                String dir = (String)it.next();
                AntPropsDependDirs.put("dependDir_" + ++no, dir);
                File dirFile = new File(dir);
                if (!dirFile.exists()) continue;
                String[] allFilesInFolder = dirFile.list();
                int i = 0;
                while (i < allFilesInFolder.length) {
                    String curFileName = dir + File.separator + allFilesInFolder[i];
                    if (curFileName.endsWith(".jar") || curFileName.endsWith(".zip")) {
                        AntPropsDependJars.add(curFileName);
                    }
                    ++i;
                }
            }
        }
        this.fCreator.setHashMapContext("dc_depend_compileDirs", AntPropsDependDirs);
        this.fCreator.setHashMapContext("dc_depend_compile_dirs", AntPropsDependDirs);
        this.fCreator.setListContext("dc_depend_compileArchives", AntPropsDependJars);
        List packageDirs = this.daf.getPackageDirs();
        this.fCreator.setListContext("dc_packageDirs", packageDirs);
        List sourceDirs = this.daf.getSourceDirs();
        this.fCreator.setListContext("dc_sourceDirs", sourceDirs);
        this.fCreator.setStrContext("dc_gen_classesDir", this.daf.getClassesDir());
        this.fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_gen_logDir", this.daf.getLogDir());
        this.fCreator.setStrContext("dc_deploy_Dir", this.daf.getGenDirDeploy());
        this.fCreator.setStrContext("dc_deploy_File", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        String genDirPublic = this.daf.getGenDirPublic();
        this.fCreator.setStrContext("dc_gen_publicDir", genDirPublic);
        this.fCreator.setStrContext("dc_gen_public_dir", genDirPublic);
        try {
            this.fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            String msg = "pluginhandler does not supply getCompilerExecutable";
            this.loc.traceThrowableT(300, msg, (Throwable)ex);
        }
        this.jlinUtils.insertJlinContext(this.fCreator);
        if (dcSubType.equalsIgnoreCase("Deployable Proxy")) {
            String tempMetaInf = this.daf.getTempDir() + File.separator + "META-INF";
            File tempMetaInfDir = new File(tempMetaInf);
            if (!tempMetaInfDir.exists()) {
                tempMetaInfDir.mkdirs();
            }
            String sdaXmlFile = tempMetaInf + File.separator + "sda-dd.xml";
            try {
                this.descriptors.genSdaXml(sdaXmlFile);
            }
            catch (IOException io) {
                String msg = "error generating sda-dd.xml";
                this.loc.traceThrowableT(500, msg, (Throwable)io);
                this.br = 2;
            }
            this.fCreator.setStrContext("sda_descriptor_file", sdaXmlFile);
        }
        HashMap buildOptions = this.daf.getBuildOptions();
        this.fCreator.setHashMapContext("dc_build_options", buildOptions);
        this.fCreator.setHashMapContext("dc_jdo_files", this.daf.getJdoMap());
        if (this.daf.hasSQLJ()) {
            this.fCreator.setStrContext("sqlj_exist", "true");
        } else {
            this.fCreator.setStrContext("sqlj_exist", "false");
        }
        this.fCreator.setStrContext("dc_jarSAP_location", this.daf.getCBSLocation());
        this.fCreator.setStrContext("dc_jarSAP_counter", this.daf.getCBSCounter());
        this.fCreator.setStrContext("dc_jarSAP_vendor", this.daf.getDCVendor());
        this.fCreator.setStrContext("dc_jarSAP_name", this.daf.getDCName());
        this.fCreator.setStrContext("dc_jarSAP_scvendor", componentInfo.getCompartment().getScVendor());
        this.fCreator.setStrContext("dc_jarSAP_scname", componentInfo.getCompartment().getScName());
        String mfName = this.daf.getTempDir() + File.separator + "Manifest.mf";
        this.daf.createManifestFile(mfName);
        this.fCreator.setStrContext("bi_manifest_Name", mfName);
        if (this.br != 2 && this.br != 3) {
            this.fCreator.createBuildFile();
        } else {
            LogFile log = new LogFile();
            log.setErrorMessage(this.errMsg);
            log.writeLogFile(this.daf.getLogFile());
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

