/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.rmi;

import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import pios.emulator.PEmuProps;
import pios.emulator.rmi.RMIException;
import pios.emulator.rmi.RMINotBoundException;

public class RemoteProxy {
    public static final String LOCALHOST = "localhost";
    protected static String host = null;
    private static final int maxRetries = 2;
    private static final int retrySleep = 1000;

    private static Remote registryLookup(Registry registry, String string) throws RMIException {
        Remote remote = null;
        int n = 0;
        while (n < 2) {
            block7: {
                try {
                    remote = registry.lookup(string);
                }
                catch (NotBoundException notBoundException) {
                    if (n + 1 == 2) {
                        throw new RMINotBoundException(notBoundException.getMessage());
                    }
                }
                catch (RemoteException remoteException) {
                    if (n + 1 != 2) break block7;
                    throw new RMIException(remoteException.getMessage());
                }
            }
            if (remote != null) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            ++n;
        }
        return remote;
    }

    public static synchronized Remote getProxy(String string) throws RMIException {
        Registry registry = null;
        try {
            String string2 = PEmuProps.getInstance().getRemoteProxyHost();
            int n = PEmuProps.getInstance().getRemoteProxyPort();
            registry = LocateRegistry.getRegistry(string2, n);
            if (registry == null) {
                throw new RMIException("Unable to get remote registry." + string2 + ":" + n);
            }
        }
        catch (Exception exception) {
            throw new RMIException("Unable to get remote registry: " + exception.getMessage());
        }
        return RemoteProxy.registryLookup(registry, string);
    }
}

