/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.printer.rmi;

import java.io.Serializable;

public class BarcodeParametersRMI
implements Serializable {
    String symbologyName;
    byte[] userDataStream;
    int symbologyTypeId = -1;
    long symbologyOptions;
    long barcodeOptions;
    double scale = 1.0;
    private double height;
    private double narrowElementWidth;
    double wideToNarrowRatio = 1.0;
    private double interCharGap = 0.0;
    private double interBarGap = 0.0;
    private double moduleX;
    private double rowHeight;
    int rows;
    int columns;
    double widthMM;
    double heightMM;

    public BarcodeParametersRMI(String string, long l, byte[] byArray, long l2) {
        this.symbologyName = string;
        this.userDataStream = byArray;
        this.setOptions(l2);
        this.symbologyOptions = l;
    }

    private void setOptions(long l) {
        this.barcodeOptions = l;
    }

    public void setSymbologyTypeId(int n) {
        this.symbologyTypeId = n;
    }

    public void setLinearParameters(double d, double d2, double d3, double d4, double d5) {
        this.height = d;
        this.narrowElementWidth = d2;
        this.wideToNarrowRatio = d3;
        this.interCharGap = d4;
        this.interBarGap = d5;
    }

    public void setSizeByMM(double d, double d2) {
        this.widthMM = d;
        this.heightMM = d2;
    }

    public void setModuleSize(double d, double d2) {
        this.moduleX = d;
        this.rowHeight = d2;
    }

    public void setModuleArray(int n, int n2) {
        this.rows = n2;
        this.columns = n;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getNarrowElementWidth(boolean bl) {
        return bl ? this.scale * this.narrowElementWidth : this.narrowElementWidth;
    }

    public double getModuleX(boolean bl) {
        return bl ? this.scale * this.moduleX : this.moduleX;
    }

    public double getRowHeight(boolean bl) {
        return bl ? this.scale * this.rowHeight : this.rowHeight;
    }

    public double getInterCharGap(boolean bl) {
        return bl ? this.scale * this.interCharGap : this.interCharGap;
    }

    public double getInterBarGap(boolean bl) {
        return bl ? this.scale * this.interBarGap : this.interBarGap;
    }

    public double getHeight(boolean bl) {
        return bl ? this.scale * this.height : this.height;
    }
}

