/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.impl.emulator.printer;

import com.sap.ip.me.api.pios.UnsupportedException;
import com.sap.ip.me.api.pios.printer.Accessor;
import com.sap.ip.me.api.pios.printer.Metrics;
import com.sap.ip.me.api.pios.printer.PrinterException;
import com.sap.ip.me.api.pios.printer.PrinterImage;

public final class PrinterImageImpl
extends PrinterImage {
    public static final int MAX_LENGTH = 16;
    private Metrics metrics;
    private int printerDPI;

    public PrinterImageImpl(String string, int n, byte[] byArray, int n2) throws PrinterException, UnsupportedException {
        super(string, n, byArray);
        this.printerDPI = n2;
        if (0 == string.length()) {
            throw new PrinterException("Invalid Image Name:" + string);
        }
        switch (n) {
            case 1: {
                this.decodeBMP();
                break;
            }
            case 2: {
                this.decodePCX();
                break;
            }
            default: {
                throw new PrinterException("Invalid image type:" + n);
            }
        }
    }

    private void decodeBMP() throws PrinterException {
        byte by = this.getBytes()[0];
        byte by2 = this.getBytes()[1];
        if (by != 66 || by2 != 77) {
            throw new PrinterException("Invalid bitmap format");
        }
        int n = this.getIntLittleEndian(18);
        int n2 = this.getIntLittleEndian(22);
        int n3 = this.getIntLittleEndian(38);
        int n4 = this.getIntLittleEndian(42);
        float f = this.toPointMeter(n, n3);
        float f2 = this.toPointMeter(n2, n4);
        this.metrics = Accessor.createMetrics(f, f2);
    }

    private void decodePCX() throws PrinterException {
        byte by = this.getBytes()[0];
        if (by != 10) {
            throw new PrinterException("Invalid PCX format");
        }
        int n = this.getShortLittleEndian(4);
        int n2 = this.getShortLittleEndian(6);
        int n3 = this.getShortLittleEndian(8);
        int n4 = this.getShortLittleEndian(10);
        int n5 = this.getShortLittleEndian(12);
        int n6 = this.getShortLittleEndian(14);
        float f = this.toPointInch(n3 - n, n5);
        float f2 = this.toPointInch(n4 - n2, n6);
        this.metrics = Accessor.createMetrics(f, f2);
    }

    public Metrics getMetrics() throws PrinterException {
        return this.metrics;
    }

    private int getIntLittleEndian(int n) {
        byte[] byArray = this.getBytes();
        return (byArray[n + 3] & 0xFF) << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    private int getShortLittleEndian(int n) {
        byte[] byArray = this.getBytes();
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private float toPointMeter(float f, float f2) {
        if (0.0f == f2) {
            return this.toPointInch(f, this.printerDPI);
        }
        return f / f2 * 100.0f / 2.54f * 72.0f;
    }

    private float toPointInch(float f, float f2) {
        if (0.0f == f2) {
            f2 = this.printerDPI;
        }
        return f / f2 * 72.0f;
    }
}

