/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.impl.emulator.printer;

import com.sap.ip.me.api.pios.impl.emulator.printer.PrinterConnectionImpl;
import com.sap.ip.me.api.pios.printer.Accessor;
import com.sap.ip.me.api.pios.printer.Metrics;
import com.sap.ip.me.api.pios.printer.PrinterException;
import com.sap.ip.me.api.pios.printer.PrinterFont;
import pios.emulator.printer.rmi.DimensionRMI;

public class PrinterFontImpl
implements PrinterFont {
    private static final float SIZE_MIN = 1.0f;
    private static final float SIZE_MAX = 72.0f;
    private PrinterConnectionImpl printerConnection;
    private String alias;
    private String description;
    private int fontType;
    private long options;
    private float configSize;
    private String implementedFontName;
    private float implementedHeight;

    protected void resetImplementationHeight() {
        this.implementedHeight = 0.0f;
    }

    protected PrinterFontImpl(PrinterConnectionImpl printerConnectionImpl, String string, String string2, int n, long l, float f, String string3) {
        this.printerConnection = printerConnectionImpl;
        this.alias = string;
        this.description = string2;
        this.fontType = n;
        this.options = l;
        this.configSize = PrinterFontImpl.validateFontSize(f);
        this.implementedFontName = string3;
        this.resetImplementationHeight();
    }

    public static final boolean validateFontType(int n, boolean bl) {
        if (bl && 0 == n) {
            return true;
        }
        return n == 1 || n == 2;
    }

    public static final boolean validateFontSize(float f, boolean bl) {
        if (bl && 0.0f == f) {
            return true;
        }
        return !(f <= 0.0f);
    }

    public static final float validateFontSize(float f) {
        float f2 = Math.max(1.0f, f);
        f2 = Math.min(72.0f, f2);
        return f2;
    }

    public static final boolean validateFontOptions(long l) {
        return l >= 0L && l <= 15L;
    }

    public String getName() {
        return this.alias;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.fontType;
    }

    public long getOptions() {
        return this.options;
    }

    public float getConfiguredSize() {
        return this.configSize;
    }

    public float getHeight() throws PrinterException {
        if (0.0f == this.implementedHeight) {
            DimensionRMI dimensionRMI = this.printerConnection.getTextImplDimension(this, this.alias);
            this.implementedHeight = (float)dimensionRMI.getHeight();
        }
        return this.implementedHeight;
    }

    public Metrics getMetrics(String string) throws PrinterException {
        DimensionRMI dimensionRMI = this.printerConnection.getTextImplDimension(this, string);
        return Accessor.createMetrics((float)dimensionRMI.getWidth(), (float)dimensionRMI.getHeight());
    }

    public String getImplementedFontName() {
        return this.implementedFontName;
    }
}

