/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.impl.emulator.printer;

import com.sap.ip.me.api.pios.PIOSException;
import com.sap.ip.me.api.pios.UnsupportedException;
import com.sap.ip.me.api.pios.configuration.Configuration;
import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.connection.ConnectionParameters;
import com.sap.ip.me.api.pios.impl.emulator.printer.BarcodeConfigurationManager;
import com.sap.ip.me.api.pios.impl.emulator.printer.BitmappedFontImpl;
import com.sap.ip.me.api.pios.impl.emulator.printer.ConfigSetup;
import com.sap.ip.me.api.pios.impl.emulator.printer.PrinterBarcodeImpl;
import com.sap.ip.me.api.pios.impl.emulator.printer.PrinterFontImpl;
import com.sap.ip.me.api.pios.impl.emulator.printer.PrinterImageImpl;
import com.sap.ip.me.api.pios.impl.emulator.printer.ScalableFontImpl;
import com.sap.ip.me.api.pios.printer.Accessor;
import com.sap.ip.me.api.pios.printer.FontConfigurationManager;
import com.sap.ip.me.api.pios.printer.Metrics;
import com.sap.ip.me.api.pios.printer.PrinterBarcode;
import com.sap.ip.me.api.pios.printer.PrinterConnection;
import com.sap.ip.me.api.pios.printer.PrinterException;
import com.sap.ip.me.api.pios.printer.PrinterFont;
import com.sap.ip.me.api.pios.printer.PrinterImage;
import com.sap.ip.me.api.pios.printer.PrinterParameters;
import com.sap.ip.me.api.pios.symbology.InvalidSymbologyException;
import com.sap.ip.me.api.pios.symbology.PDF417;
import com.sap.ip.me.api.pios.symbology.Symbology;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import pios.emulator.printer.rmi.BarcodeParametersRMI;
import pios.emulator.printer.rmi.DimensionRMI;
import pios.emulator.printer.rmi.FontParameters;
import pios.emulator.printer.rmi.PrinterEm;
import pios.emulator.printer.rmi.PrinterRemoteException;
import pios.emulator.rmi.RMIException;
import pios.emulator.rmi.RemoteProxy;

public class PrinterConnectionImpl
extends PrinterConnection {
    private PrinterEm printerEmulator = null;
    private Hashtable logicFontCache = new Hashtable();
    private FontConfigurationManager fontManager = null;
    private BarcodeConfigurationManager barcodeManager = null;
    static /* synthetic */ Class class$pios$emulator$printer$rmi$PrinterRemoteException;
    static /* synthetic */ Class class$java$lang$NullPointerException;
    static /* synthetic */ Class class$com$sap$ip$me$api$pios$symbology$PDF417;
    static /* synthetic */ Class class$com$sap$ip$me$api$pios$symbology$SymbologyLinear;

    public PrinterConnectionImpl() throws PIOSException {
        try {
            this.printerEmulator = (PrinterEm)RemoteProxy.getProxy("RemoteEmPrinter");
        }
        catch (RMIException rMIException) {
            throw new PIOSException("Cannot get Remote Printer Proxy " + rMIException.getMessage());
        }
    }

    PrinterEm getPrinter() {
        return this.printerEmulator;
    }

    void mayNotSupport(RemoteException remoteException) throws UnsupportedException, PrinterException, RuntimeException {
        if ((class$pios$emulator$printer$rmi$PrinterRemoteException == null ? (class$pios$emulator$printer$rmi$PrinterRemoteException = PrinterConnectionImpl.class$("pios.emulator.printer.rmi.PrinterRemoteException")) : class$pios$emulator$printer$rmi$PrinterRemoteException).isInstance(remoteException.detail)) {
            PrinterRemoteException printerRemoteException = (PrinterRemoteException)remoteException.detail;
            if ((class$java$lang$NullPointerException == null ? (class$java$lang$NullPointerException = PrinterConnectionImpl.class$("java.lang.NullPointerException")) : class$java$lang$NullPointerException).isInstance(printerRemoteException.detail)) {
                throw (RuntimeException)printerRemoteException.detail;
            }
            switch (printerRemoteException.getType()) {
                case 1: {
                    printerRemoteException.printStackTrace();
                    throw new PrinterException((Throwable)printerRemoteException);
                }
                case 3: {
                    throw new PrinterException((Throwable)printerRemoteException);
                }
                case 2: {
                    throw new UnsupportedException(printerRemoteException.getMessage());
                }
            }
            printerRemoteException.printStackTrace();
            throw new PrinterException((Throwable)printerRemoteException);
        }
        remoteException.detail.printStackTrace();
        throw new PrinterException(remoteException.detail);
    }

    void mustSupport(RemoteException remoteException) throws PrinterException, RuntimeException {
        if ((class$pios$emulator$printer$rmi$PrinterRemoteException == null ? (class$pios$emulator$printer$rmi$PrinterRemoteException = PrinterConnectionImpl.class$("pios.emulator.printer.rmi.PrinterRemoteException")) : class$pios$emulator$printer$rmi$PrinterRemoteException).isInstance(remoteException.detail)) {
            PrinterRemoteException printerRemoteException = (PrinterRemoteException)remoteException.detail;
            if ((class$java$lang$NullPointerException == null ? (class$java$lang$NullPointerException = PrinterConnectionImpl.class$("java.lang.NullPointerException")) : class$java$lang$NullPointerException).isInstance(printerRemoteException.detail)) {
                throw (RuntimeException)printerRemoteException.detail;
            }
            switch (printerRemoteException.getType()) {
                case 1: {
                    printerRemoteException.printStackTrace();
                    throw new PrinterException((Throwable)printerRemoteException);
                }
                case 3: {
                    throw new PrinterException((Throwable)printerRemoteException);
                }
                case 2: {
                    printerRemoteException.printStackTrace();
                    throw new PrinterException(printerRemoteException.getMessage());
                }
            }
            printerRemoteException.printStackTrace();
            throw new PrinterException((Throwable)printerRemoteException);
        }
        remoteException.detail.printStackTrace();
        throw new PrinterException(remoteException.detail);
    }

    static void validateName(String string) throws PrinterException {
        if (string.length() == 0) {
            throw new PrinterException("Invalid Name:(Empty)");
        }
    }

    static void validateImageName(String string) throws PrinterException {
        PrinterConnectionImpl.validateName(string);
        if (string.length() > 16) {
            throw new PrinterException("Invalid Image Name(too long):" + string);
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isLetterOrDigit(string.charAt(n))) {
                throw new PrinterException("Invalid Image Name(not alphanumeric):" + string);
            }
            ++n;
        }
    }

    static void validateDimension(float f, float f2) throws PrinterException {
        if (f <= 0.0f || f2 <= 0.0f) {
            throw new PrinterException("Invalid Dimesion:(" + f + "," + f2 + ")");
        }
    }

    private static void validateBytes(byte[] byArray) throws PrinterException {
        if (byArray.length <= 0) {
            throw new PrinterException(65538, "No data");
        }
    }

    private boolean isSupported(String string) throws PrinterException {
        if (!this.isOpen()) {
            throw new PrinterException(7, "Printer connection is closed");
        }
        PrinterConnectionImpl.validateName(string);
        boolean bl = false;
        try {
            bl = this.getParameters().getDriver().isAttributeSupported(string);
        }
        catch (PIOSException pIOSException) {
            throw new PrinterException(65536, (Throwable)pIOSException);
        }
        return bl;
    }

    public void open(ConnectionParameters connectionParameters, String string) throws PIOSException {
        super.open(connectionParameters, string);
        ConfigSetup.installDefault(string);
        try {
            PrinterParameters printerParameters = (PrinterParameters)connectionParameters;
            if (printerParameters.getPrinterMode() == 1) {
                this.printerEmulator.openLinePrinter();
            } else if (printerParameters.getPrinterMode() == 2) {
                this.printerEmulator.openGraphicPrinter();
            } else {
                throw new UnsupportedException("unknown mode");
            }
            this.reloadFonts();
            this.opened = true;
        }
        catch (RemoteException remoteException) {
            this.mayNotSupport(remoteException);
        }
    }

    public void close() throws PIOSException {
        try {
            if (null != this.printerEmulator && this.isOpen()) {
                this.printerEmulator.close();
                super.close();
                this.opened = false;
            }
        }
        catch (RemoteException remoteException) {
            this.mayNotSupport(remoteException);
        }
    }

    public void advance(float f) throws PrinterException, UnsupportedException {
        try {
            this.printerEmulator.advance(f);
        }
        catch (RemoteException remoteException) {
            this.mayNotSupport(remoteException);
        }
    }

    public int getStatus() throws PrinterException {
        int n = 0;
        try {
            n = this.printerEmulator.getStatus();
            switch (n) {
                case 0: 
                case 4: {
                    n = 0;
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    n = 6;
                    break;
                }
            }
        }
        catch (RemoteException remoteException) {
            this.mustSupport(remoteException);
        }
        return n;
    }

    public void clearError() throws PrinterException, UnsupportedException {
        try {
            this.printerEmulator.clearError();
        }
        catch (RemoteException remoteException) {
            this.mayNotSupport(remoteException);
        }
    }

    private void reloadFonts() throws ConfigurationException, PrinterException {
        String[] stringArray = this.getFontConfigurationManager().listFontNames();
        this.logicFontCache.clear();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.logicFontCache.put(string, this.createFont(string));
            ++n;
        }
    }

    public PrinterFont[] listFonts(float f, int n, long l) throws PrinterException {
        PrinterFont printerFont;
        if (!(PrinterFontImpl.validateFontSize(f, true) && PrinterFontImpl.validateFontOptions(l) && PrinterFontImpl.validateFontType(n, true))) {
            throw new PrinterException("Invalid Font Query Parameters:" + f + "," + n + "," + l);
        }
        Object[] objectArray = this.logicFontCache.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        Vector<PrinterFont> vector = new Vector<PrinterFont>();
        int n2 = 0;
        while (n2 < objectArray.length) {
            printerFont = this.getFont((String)objectArray[n2]);
            if (!(0.0f != f && f != printerFont.getConfiguredSize() || 0 != n && n != printerFont.getType() || (1L & l) <= 0L && l != printerFont.getOptions())) {
                vector.add(printerFont);
            }
            ++n2;
        }
        printerFont = new PrinterFont[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            printerFont[n3] = (PrinterFont)vector.get(n3);
            ++n3;
        }
        return printerFont;
    }

    public PrinterFont getFont(String string) throws PrinterException {
        PrinterConnectionImpl.validateName(string);
        try {
            return this.createFont(string);
        }
        catch (Exception exception) {
            throw new PrinterException(65537, "Not found:" + string);
        }
    }

    private void getBarcodeConfigurationManager() throws ConfigurationException {
        String string = this.cfgFile + ".barcfg";
        String string2 = this.cfgFile + ".prmd";
        this.barcodeManager = new BarcodeConfigurationManager(string2, string);
    }

    void setLinearBarcodeParameters(BarcodeParametersRMI barcodeParametersRMI, PrinterBarcode printerBarcode) throws ConfigurationException {
        if (null == this.barcodeManager) {
            this.getBarcodeConfigurationManager();
        }
        Configuration configuration = this.barcodeManager.getLinearConfig(printerBarcode);
        double d = Double.parseDouble(configuration.getParameterValue("NarrowElementWidth"));
        double d2 = Double.parseDouble(configuration.getParameterValue("WideToNarrowRatio"));
        double d3 = Double.parseDouble(configuration.getParameterValue("InterCharGap"));
        double d4 = Double.parseDouble(configuration.getParameterValue("InterBarGap"));
        barcodeParametersRMI.setLinearParameters(printerBarcode.getHeight(), d, d2, d3, d4);
    }

    void set2DBarcodeParameters(BarcodeParametersRMI barcodeParametersRMI, PrinterBarcode printerBarcode) throws ConfigurationException {
        if (null == this.barcodeManager) {
            this.getBarcodeConfigurationManager();
        }
        if ((class$com$sap$ip$me$api$pios$symbology$PDF417 == null ? (class$com$sap$ip$me$api$pios$symbology$PDF417 = PrinterConnectionImpl.class$("com.sap.ip.me.api.pios.symbology.PDF417")) : class$com$sap$ip$me$api$pios$symbology$PDF417).isInstance(printerBarcode.getSymbology())) {
            Configuration configuration = this.barcodeManager.getModuleConfig(printerBarcode);
            double d = Double.parseDouble(configuration.getParameterValue("X"));
            double d2 = Double.parseDouble(configuration.getParameterValue("RowHeight"));
            barcodeParametersRMI.setModuleSize(d, d2);
            PDF417 pDF417 = (PDF417)printerBarcode.getSymbology();
            barcodeParametersRMI.setModuleArray(pDF417.getColums(), pDF417.getRows());
        }
    }

    BarcodeParametersRMI setBarcodeParameters(PrinterBarcode printerBarcode, byte[] byArray) throws ConfigurationException, PrinterException {
        PrinterConnectionImpl.validateBytes(byArray);
        BarcodeParametersRMI barcodeParametersRMI = new BarcodeParametersRMI(printerBarcode.getSymbology().getName(), printerBarcode.getSymbology().getOptions(), byArray, printerBarcode.getOptions());
        barcodeParametersRMI.setSymbologyTypeId(printerBarcode.getSymbology().getType());
        barcodeParametersRMI.setScale(((PrinterBarcodeImpl)printerBarcode).getScale());
        if ((class$com$sap$ip$me$api$pios$symbology$SymbologyLinear == null ? (class$com$sap$ip$me$api$pios$symbology$SymbologyLinear = PrinterConnectionImpl.class$("com.sap.ip.me.api.pios.symbology.SymbologyLinear")) : class$com$sap$ip$me$api$pios$symbology$SymbologyLinear).isInstance(printerBarcode.getSymbology())) {
            this.setLinearBarcodeParameters(barcodeParametersRMI, printerBarcode);
        } else {
            this.set2DBarcodeParameters(barcodeParametersRMI, printerBarcode);
        }
        return barcodeParametersRMI;
    }

    FontParameters setFontParameters(PrinterFont printerFont) {
        FontParameters fontParameters = null;
        if (printerFont.getType() == 2) {
            ScalableFontImpl scalableFontImpl = (ScalableFontImpl)printerFont;
            fontParameters = new FontParameters(scalableFontImpl.getImplementedFontName(), scalableFontImpl.getOptions(), scalableFontImpl.getFontSize());
        } else {
            BitmappedFontImpl bitmappedFontImpl = (BitmappedFontImpl)printerFont;
            fontParameters = new FontParameters(bitmappedFontImpl.getImplementedFontName(), bitmappedFontImpl.getOptions(), bitmappedFontImpl.getConfiguredSize(), bitmappedFontImpl.getWidthFactor(), bitmappedFontImpl.getHeightFactor());
        }
        return fontParameters;
    }

    private PrinterFont createFont(String string) throws ConfigurationException {
        PrinterFontImpl printerFontImpl;
        Configuration configuration = this.getFontConfigurationManager().getFontConfiguration(string);
        String string2 = configuration.getParameterValue("Name");
        String string3 = configuration.getParameterValue("Description");
        String string4 = configuration.getParameterValue("FontType");
        String string5 = configuration.getParameterValue("Options");
        String string6 = configuration.getParameterValue("Size");
        if (null == string3) {
            string3 = "";
        }
        if (null == string2 || null == string4 || null == string5 || null == string6) {
            throw new ConfigurationException("invalid font config:" + string);
        }
        int n = Integer.parseInt(string4);
        long l = Long.parseLong(string5);
        float f = Float.parseFloat(string6);
        if (!(PrinterFontImpl.validateFontType(n, false) && PrinterFontImpl.validateFontOptions(l) && PrinterFontImpl.validateFontSize(f, false))) {
            throw new ConfigurationException("Invalid font config:" + string);
        }
        if (1 == n) {
            printerFontImpl = new BitmappedFontImpl(this, string, string3, l, f, string2);
        } else if (2 == n) {
            printerFontImpl = new ScalableFontImpl(this, string, string3, l, f, string2);
        } else {
            throw new ConfigurationException("invalid font type:" + string4);
        }
        return printerFontImpl;
    }

    public DimensionRMI getTextImplDimension(PrinterFont printerFont, String string) throws PrinterException {
        FontParameters fontParameters = this.setFontParameters(printerFont);
        try {
            return this.printerEmulator.getTextImplDimension(fontParameters, string);
        }
        catch (RemoteException remoteException) {
            this.mustSupport(remoteException);
            throw new PrinterException((Throwable)remoteException);
        }
    }

    DimensionRMI getBarcodeImplDimension(PrinterBarcode printerBarcode, byte[] byArray) throws PrinterException, ConfigurationException {
        try {
            BarcodeParametersRMI barcodeParametersRMI = this.setBarcodeParameters(printerBarcode, byArray);
            return this.printerEmulator.getBarcodeImplDimension(barcodeParametersRMI);
        }
        catch (RemoteException remoteException) {
            this.mustSupport(remoteException);
            throw new PrinterException((Throwable)remoteException);
        }
    }

    public void dispose() throws PrinterException {
        try {
            this.printerEmulator.dispose();
        }
        catch (RemoteException remoteException) {
            this.mustSupport(remoteException);
        }
    }

    public void doPrint(int n) throws PrinterException {
        if (n <= 0) {
            throw new PrinterException("Invalid Copy Number:" + n);
        }
        try {
            this.printerEmulator.doPrint(n);
        }
        catch (RemoteException remoteException) {
            this.mustSupport(remoteException);
        }
    }

    public void sendRawBytes(byte[] byArray) throws PrinterException, UnsupportedException {
        PrinterConnectionImpl.validateBytes(byArray);
        try {
            this.printerEmulator.sendRawBytes(byArray);
        }
        catch (RemoteException remoteException) {
            this.mayNotSupport(remoteException);
        }
    }

    public PrinterImage createImage(String string, int n, byte[] byArray) throws PrinterException, UnsupportedException {
        String string2;
        PrinterConnectionImpl.validateImageName(string);
        PrinterConnectionImpl.validateBytes(byArray);
        switch (n) {
            case 1: {
                string2 = "IMAGE_BMP";
                break;
            }
            case 2: {
                string2 = "IMAGE_PCX";
                break;
            }
            default: {
                throw new PrinterException("Invalid image type:" + n);
            }
        }
        if (!this.isSupported(string2)) {
            throw new UnsupportedException(string + ":" + string2);
        }
        int n2 = this.getPrinterDPI();
        return new PrinterImageImpl(string, n, byArray, n2);
    }

    public void loadImage(PrinterImage printerImage) throws UnsupportedException, PrinterException {
        double d = printerImage.getMetrics().getWidth();
        double d2 = printerImage.getMetrics().getHeight();
        try {
            this.printerEmulator.uploadImage(printerImage.getName(), d, d2);
        }
        catch (RemoteException remoteException) {
            this.mayNotSupport(remoteException);
        }
    }

    public void deleteImage(String string) throws PrinterException, UnsupportedException {
        PrinterConnectionImpl.validateImageName(string);
        try {
            this.printerEmulator.deleteImage(string);
        }
        catch (RemoteException remoteException) {
            this.mayNotSupport(remoteException);
        }
    }

    public FontConfigurationManager getFontConfigurationManager() throws ConfigurationException {
        if (null == this.fontManager) {
            String string = this.cfgFile + ".fntcfg";
            String string2 = this.cfgFile + ".prmd";
            this.fontManager = Accessor.createFontConfigurationManager(string2, string);
        }
        return this.fontManager;
    }

    public PrinterBarcode createBarcode(Symbology symbology, long l) throws UnsupportedException, InvalidSymbologyException, PrinterException {
        if (!this.isSupported(symbology.getName())) {
            throw new UnsupportedException("Unsupported Symbology:" + symbology.getName());
        }
        PrinterBarcodeImpl printerBarcodeImpl = new PrinterBarcodeImpl(this, symbology, l);
        return printerBarcodeImpl;
    }

    public int getPrinterDPI() throws PrinterException {
        try {
            return this.printerEmulator.getCurrentResolution();
        }
        catch (RemoteException remoteException) {
            this.mustSupport(remoteException);
            return 0;
        }
    }

    public Metrics getPageMetrics() throws PrinterException, UnsupportedException {
        try {
            DimensionRMI dimensionRMI = this.printerEmulator.getCurrentMediaDimension();
            return Accessor.createMetrics((float)dimensionRMI.getWidth(), (float)dimensionRMI.getHeight());
        }
        catch (RemoteException remoteException) {
            this.mayNotSupport(remoteException);
            return null;
        }
    }

    public float getPrintHeadWidth() throws PrinterException {
        try {
            return this.printerEmulator.getMaxPrintWidth();
        }
        catch (RemoteException remoteException) {
            this.mustSupport(remoteException);
            return 0.0f;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

