/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.impl.emulator.printer;

import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.impl.emulator.printer.PrinterConnectionImpl;
import com.sap.ip.me.api.pios.printer.Accessor;
import com.sap.ip.me.api.pios.printer.Metrics;
import com.sap.ip.me.api.pios.printer.PrinterBarcode;
import com.sap.ip.me.api.pios.printer.PrinterException;
import com.sap.ip.me.api.pios.symbology.Symbology;
import pios.emulator.printer.rmi.DimensionRMI;

public final class PrinterBarcodeImpl
implements PrinterBarcode {
    private PrinterConnectionImpl printerConnection;
    private Symbology symbology;
    private long options;
    private final long validOptions = 3L;
    private int scaleFactor = 1;
    private int density = 0;
    private float height;
    private static final float DEFAULT_HEIGHT = 5.0f;
    private static final float MAX_HEIGHT = 360.0f;
    private static final float MIN_HEIGHT = 1.0f;

    protected PrinterBarcodeImpl(PrinterConnectionImpl printerConnectionImpl, Symbology symbology, long l) throws PrinterException {
        this.printerConnection = printerConnectionImpl;
        this.symbology = symbology;
        this.setOptions(l);
        this.height = 5.0f;
    }

    public Symbology getSymbology() {
        return this.symbology;
    }

    public Metrics getMetrics(byte[] byArray) throws PrinterException {
        try {
            DimensionRMI dimensionRMI = this.printerConnection.getBarcodeImplDimension(this, byArray);
            return Accessor.createMetrics((float)dimensionRMI.getWidth(), (float)dimensionRMI.getHeight());
        }
        catch (ConfigurationException configurationException) {
            throw new PrinterException((Throwable)configurationException);
        }
    }

    public void setHeight(float f) {
        if (f > 360.0f || f < 1.0f) {
            this.height = 5.0f;
            return;
        }
        this.height = f;
    }

    public float getHeight() {
        return this.height;
    }

    public void setOptions(long l) throws PrinterException {
        if ((l & 3L) != l) {
            throw new PrinterException(65538, "Invalid options value:" + l);
        }
        if ((2L & l) == 2L && (1L & l) == 1L) {
            throw new PrinterException(65538, "Invalid options value:" + l);
        }
        this.options = l;
    }

    public long getOptions() {
        return this.options;
    }

    public void setDensity(int n) throws PrinterException {
        if (0 != n && 1 != n && 2 != n) {
            throw new PrinterException(65538, "Invalid density:" + n);
        }
        this.density = n;
    }

    public int getDensity() {
        return this.density;
    }

    public void setScaleFactor(int n) throws PrinterException {
        if (3 != n && 2 != n && 0 != n && 1 != n) {
            throw new PrinterException(65538, "Invalid scale factor:" + n);
        }
        this.scaleFactor = n;
    }

    public double getScale() {
        switch (this.scaleFactor) {
            case 1: {
                return 1.0;
            }
            case 0: {
                return 0.5;
            }
            case 2: {
                return 2.0;
            }
            case 3: {
                return 3.0;
            }
        }
        return 1.0;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }
}

