/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.impl.emulator.printer;

import com.sap.ip.me.api.pios.PIOSException;
import com.sap.ip.me.api.pios.UnsupportedException;
import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.connection.ConnectionParameters;
import com.sap.ip.me.api.pios.impl.emulator.printer.PrinterConnectionImpl;
import com.sap.ip.me.api.pios.printer.FontConfigurationManager;
import com.sap.ip.me.api.pios.printer.LinePrinter;
import com.sap.ip.me.api.pios.printer.Metrics;
import com.sap.ip.me.api.pios.printer.PrinterBarcode;
import com.sap.ip.me.api.pios.printer.PrinterException;
import com.sap.ip.me.api.pios.printer.PrinterFont;
import com.sap.ip.me.api.pios.printer.PrinterImage;
import com.sap.ip.me.api.pios.symbology.InvalidSymbologyException;
import com.sap.ip.me.api.pios.symbology.Symbology;
import java.rmi.RemoteException;
import pios.emulator.printer.rmi.BarcodeParametersRMI;
import pios.emulator.printer.rmi.FontParameters;
import pios.emulator.printer.rmi.PrinterEm;

public final class LinePrinterImpl
extends LinePrinter {
    private PrinterConnectionImpl generalPrinterConnection = new PrinterConnectionImpl();
    private PrinterEm printerEmulator = null;

    public void setLineSpacing(float f) throws UnsupportedException, PrinterException {
        try {
            this.printerEmulator.setLineSpacing(f);
        }
        catch (RemoteException remoteException) {
            this.generalPrinterConnection.mayNotSupport(remoteException);
        }
    }

    public void printText(PrinterFont printerFont, String string, int n) throws UnsupportedException, PrinterException {
        this.validateAlignment(n);
        try {
            FontParameters fontParameters = this.generalPrinterConnection.setFontParameters(printerFont);
            this.printerEmulator.printText(n, fontParameters, string);
        }
        catch (RemoteException remoteException) {
            this.generalPrinterConnection.mayNotSupport(remoteException);
        }
    }

    public void printImage(String string, int n) throws UnsupportedException, PrinterException {
        PrinterConnectionImpl.validateImageName(string);
        this.validateAlignment(n);
        try {
            this.printerEmulator.printImage(n, string);
        }
        catch (RemoteException remoteException) {
            this.generalPrinterConnection.mayNotSupport(remoteException);
        }
    }

    public void printBarcode(PrinterBarcode printerBarcode, byte[] byArray, int n) throws PrinterException, UnsupportedException {
        this.validateAlignment(n);
        try {
            BarcodeParametersRMI barcodeParametersRMI = this.generalPrinterConnection.setBarcodeParameters(printerBarcode, byArray);
            this.printerEmulator.printBarcode(n, barcodeParametersRMI);
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
            throw new PrinterException((Throwable)configurationException);
        }
        catch (RemoteException remoteException) {
            this.generalPrinterConnection.mayNotSupport(remoteException);
        }
    }

    public void open(ConnectionParameters connectionParameters, String string) throws PIOSException {
        super.open(connectionParameters, string);
        this.generalPrinterConnection.open(connectionParameters, string);
        this.printerEmulator = this.generalPrinterConnection.getPrinter();
    }

    public void close() throws PIOSException {
        super.close();
        this.generalPrinterConnection.close();
        this.opened = this.generalPrinterConnection.isOpen();
        this.printerEmulator = this.generalPrinterConnection.getPrinter();
    }

    public int getStatus() throws PrinterException {
        return this.generalPrinterConnection.getStatus();
    }

    public void clearError() throws PrinterException, UnsupportedException {
        this.generalPrinterConnection.clearError();
    }

    public void sendRawBytes(byte[] byArray) throws PrinterException, UnsupportedException {
        this.generalPrinterConnection.sendRawBytes(byArray);
    }

    public PrinterFont[] listFonts(float f, int n, long l) throws PrinterException {
        return this.generalPrinterConnection.listFonts(f, n, l);
    }

    public PrinterFont getFont(String string) throws PrinterException {
        return this.generalPrinterConnection.getFont(string);
    }

    public FontConfigurationManager getFontConfigurationManager() throws ConfigurationException {
        return this.generalPrinterConnection.getFontConfigurationManager();
    }

    public PrinterBarcode createBarcode(Symbology symbology, long l) throws UnsupportedException, InvalidSymbologyException, PrinterException {
        return this.generalPrinterConnection.createBarcode(symbology, l);
    }

    public PrinterImage createImage(String string, int n, byte[] byArray) throws PrinterException, UnsupportedException {
        return this.generalPrinterConnection.createImage(string, n, byArray);
    }

    public void doPrint(int n) throws PrinterException {
        this.generalPrinterConnection.doPrint(n);
    }

    public void advance(float f) throws PrinterException, UnsupportedException {
        this.generalPrinterConnection.advance(f);
    }

    public void dispose() throws PrinterException {
        this.generalPrinterConnection.dispose();
    }

    public void loadImage(PrinterImage printerImage) throws UnsupportedException, PrinterException {
        this.generalPrinterConnection.loadImage(printerImage);
    }

    public void deleteImage(String string) throws UnsupportedException, PrinterException {
        this.generalPrinterConnection.deleteImage(string);
    }

    public int getPrinterDPI() throws PrinterException {
        return this.generalPrinterConnection.getPrinterDPI();
    }

    public Metrics getPageMetrics() throws PrinterException, UnsupportedException {
        return this.generalPrinterConnection.getPageMetrics();
    }

    public float getPrintHeadWidth() throws PrinterException {
        return this.generalPrinterConnection.getPrintHeadWidth();
    }

    private void validateAlignment(int n) throws PrinterException {
        if (n == 2 || n == 1 || n == 3 || n == 0) {
            return;
        }
        throw new PrinterException(65541, "alignment:" + n);
    }
}

