/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.impl.emulator.printer;

import com.sap.ip.me.api.pios.PIOSException;
import com.sap.ip.me.api.pios.UnsupportedException;
import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.connection.ConnectionParameters;
import com.sap.ip.me.api.pios.impl.emulator.printer.PrinterConnectionImpl;
import com.sap.ip.me.api.pios.printer.FontConfigurationManager;
import com.sap.ip.me.api.pios.printer.GraphicPrinter;
import com.sap.ip.me.api.pios.printer.Metrics;
import com.sap.ip.me.api.pios.printer.PrinterBarcode;
import com.sap.ip.me.api.pios.printer.PrinterException;
import com.sap.ip.me.api.pios.printer.PrinterFont;
import com.sap.ip.me.api.pios.printer.PrinterImage;
import com.sap.ip.me.api.pios.symbology.InvalidSymbologyException;
import com.sap.ip.me.api.pios.symbology.Symbology;
import java.rmi.RemoteException;
import pios.emulator.printer.rmi.BarcodeParametersRMI;
import pios.emulator.printer.rmi.FontParameters;
import pios.emulator.printer.rmi.PrinterEm;

public final class GraphicPrinterImpl
extends GraphicPrinter {
    private PrinterConnectionImpl generalPrinterConnection = new PrinterConnectionImpl();
    private PrinterEm printerEmulator = null;
    private static final float MIN_LINETHICKNESS = 0.0f;
    private static final float MAX_LINETHICKNESS = 100.0f;

    private static int getRotationDegree(int n) throws PrinterException {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        throw new PrinterException("Invalid Rotate:" + n);
    }

    private static void validateCoordinate(float f, float f2) throws PrinterException {
        if (f < 0.0f || f2 < 0.0f) {
            throw new PrinterException("Invalid Coordinate:(" + f + "," + f2 + ")");
        }
    }

    private static void validateLineThickness(float f) throws PrinterException {
        if (f < 0.0f || f > 100.0f) {
            throw new PrinterException("Invalid Line Thickness:" + f);
        }
    }

    public void drawText(PrinterFont printerFont, float f, float f2, String string, int n) throws UnsupportedException, PrinterException {
        GraphicPrinterImpl.validateCoordinate(f, f2);
        try {
            FontParameters fontParameters = this.generalPrinterConnection.setFontParameters(printerFont);
            this.printerEmulator.drawText(f, f2, GraphicPrinterImpl.getRotationDegree(n), fontParameters, string);
        }
        catch (RemoteException remoteException) {
            this.generalPrinterConnection.mayNotSupport(remoteException);
        }
    }

    public void drawImage(String string, float f, float f2, int n) throws UnsupportedException, PrinterException {
        PrinterConnectionImpl.validateImageName(string);
        GraphicPrinterImpl.validateCoordinate(f, f2);
        try {
            this.printerEmulator.drawImage(f, f2, GraphicPrinterImpl.getRotationDegree(n), string);
        }
        catch (RemoteException remoteException) {
            this.generalPrinterConnection.mayNotSupport(remoteException);
        }
    }

    public void drawBarcode(PrinterBarcode printerBarcode, float f, float f2, byte[] byArray, int n) throws PrinterException, UnsupportedException {
        GraphicPrinterImpl.validateCoordinate(f, f2);
        try {
            BarcodeParametersRMI barcodeParametersRMI = this.generalPrinterConnection.setBarcodeParameters(printerBarcode, byArray);
            this.printerEmulator.drawBarcode(f, f2, GraphicPrinterImpl.getRotationDegree(n), barcodeParametersRMI);
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
            throw new PrinterException((Throwable)configurationException);
        }
        catch (RemoteException remoteException) {
            this.generalPrinterConnection.mayNotSupport(remoteException);
        }
    }

    public void drawLine(float f, float f2, float f3, float f4, float f5) throws UnsupportedException, PrinterException {
        GraphicPrinterImpl.validateCoordinate(f, f2);
        GraphicPrinterImpl.validateCoordinate(f3, f4);
        GraphicPrinterImpl.validateLineThickness(f5);
        try {
            this.printerEmulator.drawLine(f, f2, f3, f4, f5);
        }
        catch (RemoteException remoteException) {
            this.generalPrinterConnection.mayNotSupport(remoteException);
        }
    }

    public void drawRectangle(float f, float f2, float f3, float f4, float f5) throws UnsupportedException, PrinterException {
        GraphicPrinterImpl.validateCoordinate(f, f2);
        PrinterConnectionImpl.validateDimension(f3, f4);
        GraphicPrinterImpl.validateLineThickness(f5);
        try {
            this.printerEmulator.drawRectangle(f, f2, f3, f4, f5);
        }
        catch (RemoteException remoteException) {
            this.generalPrinterConnection.mayNotSupport(remoteException);
        }
    }

    public void open(ConnectionParameters connectionParameters, String string) throws PIOSException {
        super.open(connectionParameters, string);
        this.generalPrinterConnection.open(connectionParameters, string);
        this.printerEmulator = this.generalPrinterConnection.getPrinter();
    }

    public void close() throws PIOSException {
        super.close();
        this.generalPrinterConnection.close();
        this.opened = this.generalPrinterConnection.isOpen();
        this.printerEmulator = this.generalPrinterConnection.getPrinter();
    }

    public int getStatus() throws PrinterException {
        return this.generalPrinterConnection.getStatus();
    }

    public void clearError() throws PrinterException, UnsupportedException {
        this.generalPrinterConnection.clearError();
    }

    public void sendRawBytes(byte[] byArray) throws PrinterException, UnsupportedException {
        this.generalPrinterConnection.sendRawBytes(byArray);
    }

    public PrinterFont[] listFonts(float f, int n, long l) throws PrinterException {
        return this.generalPrinterConnection.listFonts(f, n, l);
    }

    public PrinterFont getFont(String string) throws PrinterException {
        return this.generalPrinterConnection.getFont(string);
    }

    public FontConfigurationManager getFontConfigurationManager() throws ConfigurationException {
        return this.generalPrinterConnection.getFontConfigurationManager();
    }

    public PrinterBarcode createBarcode(Symbology symbology, long l) throws UnsupportedException, InvalidSymbologyException, PrinterException {
        return this.generalPrinterConnection.createBarcode(symbology, l);
    }

    public PrinterImage createImage(String string, int n, byte[] byArray) throws PrinterException, UnsupportedException {
        return this.generalPrinterConnection.createImage(string, n, byArray);
    }

    public void doPrint(int n) throws PrinterException {
        this.generalPrinterConnection.doPrint(n);
    }

    public void advance(float f) throws PrinterException, UnsupportedException {
        this.generalPrinterConnection.advance(f);
    }

    public void dispose() throws PrinterException {
        this.generalPrinterConnection.dispose();
    }

    public void loadImage(PrinterImage printerImage) throws UnsupportedException, PrinterException {
        this.generalPrinterConnection.loadImage(printerImage);
    }

    public void deleteImage(String string) throws UnsupportedException, PrinterException {
        this.generalPrinterConnection.deleteImage(string);
    }

    public int getPrinterDPI() throws PrinterException {
        return this.generalPrinterConnection.getPrinterDPI();
    }

    public Metrics getPageMetrics() throws PrinterException, UnsupportedException {
        return this.generalPrinterConnection.getPageMetrics();
    }

    public float getPrintHeadWidth() throws PrinterException {
        return this.generalPrinterConnection.getPrintHeadWidth();
    }
}

