/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.impl.emulator.printer;

import com.sap.ip.me.api.pios.impl.emulator.printer.PrinterConnectionImpl;
import com.sap.ip.me.api.pios.impl.emulator.printer.PrinterFontImpl;
import com.sap.ip.me.api.pios.printer.Accessor;
import com.sap.ip.me.api.pios.printer.BitmappedFont;
import com.sap.ip.me.api.pios.printer.Metrics;
import com.sap.ip.me.api.pios.printer.PrinterException;

public final class BitmappedFontImpl
extends PrinterFontImpl
implements BitmappedFont {
    private static final int FACTOR_MIN = 1;
    private static final int FACTOR_MAX = 10;
    private int widthFactor = 1;
    private int heightFactor = 1;

    protected BitmappedFontImpl(PrinterConnectionImpl printerConnectionImpl, String string, String string2, long l, float f, String string3) {
        super(printerConnectionImpl, string, string2, 1, l, f, string3);
    }

    public void setWidthFactor(int n) throws PrinterException {
        this.widthFactor = this.validateFactor(n);
    }

    public int getWidthFactor() {
        return this.widthFactor;
    }

    private int validateFactor(int n) {
        int n2 = Math.max(1, n);
        n2 = Math.min(10, n2);
        return n2;
    }

    public void setHeightFactor(int n) throws PrinterException {
        this.heightFactor = this.validateFactor(n);
        this.resetImplementationHeight();
    }

    public int getHeightFactor() {
        return this.heightFactor;
    }

    public Metrics getMetrics(String string) throws PrinterException {
        Metrics metrics = super.getMetrics(string);
        return Accessor.createMetrics(metrics.getWidth() * (float)this.widthFactor, metrics.getHeight() * (float)this.heightFactor);
    }
}

