/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.impl.emulator.printer;

import com.sap.ip.me.api.pios.configuration.Configuration;
import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.impl.configuration.ConfigurationManagerImpl;
import com.sap.ip.me.api.pios.printer.PrinterBarcode;

public class BarcodeConfigurationManager
extends ConfigurationManagerImpl {
    private static String getSurfix(int n) {
        switch (n) {
            case 0: {
                return "_DENSITY_DEFAULT";
            }
            case 1: {
                return "_DENSITY_LOW";
            }
            case 2: {
                return "_DENSITY_HIGH";
            }
        }
        return "_DENSITY_DEFAULT";
    }

    public BarcodeConfigurationManager(String string, String string2) throws ConfigurationException {
        super(string, string2);
    }

    public Configuration getLinearConfig(PrinterBarcode printerBarcode) throws ConfigurationException {
        try {
            return this.getConfig(printerBarcode.getSymbology().getName(), printerBarcode.getDensity(), "LinearBarcodeDensity");
        }
        catch (ConfigurationException configurationException) {
            return this.getConfig("SHARED", printerBarcode.getDensity(), "LinearBarcodeDensity");
        }
    }

    public Configuration getMaxiCodeConfig(PrinterBarcode printerBarcode) throws ConfigurationException {
        return this.getConfig(printerBarcode.getSymbology().getName(), 0, "MaxiCodeDensity");
    }

    public Configuration getModuleConfig(PrinterBarcode printerBarcode) throws ConfigurationException {
        return this.getConfig(printerBarcode.getSymbology().getName(), printerBarcode.getDensity(), "ModuleDensity");
    }

    private Configuration getConfig(String string, int n, String string2) throws ConfigurationException {
        if (n != 0) {
            try {
                return super.get(string + BarcodeConfigurationManager.getSurfix(n), string2);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return super.get(string + BarcodeConfigurationManager.getSurfix(0), string2);
    }
}

