/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.impl.emulator;

import com.sap.ip.me.api.pios.LibraryNotLoadedException;
import com.sap.ip.me.api.pios.PIOSException;
import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.configuration.ConfigurationManager;
import com.sap.ip.me.api.pios.connection.Connection;
import com.sap.ip.me.api.pios.connection.ConnectionHelper;
import com.sap.ip.me.api.pios.connection.ConnectionParameters;
import com.sap.ip.me.api.pios.connection.ConnectionType;
import com.sap.ip.me.api.pios.connection.Connector;
import com.sap.ip.me.api.pios.connection.DriverInfo;
import com.sap.ip.me.api.pios.impl.configuration.ConfigurationManagerImpl;
import com.sap.ip.me.api.pios.impl.emulator.printer.EmulatedPrinterDriverInfo;
import com.sap.ip.me.api.pios.printer.PrinterParameters;
import com.sap.ip.me.api.pios.util.PIOSPaths;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import pios.emulator.EmulatorAccessor;
import pios.emulator.rmi.EmulatorEm;
import pios.emulator.rmi.RMIException;
import pios.emulator.rmi.RemoteProxy;

public class ConnectorImpl
extends Connector {
    private static final String IMPL_PACKAGE_NAME = "com.sap.ip.me.api.pios.impl.emulator.";
    private static final String REMOTE_NAME = "RemoteEmulator";
    private static EmulatorEm remoteEmulator = null;
    private static final DriverInfo emulatedPrinterDriver = EmulatedPrinterDriverInfo.getInstance();
    private static final DriverInfo[] emulatorPrinters = new DriverInfo[]{emulatedPrinterDriver};
    private static final Hashtable defaultDrivers = new Hashtable();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Connection open(ConnectionParameters connectionParameters) throws PIOSException {
        String string = IMPL_PACKAGE_NAME;
        long l = connectionParameters.getConnection().getID();
        if (l != ConnectionType.PRINTER.getID()) throw new PIOSException(5, "Invalid Connection Type:" + l);
        PrinterParameters printerParameters = (PrinterParameters)connectionParameters;
        if (printerParameters.getPrinterMode() == 1) {
            string = string + "printer.LinePrinterImpl";
        } else {
            if (printerParameters.getPrinterMode() != 2) throw new PIOSException(5, "Invalid Printer Mode:" + printerParameters.getPrinterMode());
            string = string + "printer.GraphicPrinterImpl";
        }
        printerParameters = null;
        try {
            printerParameters = (Connection)Class.forName(string).newInstance();
            ConnectionHelper.open((Connection)printerParameters, connectionParameters, this.getConfigFile(connectionParameters.getDriver()));
            return printerParameters;
        }
        catch (PIOSException pIOSException) {
            throw pIOSException;
        }
        catch (Exception exception) {
            throw new PIOSException((Throwable)exception);
        }
    }

    private String getConfigFile(DriverInfo driverInfo) {
        String string = PIOSPaths.getMIDir();
        String string2 = PIOSPaths.getPIOSConfigDir().substring(string.length());
        String string3 = EmulatorAccessor.getEmulatorHomeDir() + string2 + driverInfo.getName();
        return string3;
    }

    public DriverInfo[] listDrivers(ConnectionType connectionType) throws PIOSException, LibraryNotLoadedException {
        long l = connectionType.getID();
        if (l == ConnectionType.PRINTER.getID()) {
            return emulatorPrinters;
        }
        throw new PIOSException(5, "Invalid connection type");
    }

    protected static Properties getAttributes(String string) throws PIOSException {
        try {
            return remoteEmulator.getAttributes(string);
        }
        catch (RemoteException remoteException) {
            throw new PIOSException(remoteException.detail.getMessage());
        }
    }

    public DriverInfo getDefaultDriver(ConnectionType connectionType) throws PIOSException, LibraryNotLoadedException {
        return (DriverInfo)defaultDrivers.get(connectionType.getType());
    }

    public ConfigurationManager getConfigurationManager(String string, String string2) throws ConfigurationException {
        return new ConfigurationManagerImpl(string, string2);
    }

    public void setDefaultDriver(DriverInfo driverInfo) throws PIOSException, LibraryNotLoadedException {
        if (driverInfo.getConnectionType().getID() == ConnectionType.PRINTER.getID() && emulatedPrinterDriver != driverInfo) {
            throw new PIOSException("Invalider Driver:" + driverInfo.getDescription());
        }
    }

    static {
        defaultDrivers.put(ConnectionType.PRINTER.getType(), emulatedPrinterDriver);
        try {
            remoteEmulator = (EmulatorEm)RemoteProxy.getProxy(REMOTE_NAME);
        }
        catch (RMIException rMIException) {
            rMIException.printStackTrace();
        }
    }
}

