/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.api.pios.impl.configuration;

import com.sap.ip.me.api.pios.configuration.Configuration;
import com.sap.ip.me.api.pios.configuration.ConfigurationException;
import com.sap.ip.me.api.pios.configuration.ConfigurationManager;
import com.sap.ip.me.api.pios.impl.util.Arrays;
import com.sap.ip.me.api.pios.impl.util.PropertyHelper;
import com.sap.ip.me.api.pios.impl.util.StringComparator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigurationManagerImpl
extends ConfigurationManager {
    private static final String PIOS_HEADER = "PIOS Configurations";
    protected static final String PARAM_DELIMITER = ",";
    protected static final String RESERVED_CHAR = "_";
    protected static final String KEY_SEPARATOR = ".";
    private static final String TYPES_KEY = "Types";
    private static final String PARAMS_KEY = "Parameters";
    private static final String CONFIGS_KEY = "Configs";
    private static final String TYPE_KEY = "_Type";
    private static final String ERR_CONF_NOT_EXIST = "Configuration does not exist.";
    private static final String ERR_CONF_ALREADY_EXIST = "Configuration already exist.";
    private static final String ERR_MD_CORRUPTED = "Corrupted meta data file.";
    private static final String ERR_RESERVED_NAME = "Configuration name cannot start with _";
    private static final String ERR_TYPE_DOES_NOT_EXIST = "The specified type does not exist.";
    private static final String ERR_PARAM_DOES_NOT_EXIST = "The specified parameter does not exist.";
    private Properties metaData;
    private Properties config;
    private String configFile;

    public ConfigurationManagerImpl(String string, String string2) throws ConfigurationException {
        this.configFile = string2;
        this.metaData = this.loadPropertyFile(string);
        this.config = this.loadPropertyFile(string2);
    }

    protected Properties getConfig() {
        return this.config;
    }

    private void savePropertyFile(Properties properties, String string) throws ConfigurationException {
        PropertyHelper.savePropertyFile(properties, string);
    }

    protected String getHeaderName() {
        return PIOS_HEADER;
    }

    private Properties loadPropertyFile(String string) throws ConfigurationException {
        return PropertyHelper.loadPropertyFile(string);
    }

    protected Configuration add(String string, String string2) throws ConfigurationException {
        if (string.startsWith(RESERVED_CHAR)) {
            throw new ConfigurationException(ERR_RESERVED_NAME);
        }
        if (this.config.containsKey(string)) {
            throw new ConfigurationException(ERR_CONF_ALREADY_EXIST);
        }
        String[] stringArray = this.getParameters(string2);
        int n = 0;
        while (n < stringArray.length) {
            this.config.put(string + KEY_SEPARATOR + stringArray[n], "");
            ++n;
        }
        this.config.put(string + KEY_SEPARATOR + TYPE_KEY, string2);
        this.config.put(string, "");
        String string3 = this.config.getProperty(CONFIGS_KEY);
        this.config.put(CONFIGS_KEY, string3 + (string3.length() == 0 ? "" : PARAM_DELIMITER) + string);
        return new Configuration(string, string2, (ConfigurationManager)this);
    }

    protected String[] getTypes() throws ConfigurationException {
        String string = (String)this.metaData.get(TYPES_KEY);
        if (string == null) {
            throw new ConfigurationException(ERR_MD_CORRUPTED);
        }
        return this.getTokens(string);
    }

    protected String[] list() throws ConfigurationException {
        String string = (String)this.config.get(CONFIGS_KEY);
        if (string == null) {
            throw new ConfigurationException(ERR_MD_CORRUPTED);
        }
        return this.getTokens(string);
    }

    protected String[] list(String string) throws ConfigurationException {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.list();
        int n = 0;
        while (n < stringArray.length) {
            if (this.getType(stringArray[n]).equals(string)) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Arrays.sort(objectArray, new StringComparator());
        return (String[])objectArray;
    }

    private String getType(String string) {
        return this.config.getProperty(string + KEY_SEPARATOR + TYPE_KEY);
    }

    private String[] getTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, PARAM_DELIMITER);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    protected void delete(String string) throws ConfigurationException {
        if (!this.config.containsKey(string)) {
            throw new ConfigurationException(ERR_CONF_NOT_EXIST);
        }
        this.config.put(CONFIGS_KEY, this.removeConfigFromKey(this.config.getProperty(CONFIGS_KEY), string));
        this.config.remove(string);
        String[] stringArray = this.getParameters(this.getType(string));
        int n = 0;
        while (n < stringArray.length) {
            this.config.remove(string + KEY_SEPARATOR + stringArray[n]);
            ++n;
        }
        this.config.remove(string + KEY_SEPARATOR + TYPE_KEY);
    }

    private String removeConfigFromKey(String string, String string2) throws ConfigurationException {
        if (string.equals(string2)) {
            return "";
        }
        int n = string.indexOf(string2);
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length() - 1);
        }
        if (string.startsWith(string2 + PARAM_DELIMITER)) {
            return string.substring(string2.length() + 1);
        }
        n = string.indexOf(PARAM_DELIMITER + string2 + PARAM_DELIMITER);
        return string.substring(0, n + 1) + string.substring(n + string2.length() + 2);
    }

    protected Configuration get(String string, String string2) throws ConfigurationException {
        if (this.config.getProperty(string) == null) {
            throw new ConfigurationException(ERR_CONF_NOT_EXIST);
        }
        return new Configuration(string, string2, (ConfigurationManager)this);
    }

    protected String[] getParameters(String string) throws ConfigurationException {
        String string2 = (String)this.metaData.get("Parameters." + string);
        if (string2 == null) {
            throw new ConfigurationException(ERR_TYPE_DOES_NOT_EXIST);
        }
        return this.getTokens(string2);
    }

    protected String[] getPossibleValues(String string, String string2) throws ConfigurationException {
        String string3 = (String)this.metaData.get(string + KEY_SEPARATOR + string2);
        String[] stringArray = this.getParameters(string);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string2)) {
                if (string3 == null) {
                    return new String[0];
                }
                return this.getTokens(string3);
            }
            ++n;
        }
        throw new ConfigurationException(ERR_PARAM_DOES_NOT_EXIST);
    }

    protected void setParameterValue(String string, String string2, String string3) throws ConfigurationException {
        String[] stringArray = this.getParameters(this.getType(string));
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string2)) {
                this.config.put(string + KEY_SEPARATOR + string2, string3);
                return;
            }
            ++n;
        }
        throw new ConfigurationException(ERR_PARAM_DOES_NOT_EXIST);
    }

    protected void save() throws ConfigurationException {
        this.savePropertyFile(this.config, this.configFile);
    }

    protected String getParamaterValue(String string, String string2) throws ConfigurationException {
        String[] stringArray = this.getParameters(this.getType(string));
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string2)) {
                return this.config.getProperty(string + KEY_SEPARATOR + string2);
            }
            ++n;
        }
        throw new ConfigurationException(ERR_PARAM_DOES_NOT_EXIST);
    }

    public static void main(String[] stringArray) {
        try {
            ConfigurationManagerImpl configurationManagerImpl = new ConfigurationManagerImpl("\\metadata.txt", "\\config.txt");
            String[] stringArray2 = configurationManagerImpl.getTypes();
            String[] stringArray3 = configurationManagerImpl.list();
            int n = 0;
            while (n < stringArray3.length) {
                configurationManagerImpl.delete(stringArray3[n]);
                ++n;
            }
            System.out.println(TYPES_KEY);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                Configuration configuration = configurationManagerImpl.add(stringArray2[n2], stringArray2[n2]);
                System.out.println("\t" + stringArray2[n2]);
                configuration = configurationManagerImpl.get(stringArray2[n2], stringArray2[n2]);
                System.out.println("\t\tParameters for " + configuration.getName());
                String[] stringArray4 = configuration.getParameters();
                if (stringArray4.length == 0) {
                    System.out.println("\t\t\tNo parameters");
                } else {
                    int n3 = 0;
                    while (n3 < stringArray4.length) {
                        System.out.println("\t\t\t" + stringArray4[n3]);
                        String[] stringArray5 = configuration.getPossibleValues(stringArray4[n3]);
                        if (stringArray5.length == 0) {
                            System.out.println("\t\t\t\tNo possible values");
                            configuration.setParameterValue(stringArray4[n3], "open");
                        } else {
                            System.out.print("\t\t\t\tPossible values:");
                            int n4 = 0;
                            while (n4 < stringArray5.length) {
                                System.out.print(" " + stringArray5[n4]);
                                ++n4;
                            }
                            System.out.println();
                            System.out.println("\t\t\tBefore Value: " + stringArray4[n3] + " " + configuration.getParameterValue(stringArray4[n3]));
                            configuration.setParameterValue(stringArray4[n3], stringArray5[0]);
                            System.out.println("\t\t\tAfter Value: " + stringArray4[n3] + " " + configuration.getParameterValue(stringArray4[n3]));
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            configurationManagerImpl.save();
            stringArray3 = configurationManagerImpl.list("Network");
            int n5 = 0;
            while (n5 < stringArray3.length) {
                System.out.println(stringArray3[n5]);
                ++n5;
            }
            stringArray3 = configurationManagerImpl.list();
            int n6 = 0;
            while (n6 < stringArray3.length) {
                System.out.println(stringArray3[n6]);
                ++n6;
            }
            configurationManagerImpl.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

