/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.supports;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Util {
    private static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"};

    public static boolean isPrimitiveType(String typeName) {
        return Util.isInStringArray(typeName, PRIMITIVE_TYPES);
    }

    public static boolean isInStringArray(String name, String[] allNames) {
        if (name == null || allNames == null) {
            return false;
        }
        int i = 0;
        while (i < allNames.length) {
            if (allNames[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean validateName(IJavaElement javaElement, String name) {
        int kind = -1;
        if (javaElement != null) {
            kind = javaElement.getElementType();
        }
        return Util.validateName(kind, name);
    }

    public static boolean validateName(int elementKind, String name) {
        IStatus status = null;
        if (elementKind == -1) {
            status = JavaConventions.validateIdentifier((String)name);
        } else {
            if (Util.isPrimitiveType(name)) {
                return true;
            }
            if (elementKind == 8) {
                status = JavaConventions.validateFieldName((String)name);
            } else if (elementKind == 7) {
                status = JavaConventions.validateJavaTypeName((String)name);
            } else if (elementKind == 9) {
                status = JavaConventions.validateMethodName((String)name);
            } else if (elementKind == 4) {
                status = JavaConventions.validatePackageName((String)name);
            }
        }
        if (status == null) {
            return false;
        }
        return status.isOK();
    }

    public static boolean validateName(IDOMNode domNode, String name) {
        IStatus status = null;
        if (domNode == null) {
            status = JavaConventions.validateIdentifier((String)name);
        } else {
            int kind = domNode.getNodeType();
            if (kind == 5) {
                status = JavaConventions.validateFieldName((String)name);
            } else if (kind == 4) {
                status = JavaConventions.validateIdentifier((String)name);
            } else if (kind == 6) {
                status = JavaConventions.validateMethodName((String)name);
            } else if (kind == 2) {
                status = JavaConventions.validatePackageName((String)name);
            }
        }
        if (status == null) {
            return false;
        }
        return status.isOK();
    }

    public static IProject[] getProjects() {
        IProject[] projects = null;
        ISelection selection = Util.getSelection();
        if (selection instanceof IStructuredSelection) {
            projects = Util.getProjects((IStructuredSelection)selection);
        }
        if (projects == null) {
            projects = Util.getProjects(Util.getWorkspaceRoot());
        }
        return projects;
    }

    private static IProject[] getProjects(IWorkspaceRoot root) {
        IProject[] projects;
        try {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)root);
            IJavaProject[] jprojects = model.getJavaProjects();
            projects = new IProject[jprojects.length];
            int i = 0;
            while (i < jprojects.length) {
                projects[i] = jprojects[i].getProject();
                ++i;
            }
        }
        catch (JavaModelException e) {
            projects = null;
        }
        return projects;
    }

    private static IProject[] getProjects(IStructuredSelection selection) {
        IProject[] projects = new IProject[1];
        Object el = selection.getFirstElement();
        if (el instanceof IResource) {
            projects[0] = ((IResource)el).getProject();
            return projects;
        }
        if (el instanceof IJavaElement) {
            projects[0] = ((IJavaElement)el).getJavaProject().getProject();
            return projects;
        }
        return null;
    }

    private static ISelection getSelection() {
        return Util.getWorkbenchWindow().getSelectionService().getSelection();
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        ResourcesPlugin.getPlugin();
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

