/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.supports;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TypeDialog {
    private static final Object[] INITIAL_SELECTIONS = new Object[0];
    private static final IType[] EMPTY_TYPES = new IType[0];

    private TypeDialog() {
    }

    public static IType chooseType(Shell shell, String title, String message) throws JavaModelException {
        IType[] types = TypeDialog.chooseTypes(shell, title, message, 6, false);
        return types == null ? null : types[0];
    }

    public static IType[] chooseTypes(Shell shell, String title, String message) throws JavaModelException {
        return TypeDialog.chooseTypes(shell, title, message, 6, true);
    }

    public static IType chooseClass(Shell shell, String title, String message) throws JavaModelException {
        IType[] types = TypeDialog.chooseTypes(shell, title, message, 2, false);
        return types == null ? null : types[0];
    }

    public static IType[] chooseClasses(Shell shell, String title, String message) throws JavaModelException {
        return TypeDialog.chooseTypes(shell, title, message, 2, true);
    }

    public static IType chooseInterface(Shell shell, String title, String message) throws JavaModelException {
        IType[] types = TypeDialog.chooseTypes(shell, title, message, 4, false);
        return types == null ? null : types[0];
    }

    public static IType[] chooseInterfaces(Shell shell, String title, String message) throws JavaModelException {
        return TypeDialog.chooseTypes(shell, title, message, 4, true);
    }

    private static IType[] chooseTypes(Shell shell, String title, String message, int style, boolean multi) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IResource[])TypeDialog.getProjects());
        scope.setIncludesBinaries(false);
        scope.setIncludesClasspaths(true);
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)TypeDialog.getWorkbenchWindow(), (IJavaSearchScope)scope, (int)style, (boolean)multi);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setInitialSelections(INITIAL_SELECTIONS);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            IType[] types = new IType[result.length];
            System.arraycopy(result, 0, types, 0, result.length);
            return types;
        }
        return null;
    }

    private static IProject[] getProjects() {
        IProject[] projects = null;
        ISelection selection = TypeDialog.getSelection();
        if (selection instanceof IStructuredSelection) {
            projects = TypeDialog.getProjects((IStructuredSelection)selection);
        }
        if (projects == null) {
            projects = TypeDialog.getProjects(TypeDialog.getWorkspaceRoot());
        }
        return projects;
    }

    private static IProject[] getProjects(IWorkspaceRoot root) {
        IProject[] projects;
        try {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)root);
            IJavaProject[] jprojects = model.getJavaProjects();
            projects = new IProject[jprojects.length];
            int i = 0;
            while (i < jprojects.length) {
                projects[i] = jprojects[i].getProject();
                ++i;
            }
        }
        catch (JavaModelException e) {
            projects = null;
        }
        return projects;
    }

    private static IProject[] getProjects(IStructuredSelection selection) {
        IProject[] projects = new IProject[1];
        Object el = selection.getFirstElement();
        if (el instanceof IResource) {
            projects[0] = ((IResource)el).getProject();
            return projects;
        }
        if (el instanceof IJavaElement) {
            projects[0] = ((IJavaElement)el).getJavaProject().getProject();
            return projects;
        }
        return null;
    }

    private static ISelection getSelection() {
        return TypeDialog.getWorkbenchWindow().getSelectionService().getSelection();
    }

    private static IWorkbenchWindow getWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        ResourcesPlugin.getPlugin();
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

