/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.editors;

import com.tssap.selena.properties.IPropertyEditor;
import com.tssap.selena.properties.internal.PropertiesPlugin;
import com.tssap.selena.properties.internal.TypeSelectionDialog;
import com.tssap.selena.properties.internal.editors.CustomCellEditor;
import com.tssap.selena.properties.internal.editors.ScopeHandler;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.IPropertySupport;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TypeEditor
implements IPropertyEditor,
IExecutableExtension {
    private boolean primitive;
    protected ScopeHandler myScopeHandler;

    public TypeEditor() {
        this(new ScopeHandler());
    }

    protected TypeEditor(ScopeHandler handler) {
        this.myScopeHandler = handler;
    }

    public void setInitializationData(IConfigurationElement config, String property, Object data) throws CoreException {
        this.primitive = "true".equals(config.getAttribute("primitive"));
    }

    public CellEditor createCellEditor(IPropertySupport support, Composite parent, Object[] params) {
        this.myScopeHandler.initScope(params);
        return new Editor(parent, support.getPropertyMarshaler());
    }

    protected IType chooseType(Shell shell, IType[] currentValue) {
        TypeSelectionDialog dlg = PropertiesPlugin.getTypeDialog();
        dlg.setTitle(PropertiesPlugin.getInstance().getLocalizedMessage("TypeEditor.DialogTitle"));
        dlg.setMessage(PropertiesPlugin.getInstance().getLocalizedMessage("TypeEditor.DialogMessage"));
        dlg.setScope((IJavaElement[])this.myScopeHandler.getScopeRoots());
        dlg.setCurrentSelection(currentValue);
        return dlg.chooseType(shell);
    }

    class Editor
    extends CustomCellEditor {
        Editor(Composite parent, IPropertyMarshaler marshaler) {
            super(parent, marshaler);
        }

        protected void doSetValue(Object value) {
            if (value instanceof IType) {
                value = ((IType)value).getFullyQualifiedName();
            } else if (value == null) {
                value = "";
            }
            super.doSetValue(value);
        }

        protected Object openDialogBox(Control window) {
            List l = TypeEditor.this.myScopeHandler.findTypesInScope((String)super.doGetValue());
            IType type = TypeEditor.this.chooseType(window.getShell(), l.toArray(new IType[l.size()]));
            return type == null ? null : type.getFullyQualifiedName();
        }

        protected String isValueValid(Object value) {
            if (value instanceof IType) {
                return TypeEditor.this.myScopeHandler.isValidType((IType)value);
            }
            if (value instanceof String) {
                if (TypeEditor.this.primitive && this.isPrimitiveType((String)value)) {
                    return null;
                }
                IStatus status = JavaConventions.validateJavaTypeName((String)((String)value));
                if (status.getSeverity() == 4) {
                    return PropertiesPlugin.getPrepared4MessageFormat(status.getMessage());
                }
                return TypeEditor.this.myScopeHandler.isValidType((String)value);
            }
            return PropertiesPlugin.getInstance().getLocalizedMessage("IllegalValue", new Object[]{value});
        }

        private boolean isPrimitiveType(String value) {
            if ("int".equals(value)) {
                return true;
            }
            if ("long".equals(value)) {
                return true;
            }
            if ("float".equals(value)) {
                return true;
            }
            if ("double".equals(value)) {
                return true;
            }
            if ("boolean".equals(value)) {
                return true;
            }
            if ("short".equals(value)) {
                return true;
            }
            if ("char".equals(value)) {
                return true;
            }
            return "byte".equals(value);
        }
    }
}

