/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.editors;

import com.tssap.selena.properties.IPropertyEditor;
import com.tssap.selena.properties.internal.PropertiesPlugin;
import com.tssap.selena.properties.internal.TypeSelectionDialog;
import com.tssap.selena.properties.internal.editors.CustomCellEditor;
import com.tssap.selena.properties.internal.editors.ScopeHandler;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.IPropertySupport;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TypeArrayEditor
implements IPropertyEditor {
    protected ScopeHandler myScopeHandler;

    public TypeArrayEditor() {
        this(new ScopeHandler());
    }

    protected TypeArrayEditor(ScopeHandler handler) {
        this.myScopeHandler = handler;
    }

    public CellEditor createCellEditor(IPropertySupport support, Composite parent, Object[] params) {
        this.myScopeHandler.initScope(params);
        return new Editor(parent, support.getPropertyMarshaler());
    }

    protected IType[] chooseTypes(Shell shell, IType[] currentValue) {
        TypeSelectionDialog dlg = PropertiesPlugin.getTypeDialog();
        dlg.setTitle(PropertiesPlugin.getInstance().getLocalizedMessage("TypeArrayEditor.DialogTitle"));
        dlg.setMessage(PropertiesPlugin.getInstance().getLocalizedMessage("TypeArrayEditor.DialogMessage"));
        dlg.setScope((IJavaElement[])this.myScopeHandler.getScopeRoots());
        dlg.setCurrentSelection(currentValue);
        return dlg.chooseTypes(shell);
    }

    class Editor
    extends CustomCellEditor {
        Editor(Composite parent, IPropertyMarshaler marshaler) {
            super(parent, marshaler);
        }

        protected void doSetValue(Object value) {
            if (value instanceof Object[]) {
                Object[] vv = (Object[])value;
                String[] names = new String[vv.length];
                int i = 0;
                while (i < vv.length) {
                    names[i] = this.getValueAsString(vv[i]);
                    ++i;
                }
                super.doSetValue(names);
            } else {
                super.doSetValue(new Object[]{this.getValueAsString(value)});
            }
        }

        protected Object openDialogBox(Control window) {
            List l = TypeArrayEditor.this.myScopeHandler.findTypesInScope((String[])super.doGetValue());
            IType[] types = TypeArrayEditor.this.chooseTypes(window.getShell(), l.toArray(new IType[l.size()]));
            if (types != null) {
                String[] names = new String[types.length];
                int i = 0;
                while (i < types.length) {
                    names[i] = types[i].getFullyQualifiedName();
                    ++i;
                }
                return names;
            }
            return null;
        }

        protected String isValueValid(Object value) {
            if (value instanceof String[]) {
                String[] names = (String[])value;
                int i = 0;
                while (i < names.length) {
                    IStatus status = JavaConventions.validateJavaTypeName((String)names[i]);
                    if (status.getSeverity() == 4) {
                        return PropertiesPlugin.getPrepared4MessageFormat(status.getMessage());
                    }
                    String validity = TypeArrayEditor.this.myScopeHandler.isValidType(names[i]);
                    if (validity != null) {
                        return validity;
                    }
                    ++i;
                }
                return null;
            }
            return PropertiesPlugin.getInstance().getLocalizedMessage("IllegalValue", new Object[]{value});
        }

        private String getValueAsString(Object value) {
            if (value instanceof IType) {
                return ((IType)value).getFullyQualifiedName();
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value == null) {
                return "";
            }
            return value.toString();
        }
    }
}

