/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.editors;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.IJavaSearchScope;

public abstract class SearchScope
implements IJavaSearchScope {
    private IJavaProject[] projects;
    private String[] projectPaths;
    private IPath[] enclosingPaths;

    SearchScope(IJavaProject[] projects) {
        this.projects = projects;
        this.projectPaths = new String[projects.length];
        this.enclosingPaths = new IPath[projects.length];
        int i = 0;
        while (i < projects.length) {
            IPath path = projects[i].getResource().getFullPath();
            this.projectPaths[i] = path.toString();
            this.enclosingPaths[i] = path;
            ++i;
        }
    }

    public IJavaProject[] getProjects() {
        return this.projects;
    }

    public void setProjects(IJavaProject[] projects) {
        this.projects = projects;
    }

    public boolean encloses(String resourcePath) {
        int i = 0;
        while (i < this.projectPaths.length) {
            if (resourcePath.startsWith(this.projectPaths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.enclosingPaths;
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    public abstract boolean encloses(IJavaElement var1);
}

