/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.editors;

import com.tssap.selena.properties.internal.PropertiesPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

class ScopeHandler {
    protected List myScope;
    protected Set myScopeProjects;
    private Set myScopePackageRoots;
    private boolean myOnlyTypesInScope;
    private Set myScopePackages;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    ScopeHandler() {
    }

    public void initScope(Object[] params) {
        this.myScope = ScopeHandler.extractJavaElements(params);
        this.myOnlyTypesInScope = ScopeHandler.isOnlyTypesInScope(this.myScope);
        if (this.myScope == null) {
            this.myScope = ScopeHandler.getAllJavaProjects();
        }
        this.myScopePackages = ScopeHandler.getPackages(this.myScope);
        this.myScopeProjects = ScopeHandler.getJavaProjects(this.myScope);
        this.myScopePackageRoots = this.myScopePackages.isEmpty() ? ScopeHandler.getPackageRoots(this.myScopeProjects) : ScopeHandler.getPackageRoots(this.myScope);
    }

    public String isValidType(IType type) {
        return null;
    }

    public String isValidType(String typeName) {
        Iterator it;
        List typesInScope = this.findTypesInScope(typeName);
        if (typesInScope.isEmpty()) {
            it = this.getScopeProjects().iterator();
            while (it.hasNext()) {
                IJavaProject jp = (IJavaProject)it.next();
                try {
                    if (jp.findType(typeName) == null) continue;
                    return PropertiesPlugin.getInstance().getLocalizedMessage("ScopeHandler.TypeOutOfScope", new Object[]{typeName});
                }
                catch (JavaModelException ex) {
                    PropertiesPlugin.getInstance().getLog().log(ex.getStatus());
                }
            }
        }
        it = typesInScope.iterator();
        while (it.hasNext()) {
            String validity = this.isValidType((IType)it.next());
            if (validity == null) continue;
            return validity;
        }
        return null;
    }

    public List getScope() {
        return this.myScope;
    }

    public IJavaElement[] getScopeAsArray() {
        return this.myScope.toArray(new IJavaElement[this.myScope.size()]);
    }

    public Set getScopeProjects() {
        return this.myScopeProjects;
    }

    public IPackageFragmentRoot[] getScopeRoots() {
        return this.myScopePackageRoots.toArray(new IPackageFragmentRoot[this.myScopePackageRoots.size()]);
    }

    List findTypesInScope(String aTypeName) {
        String packageName = Signature.getQualifier((String)aTypeName);
        String typeName = Signature.getSimpleName((String)aTypeName);
        if (typeName.length() == aTypeName.length()) {
            IType t;
            if (!this.myScopePackages.isEmpty()) {
                return this.findSimpleTypeInPackages(typeName);
            }
            if (this.myOnlyTypesInScope && (t = this.findSimpleTypeUsingScopeTypes(typeName)) != null) {
                return Collections.singletonList(t);
            }
        }
        return this.findTypesInPackageRoots(packageName, typeName);
    }

    List findTypesInScope(String[] typeNames) {
        ArrayList rv = new ArrayList(typeNames.length + 5);
        int i = 0;
        while (i < typeNames.length) {
            rv.addAll(this.findTypesInScope(typeNames[i]));
            ++i;
        }
        return rv;
    }

    private List findTypesInPackageRoots(String packageName, String typeName) {
        ArrayList<IType> list = new ArrayList<IType>();
        Iterator it = this.myScopePackageRoots.iterator();
        while (it.hasNext()) {
            IType type;
            IPackageFragmentRoot pfr = (IPackageFragmentRoot)it.next();
            IPackageFragment pf = pfr.getPackageFragment(packageName);
            if (!pf.exists() || (type = ScopeHandler.findTypeInPackage(pf, typeName)) == null) continue;
            list.add(type);
        }
        return list;
    }

    private List findSimpleTypeInPackages(String simpleTypeName) {
        ArrayList<IType> rv = new ArrayList<IType>();
        Iterator it = this.myScopePackages.iterator();
        while (it.hasNext()) {
            IType t = ScopeHandler.findTypeInPackage((IPackageFragment)it.next(), simpleTypeName);
            if (t == null) continue;
            rv.add(t);
        }
        return rv;
    }

    private IType findSimpleTypeUsingScopeTypes(String simpleTypeName) {
        if (!this.myOnlyTypesInScope) {
            throw new IllegalStateException();
        }
        Iterator it = this.myScope.iterator();
        while (it.hasNext()) {
            IType next = (IType)it.next();
            try {
                IType candidate;
                String[][] resolved = next.resolveType(simpleTypeName);
                if (resolved == null || (candidate = next.getJavaProject().findType(resolved[0][0], resolved[0][1])) == null) continue;
                return candidate;
            }
            catch (JavaModelException ex) {
                PropertiesPlugin.log(ex.getStatus());
            }
        }
        return null;
    }

    private static IType findTypeInPackage(IPackageFragment pf, String simpleTypeName) {
        try {
            ICompilationUnit cu = pf.getCompilationUnit(simpleTypeName + ".java");
            IType t = null;
            if (cu.exists()) {
                t = cu.getType(simpleTypeName);
            } else {
                IClassFile cf = pf.getClassFile(simpleTypeName + ".class");
                if (cf.exists()) {
                    t = cf.getType();
                }
            }
            if (t != null && t.exists()) {
                return t;
            }
        }
        catch (JavaModelException ex) {
            PropertiesPlugin.log(ex.getStatus());
        }
        return null;
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    private static boolean hasSourcePackageRoot(IJavaElement je) {
        try {
            IPackageFragmentRoot pfr = ScopeHandler.getPackageFragmentRoot(je);
            if (pfr != null) {
                return pfr.getKind() == 1;
            }
        }
        catch (JavaModelException ex) {
            PropertiesPlugin.log(ex.getStatus());
        }
        return false;
    }

    private static List extractJavaElements(Object[] params) {
        if (params == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(params.length);
        int i = 0;
        while (i < params.length) {
            if (params[i] instanceof IJavaElement) {
                list.add(params[i]);
            } else {
                Object je = Platform.getAdapterManager().getAdapter(params[i], class$org$eclipse$jdt$core$IJavaElement == null ? ScopeHandler.class$("org.eclipse.jdt.core.IJavaElement") : class$org$eclipse$jdt$core$IJavaElement);
                if (je == null && params[i] instanceof IAdaptable) {
                    je = ((IAdaptable)params[i]).getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? ScopeHandler.class$("org.eclipse.jdt.core.IJavaElement") : class$org$eclipse$jdt$core$IJavaElement);
                }
                if (je instanceof IJavaElement) {
                    list.add(je);
                }
            }
            ++i;
        }
        return Collections.unmodifiableList(list);
    }

    private static Set getJavaProjects(List javaElements) {
        HashSet<IJavaProject> rv = new HashSet<IJavaProject>();
        Iterator it = javaElements.iterator();
        while (it.hasNext()) {
            rv.add(((IJavaElement)it.next()).getJavaProject());
        }
        return Collections.unmodifiableSet(rv);
    }

    private static List getAllJavaProjects() {
        try {
            ResourcesPlugin.getPlugin();
            return Arrays.asList(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects());
        }
        catch (JavaModelException ex) {
            PropertiesPlugin.getInstance().getLog().log(ex.getStatus());
            throw new IllegalStateException(PropertiesPlugin.getInstance().getLocalizedMessage("ScopeHandler.CouldntGetJavaProjectsInWorkspace") + ex.getLocalizedMessage());
        }
    }

    private static Set getPackageRoots(Collection javaElements) {
        HashSet<IPackageFragmentRoot> rv = new HashSet<IPackageFragmentRoot>();
        Iterator it = javaElements.iterator();
        while (it.hasNext()) {
            IJavaElement next = (IJavaElement)it.next();
            IPackageFragmentRoot pfr = ScopeHandler.getPackageFragmentRoot(next);
            if (pfr != null) {
                rv.add(pfr);
                continue;
            }
            try {
                rv.addAll(Arrays.asList(next.getJavaProject().getPackageFragmentRoots()));
            }
            catch (JavaModelException ex) {
                PropertiesPlugin.log(ex.getStatus());
            }
        }
        return Collections.unmodifiableSet(rv);
    }

    private static Set getPackages(List javaElements) {
        HashSet<IPackageFragment> rv = new HashSet<IPackageFragment>();
        Iterator it = javaElements.iterator();
        while (it.hasNext()) {
            IJavaElement next = (IJavaElement)it.next();
            if (next.getElementType() != 4) continue;
            rv.add((IPackageFragment)next);
        }
        return Collections.unmodifiableSet(rv);
    }

    private static boolean isOnlyTypesInScope(List javaElements) {
        if (javaElements == null) {
            return false;
        }
        Iterator it = javaElements.iterator();
        while (it.hasNext()) {
            IJavaElement next = (IJavaElement)it.next();
            if (next.getElementType() == 7) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

