/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.editors;

import com.tssap.selena.properties.internal.editors.SearchScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ExtendsScope
extends SearchScope {
    private IType[] subjects;
    private IType[][] subjectTypes;

    ExtendsScope(IJavaProject[] projects, String typeName) {
        super(projects);
        try {
            this.init(typeName);
        }
        catch (JavaModelException e) {
            this.subjects = null;
        }
    }

    private void init(String typeName) throws JavaModelException {
        Path path = new Path(typeName.replace('.', '/'));
        IJavaProject[] projects = this.getProjects();
        this.subjects = new IType[projects.length];
        int i = 0;
        while (i < projects.length) {
            this.subjects[i] = this.findSubject(projects[i], path);
            ++i;
        }
        this.subjectTypes = new IType[projects.length][];
        int i2 = 0;
        while (i2 < this.subjects.length) {
            IType subject = this.subjects[i2];
            if (subject != null) {
                ITypeHierarchy hierarchy = subject.newTypeHierarchy(null);
                this.subjectTypes[i2] = hierarchy.getAllSubtypes(subject);
            }
            ++i2;
        }
    }

    private IType findSubject(IJavaProject project, Path path) throws JavaModelException {
        IJavaProject[] projects = this.getProjects();
        int i = 0;
        while (i < projects.length) {
            IJavaElement element = projects[i].getJavaProject().findElement((IPath)path);
            if (element instanceof IType) {
                return (IType)element;
            }
            ++i;
        }
        return null;
    }

    private ITypeHierarchy createHierarchy(IJavaProject project) throws JavaModelException {
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)project);
        return project.newTypeHierarchy(region, null);
    }

    public boolean encloses(IJavaElement element) {
        if (this.subjects != null && element instanceof IType) {
            return this.encloses((IType)element);
        }
        return false;
    }

    private boolean encloses(IType type) {
        IJavaProject project = type.getJavaProject();
        IJavaProject[] projects = this.getProjects();
        int i = 0;
        while (i < projects.length) {
            if (project.equals(projects[i])) {
                IType[] types = this.subjectTypes[i];
                if (types == null) {
                    return false;
                }
                int j = 0;
                while (j < types.length) {
                    if (type.equals(types[j])) {
                        return true;
                    }
                    ++j;
                }
                return false;
            }
            ++i;
        }
        return false;
    }
}

