/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.editors;

import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.properties.internal.PropertiesPlugin;
import com.tssap.selena.ui.IPropertyMarshaler;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class CustomCellEditor
extends TextCellEditor
implements ICellEditorValidator {
    private Object value;
    private IPropertyMarshaler marshaler;
    private Composite editor;
    private Control contents;
    private Button button;

    public CustomCellEditor(Composite parent, IPropertyMarshaler marshaler) {
        super(parent);
        this.marshaler = marshaler;
        this.setValidator(this);
        this.setValueValid(true);
    }

    protected void focusLost() {
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, 0);
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new DialogCellLayout());
        this.contents = super.createControl(this.editor);
        this.button = this.createButton(this.editor);
        this.button.setFont(font);
        this.button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    CustomCellEditor.super.fireCancelEditor();
                }
            }
        });
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModelAccess.runCommand((Runnable)new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Object newValue = 2.access$200(this.this$1).openDialogBox((Control)CustomCellEditor.access$300(2.access$200(this.this$1)));
                        if (newValue != 2.access$200(this.this$1).getValue()) {
                            boolean oldValidState = 2.access$200(this.this$1).isValueValid();
                            boolean newValidState = CustomCellEditor.access$401(2.access$200(this.this$1), newValue);
                            if (newValidState) {
                                2.access$200(this.this$1).setValue(newValue);
                            }
                            CustomCellEditor.access$501(2.access$200(this.this$1));
                        }
                    }
                });
            }

            static /* synthetic */ CustomCellEditor access$200(2 x0) {
                return x0.CustomCellEditor.this;
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 0x800008);
        Image img = PropertiesPlugin.getInstance().getImageRegistry().get("typeSelectionImage");
        result.setImage(img);
        return result;
    }

    protected abstract Object openDialogBox(Control var1);

    protected Object doGetValue() {
        Object text = super.doGetValue();
        Object value = this.marshaler.unmarshal((String)text);
        return value;
    }

    protected void doSetValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (!(value instanceof String)) {
            value = this.marshaler.marshal(value);
        }
        super.doSetValue(value);
    }

    public String isValid(Object value) {
        if (value instanceof String) {
            value = this.marshaler.unmarshal((String)value);
        }
        return this.isValueValid(value);
    }

    protected abstract String isValueValid(Object var1);

    static /* synthetic */ Composite access$300(CustomCellEditor x0) {
        return x0.editor;
    }

    static /* synthetic */ boolean access$401(CustomCellEditor x0, Object x1) {
        return super.isCorrect(x1);
    }

    static /* synthetic */ void access$501(CustomCellEditor x0) {
        super.fireApplyEditorValue();
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = CustomCellEditor.this.button.computeSize(-1, -1, force);
            if (CustomCellEditor.this.contents != null) {
                CustomCellEditor.this.contents.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            CustomCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = CustomCellEditor.this.contents.computeSize(-1, -1, force);
            Point buttonSize = CustomCellEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

