/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.celleditor;

import com.tssap.selena.properties.internal.celleditor.Messages;
import com.tssap.selena.properties.internal.celleditor.Parameter;
import com.tssap.selena.properties.internal.supports.Util;
import com.tssap.selena.ui.internal.celleditor.TableDialog;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ParametersTableDialog
extends TableDialog {
    private String[] columnHeaders = new String[]{Messages.getString("ParametersTableDialog.Names_9"), Messages.getString("ParametersTableDialog.Types_10")};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(40, true), new ColumnWeightData(60, true)};
    private boolean cellEditorActivated = false;
    private TableDialog.ContentProvider contentProvider = new ParametersContentProvider();
    private String[] comboItems;

    public ParametersTableDialog(Shell parent, String[] defaultItems, String title) {
        super(parent, title);
        this.comboItems = defaultItems;
        this.setBlockOnOpen(true);
    }

    protected void setEditControl(Table table, TableEditor editor, int row, int column) {
        if (row == -1) {
            return;
        }
        if (column == 0) {
            this.nameCellEditor(table, editor, row, column);
        } else if (column == 1) {
            this.typeCellEditor(table, editor, row, column);
        }
    }

    public Object[] getValues() {
        return this.contentProvider.getElements(null);
    }

    public void setValues(Object[] values) {
        if (values == null) {
            return;
        }
        int i = 0;
        while (i < values.length) {
            this.contentProvider.add(values[i]);
            ++i;
        }
    }

    public void okPressed() {
        Parameter[] parameters = (Parameter[])this.contentProvider.getElements(null);
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = parameters[i];
            boolean nameValid = Util.validateName((IJavaElement)null, parameter.getName());
            boolean typeValid = Util.validateName(7, parameter.getType());
            if (!nameValid || !typeValid) {
                this.table.select(i);
                if (!nameValid) {
                    this.setEditControl(this.table, this.editor, i, 0);
                } else {
                    this.setEditControl(this.table, this.editor, i, 1);
                }
                String[] buttons = new String[]{Messages.getString("ParametersTableDialog.OK_1")};
                MessageDialog dlg = new MessageDialog(null, Messages.getString("ParametersTableDialog.Wrong_name_or_type_2"), null, Messages.getString("ParametersTableDialog.You_entered_wrong_name_or_type_of_paremeter._3"), 4, buttons, 0);
                dlg.open();
                return;
            }
            ++i;
        }
        this.cellEditorActivated = false;
        super.okPressed();
    }

    protected TableDialog.ContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected ITableLabelProvider getLabelProvider() {
        return new MyLabelProvider();
    }

    protected void removeRow(int row) {
        this.contentProvider.remove(row);
    }

    protected void addRow(int row) {
        this.contentProvider.add((Object)new Parameter("parameter" + row, "int"));
    }

    protected void acceptChanges(String text, String oldText, int row, int column) {
        if (oldText.equals(text)) {
            return;
        }
        Parameter parameter = (Parameter)this.contentProvider.get(row);
        Control edt = this.editor.getEditor();
        if (parameter != null) {
            if (column == 0) {
                parameter.setName(text);
            } else if (column == 1) {
                parameter.setType(text);
            }
            this.contentProvider.replace((Object)parameter, row);
            this.refreshViewer();
        }
    }

    protected boolean isEditorActivated() {
        return this.cellEditorActivated;
    }

    protected String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    protected ColumnLayoutData[] getColumnLayouts() {
        return this.columnLayouts;
    }

    private void nameCellEditor(Table table, final TableEditor editor, final int row, final int column) {
        TableItem item = table.getItem(row);
        if (item == null) {
            return;
        }
        Parameter parameter = (Parameter)item.getData();
        final Text text = new Text((Composite)table, 0);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 0;
        text.setLayoutData((Object)gd);
        text.setText(parameter.getName());
        final String oldText = parameter.getName();
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ParametersTableDialog.this.cellEditorActivated = true;
            }

            public void focusLost(FocusEvent e) {
                ParametersTableDialog.this.acceptChanges(text.getText(), oldText, row, column);
                ParametersTableDialog.this.cellEditorActivated = false;
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    ParametersTableDialog.this.acceptChanges(text.getText(), oldText, row, column);
                    ParametersTableDialog.this.cellEditorActivated = false;
                } else if (e.keyCode == 27) {
                    ParametersTableDialog.this.cellEditorActivated = false;
                    editor.getEditor().dispose();
                }
            }
        });
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        editor.setEditor((Control)text, item, column);
        text.setFocus();
    }

    private void typeCellEditor(Table table, TableEditor editor, final int row, final int column) {
        TableItem item = table.getItem(row);
        if (item == null) {
            return;
        }
        Parameter parameter = (Parameter)item.getData();
        Composite pane = new Composite((Composite)table, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        pane.setLayout((Layout)layout);
        final CCombo comboBox = new CCombo(pane, 0);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 0;
        comboBox.setLayoutData((Object)gd);
        this.populateComboBoxItems(comboBox);
        comboBox.setText(parameter.getType());
        final String oldText = parameter.getType();
        comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ParametersTableDialog.this.cellEditorActivated = true;
            }

            public void focusLost(FocusEvent e) {
                ParametersTableDialog.this.acceptChanges(comboBox.getText(), oldText, row, column);
                ParametersTableDialog.this.cellEditorActivated = false;
            }
        });
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        Button button = new Button(pane, 8);
        button.setText(Messages.getString("ParametersTableDialog...._6"));
        gd = new GridData(1040);
        gd.heightHint = 10;
        button.setLayoutData((Object)gd);
        Display display = button.getDisplay();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IType type;
                try {
                    type = ParametersTableDialog.this.chooseClassType(ParametersTableDialog.this.getShell());
                }
                catch (JavaModelException e) {
                    type = null;
                }
                if (type != null) {
                    comboBox.setFocus();
                    comboBox.setText(type.getFullyQualifiedName());
                }
            }
        });
        editor.setEditor((Control)pane, item, column);
        comboBox.setFocus();
    }

    private void populateComboBoxItems(CCombo comboBox) {
        if (comboBox != null && this.comboItems != null) {
            int i = 0;
            while (i < this.comboItems.length) {
                comboBox.add(this.comboItems[i], i);
                ++i;
            }
        }
    }

    private IType chooseClassType(Shell shell) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IResource[])Util.getProjects());
        scope.setIncludesBinaries(true);
        scope.setIncludesClasspaths(true);
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)Util.getWorkbenchWindow(), (IJavaSearchScope)scope, (int)6, (boolean)false);
        dialog.setBlockOnOpen(true);
        dialog.setTitle(Messages.getString("ParametersTableDialog.Select_7"));
        dialog.setMessage(Messages.getString("ParametersTableDialog.Select_class_or_interface_8"));
        dialog.setInitialSelections(new Object[0]);
        if (dialog.open() == 0) {
            return (IType)dialog.getResult()[0];
        }
        return null;
    }

    protected class ParametersContentProvider
    extends TableDialog.GenericContentProvider {
        protected ParametersContentProvider() {
            super((TableDialog)ParametersTableDialog.this);
        }

        public Object[] getElements(Object parent) {
            Parameter[] elms = new Parameter[this.elements.size()];
            return this.elements.toArray(elms);
        }
    }

    private class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Parameter) {
                Parameter parameter = (Parameter)element;
                if (columnIndex == 0) {
                    return parameter.getName();
                }
                if (columnIndex == 1) {
                    return parameter.getType();
                }
            }
            return element.toString();
        }
    }
}

