/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.celleditor;

import com.tssap.selena.properties.internal.celleditor.Messages;
import com.tssap.selena.properties.internal.celleditor.Parameter;
import com.tssap.selena.properties.internal.celleditor.ParametersTableDialog;
import com.tssap.selena.ui.internal.celleditor.LabelDialogCellEditor;
import java.util.StringTokenizer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ParametersCellEditor
extends LabelDialogCellEditor {
    private static final String DIVIDER = ", ";
    private String[] myItems;

    public ParametersCellEditor(Composite parent, String[] items) {
        super(parent);
        this.myItems = items;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        String value = (String)this.getValue();
        String[][] values = this.parseFromString(value);
        Object[] params = new Parameter[]{};
        if (values != null && values.length > 0) {
            params = new Parameter[values[0].length];
            int i = 0;
            while (i < values[0].length) {
                params[i] = new Parameter(values[1][i], values[0][i]);
                ++i;
            }
        }
        ParametersTableDialog dialog = new ParametersTableDialog(cellEditorWindow.getShell(), this.myItems, Messages.getString("ParametersCellEditor.Select_Parameters_for_Operation_1"));
        dialog.setValues(params);
        int res = dialog.open();
        if (res != 0) {
            return value;
        }
        params = (Parameter[])dialog.getValues();
        values = new String[2][params.length];
        int i = 0;
        while (i < params.length) {
            values[0][i] = ((Parameter)params[i]).getType();
            values[1][i] = ((Parameter)params[i]).getName();
            ++i;
        }
        return this.parseToString(values);
    }

    protected String[][] parseFromString(String value) {
        StringTokenizer st;
        String[][] values = new String[][]{};
        if (value != null && value.length() > 0 && (st = new StringTokenizer(value, ",")).countTokens() > 0) {
            values = new String[2][st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                String str = st.nextToken().trim();
                int ind = str.lastIndexOf(" ");
                if (ind != -1) {
                    values[0][i] = str.substring(0, ind).trim();
                    values[1][i] = str.substring(ind).trim();
                }
                ++i;
            }
        }
        return values;
    }

    protected String parseToString(String[][] values) {
        String value = "";
        if (values != null && values[0].length > 0) {
            int i = 0;
            while (i < values[0].length) {
                value = value + values[0][i] + " " + values[1][i];
                if (i < values[0].length - 1) {
                    value = value + DIVIDER;
                }
                ++i;
            }
        }
        return value;
    }
}

