/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.celleditor;

import com.tssap.selena.properties.internal.celleditor.Messages;
import com.tssap.selena.properties.internal.supports.Util;
import com.tssap.selena.ui.internal.celleditor.OneColumnTableDialog;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class MultyChooserTableDialog
extends OneColumnTableDialog {
    private boolean myChooser;
    private boolean cellEditorActivated = false;

    public MultyChooserTableDialog(Shell parent, String title, boolean chooser) {
        super(parent, title);
        this.myChooser = chooser;
    }

    protected void setEditControl(Table table, final TableEditor editor, final int row, final int column) {
        if (row == -1) {
            return;
        }
        TableItem item = table.getItem(row);
        if (item == null) {
            return;
        }
        Composite pane = new Composite((Composite)table, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        pane.setLayout((Layout)layout);
        final Text text = new Text(pane, 0);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 0;
        text.setLayoutData((Object)gd);
        final String oldText = item.getText();
        text.setText(oldText);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MultyChooserTableDialog.this.cellEditorActivated = true;
            }

            public void focusLost(FocusEvent e) {
                MultyChooserTableDialog.super.acceptChanges(text.getText(), oldText, row, column);
                MultyChooserTableDialog.this.cellEditorActivated = false;
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    MultyChooserTableDialog.super.acceptChanges(text.getText(), oldText, row, column);
                    MultyChooserTableDialog.this.cellEditorActivated = false;
                } else if (e.keyCode == 27) {
                    MultyChooserTableDialog.this.cellEditorActivated = false;
                    editor.getEditor().dispose();
                }
            }
        });
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        if (this.myChooser) {
            Button button = new Button(pane, 8);
            button.setText(Messages.getString("MultyChooserTableDialog...._1"));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IType type;
                    try {
                        type = MultyChooserTableDialog.this.chooseClassType(MultyChooserTableDialog.this.getShell());
                    }
                    catch (JavaModelException e) {
                        type = null;
                    }
                    if (type != null) {
                        text.setFocus();
                        text.setText(type.getFullyQualifiedName());
                    }
                }
            });
            gd = new GridData(1040);
            gd.heightHint = 10;
            button.setLayoutData((Object)gd);
        }
        editor.setEditor((Control)pane, item, 0);
        text.setFocus();
    }

    private IType chooseClassType(Shell shell) throws JavaModelException {
        Object[] objs;
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IResource[])Util.getProjects());
        scope.setIncludesBinaries(true);
        scope.setIncludesClasspaths(true);
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)Util.getWorkbenchWindow(), (IJavaSearchScope)scope, (int)6, (boolean)false);
        dialog.setBlockOnOpen(true);
        dialog.setMessage("");
        dialog.setTitle(Messages.getString("MultyChooserTableDialog.Select_3"));
        dialog.setInitialSelections(new Object[0]);
        if (dialog.open() == 0 && (objs = dialog.getResult()) != null && objs.length > 0) {
            return (IType)objs[0];
        }
        return null;
    }
}

