/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal.celleditor;

import com.tssap.selena.properties.internal.celleditor.Messages;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ComboDialogCellEditor
extends DialogCellEditor {
    private CCombo comboBox;
    private String[] comboItems;

    public ComboDialogCellEditor(Composite parent, String[] defaultItems) {
        super(parent);
        this.comboItems = defaultItems;
        this.populateComboBoxItems();
    }

    protected Button createButton(Composite parent) {
        Button button = new Button(parent, 1);
        button.setText(Messages.getString("ComboDialogCellEditor...._1"));
        return button;
    }

    protected Control createContents(Composite cell) {
        this.comboBox = new CCombo(cell, 0);
        this.comboBox.setFont(cell.getFont());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ComboDialogCellEditor.super.keyReleaseOccured(e);
                ComboDialogCellEditor.super.fireEditorValueChanged(false, ComboDialogCellEditor.super.isCorrect(ComboDialogCellEditor.this.comboBox.getText()));
                if (e.character == '\u001b') {
                    ComboDialogCellEditor.super.fireEditorValueChanged(false, true);
                }
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                int index = ComboDialogCellEditor.this.comboBox.getSelectionIndex();
                if (index >= 0) {
                    ComboDialogCellEditor.this.doSetValue(ComboDialogCellEditor.this.comboBox.getItem(index));
                }
                ComboDialogCellEditor.super.fireApplyEditorValue();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        return this.comboBox;
    }

    protected Object doGetValue() {
        return this.comboBox.getText();
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected void doSetValue(Object value) {
        this.comboBox.setText((String)value);
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.comboItems != null) {
            int i = 0;
            while (i < this.comboItems.length) {
                this.comboBox.add(this.comboItems[i], i);
                ++i;
            }
            this.setValueValid(true);
        }
    }

    protected void updateContents(Object value) {
    }
}

