/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal;

import com.tssap.selena.properties.IPropertyEditor;
import com.tssap.selena.properties.IPropertyViewer;
import com.tssap.selena.properties.internal.TypeSelectionDialog;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class PropertiesPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.togethersoft.selena.properties";
    private static final String PT_PROPERTIES = "propertySupportParts";
    public static final String PT_TYPE_SELECTION_DLG = "typeSelectionDialog";
    public static final String TYPE_SELECTION_DLG_IMAGE = "typeSelectionImage";
    private static final String NODE_EDITOR = "editor";
    private static final String NODE_VIEWER = "viewer";
    private static final String ATTR_ORDER = "order";
    private static final String ATTR_CLASS = "class";
    private static boolean debug;
    private static PropertiesPlugin plugin;
    private static HashMap propertyEditors;
    private static HashMap propertyViewers;
    private static TypeSelectionDialog myTypeDialog;
    private boolean mySupportPartsInited = false;
    static /* synthetic */ Class class$com$tssap$selena$properties$IPropertyEditor;
    static /* synthetic */ Class class$com$tssap$selena$properties$IPropertyViewer;

    public static PropertiesPlugin getInstance() {
        return plugin;
    }

    public static IStatus log(IStatus status) {
        plugin.getLog().log(status);
        return status;
    }

    public static IStatus info(String message) {
        return PropertiesPlugin.info(message, null);
    }

    public static IStatus info(String message, Throwable exception) {
        return PropertiesPlugin.log((IStatus)new Status(1, PLUGIN_ID, 1, message, exception));
    }

    public static IStatus error(String message) {
        return PropertiesPlugin.error(message, null);
    }

    public static IStatus error(String message, Throwable exception) {
        return PropertiesPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, message, exception));
    }

    public static IStatus debug(String message) {
        return PropertiesPlugin.debug(message, null);
    }

    public static IStatus debug(String message, Throwable exception) {
        if (!debug) {
            return null;
        }
        return PropertiesPlugin.log((IStatus)new Status(1, PLUGIN_ID, 1, message, exception));
    }

    public static TypeSelectionDialog getTypeDialog() {
        if (myTypeDialog != null) {
            return myTypeDialog;
        }
        IExtensionPoint ep = PropertiesPlugin.getInstance().getDescriptor().getExtensionPoint(PT_TYPE_SELECTION_DLG);
        IConfigurationElement[] ce = ep.getConfigurationElements();
        IConfigurationElement winner = null;
        int winnerOrder = Integer.MAX_VALUE;
        int i = 0;
        while (i < ce.length) {
            try {
                int candidate = Integer.parseInt(ce[i].getAttribute(ATTR_ORDER));
                if (candidate < winnerOrder) {
                    winnerOrder = candidate;
                    winner = ce[i];
                }
            }
            catch (NumberFormatException ex) {
                PropertiesPlugin.getInstance().getLog().log((IStatus)new Status(2, PLUGIN_ID, 0, "Wrong 'order' attribute value", (Throwable)ex));
            }
            ++i;
        }
        if (winner == null) {
            throw new IllegalStateException(PropertiesPlugin.getInstance().getLocalizedMessage("PropertiesPlugin.NoTypeSelectionDialog"));
        }
        try {
            myTypeDialog = (TypeSelectionDialog)winner.createExecutableExtension(ATTR_CLASS);
        }
        catch (CoreException ex) {
            PropertiesPlugin.getInstance().getLog().log(ex.getStatus());
            throw new IllegalStateException(PropertiesPlugin.getInstance().getLocalizedMessage("PropertiesPlugin.CouldntInstanteTypeSelectionDialog"));
        }
        return myTypeDialog;
    }

    public PropertiesPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        debug = this.isDebugging();
        plugin = this;
    }

    public IPropertyEditor getPropertyEditor(Object id) {
        this.initSupports();
        return (IPropertyEditor)propertyEditors.get(id);
    }

    public IPropertyViewer getPropertyViewer(Object id) {
        this.initSupports();
        return (IPropertyViewer)propertyViewers.get(id);
    }

    public void startup() throws CoreException {
        PropertiesPlugin.debug("startup");
    }

    public String getLocalizedMessage(String id) {
        return this.getDescriptor().getResourceString('%' + id);
    }

    public String getLocalizedMessage(String id, Object[] params) {
        String loc = this.getLocalizedMessage(id);
        return MessageFormat.format(loc, params);
    }

    public static String getPrepared4MessageFormat(String probablyWithBraces) {
        if (probablyWithBraces == null) {
            return null;
        }
        if (probablyWithBraces.indexOf(123) == -1) {
            return probablyWithBraces;
        }
        StringTokenizer st = new StringTokenizer(probablyWithBraces, "{");
        StringBuffer result = new StringBuffer();
        while (st.hasMoreTokens()) {
            result.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            result.append("'{'");
        }
        return result.toString();
    }

    private void initSupports() {
        if (this.mySupportPartsInited) {
            return;
        }
        propertyEditors = new HashMap();
        propertyViewers = new HashMap();
        try {
            this.mySupportPartsInited = true;
            IPluginDescriptor descriptor = this.getDescriptor();
            IExtensionPoint pt = descriptor.getExtensionPoint(PT_PROPERTIES);
            if (pt != null) {
                this.hookPropertySupportParts(pt);
            }
        }
        catch (CoreException ex) {
            PropertiesPlugin.log(ex.getStatus());
        }
    }

    private void hookPropertySupportParts(IExtensionPoint pt) throws CoreException {
        IConfigurationElement[] elements = pt.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String name = element.getName();
            if (NODE_EDITOR.equals(name)) {
                this.addPropertyExtension(element, class$com$tssap$selena$properties$IPropertyEditor == null ? PropertiesPlugin.class$("com.tssap.selena.properties.IPropertyEditor") : class$com$tssap$selena$properties$IPropertyEditor, propertyEditors);
            }
            if (NODE_VIEWER.equals(name)) {
                this.addPropertyExtension(element, class$com$tssap$selena$properties$IPropertyViewer == null ? PropertiesPlugin.class$("com.tssap.selena.properties.IPropertyViewer") : class$com$tssap$selena$properties$IPropertyViewer, propertyViewers);
            }
            ++i;
        }
    }

    private void addPropertyExtension(IConfigurationElement el, Class iface, HashMap map) {
        String id = el.getAttribute("id");
        String cls = el.getAttribute(ATTR_CLASS);
        if (id == null) {
            PropertiesPlugin.error("invalid property extension: " + el.getName());
            return;
        }
        if (cls == null) {
            PropertiesPlugin.error("missing property extension class: " + id);
            return;
        }
        try {
            Object extension = el.createExecutableExtension(ATTR_CLASS);
            if (!iface.isInstance(extension)) {
                PropertiesPlugin.error("illegal property extension class: " + id);
            } else {
                map.put(id, extension);
                if (debug) {
                    PropertiesPlugin.debug("PropertiesPlugin.addPropertyExtension: id=" + id + " iface=" + iface.getName());
                }
            }
        }
        catch (Exception e) {
            PropertiesPlugin.error("invalid property extension: " + id, e);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        URL base = this.getDescriptor().getInstallURL();
        reg.put(TYPE_SELECTION_DLG_IMAGE, this.createImageDescriptor(base, "icons/chooseType.gif"));
    }

    private ImageDescriptor createImageDescriptor(URL base, String relativePath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(base, relativePath));
            return id;
        }
        catch (MalformedURLException ex) {
            PropertiesPlugin.error("createImageDescriptor failed:", ex);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

