/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal;

import com.tssap.selena.properties.internal.PropertiesPlugin;
import com.tssap.selena.properties.internal.TypeSelectionDialog;
import java.util.AbstractCollection;
import java.util.HashSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class DefaultTypeDialog
implements TypeSelectionDialog {
    private static final Object[] INITIAL_SELECTIONS = new Object[0];
    private static final IType[] EMPTY_TYPES = new IType[0];
    private String myTitle;
    private String myMessage;
    private IJavaElement[] myScope;
    private IType[] myCurrentSelection;

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public void setMessage(String message) {
        this.myMessage = message;
    }

    public IType chooseType(Shell shell) {
        return DefaultTypeDialog.getSingleValue(this.chooseTypes(shell, null, 6, false, null));
    }

    public IType[] chooseTypes(Shell shell) {
        return this.chooseTypes(shell, null, 6, true, null);
    }

    public IType chooseClass(Shell shell) {
        return DefaultTypeDialog.getSingleValue(this.chooseTypes(shell, null, 2, false, null));
    }

    public IType[] chooseClasses(Shell shell) {
        return this.chooseTypes(shell, null, 2, true, null);
    }

    public IType chooseInterface(Shell shell) {
        return DefaultTypeDialog.getSingleValue(this.chooseTypes(shell, null, 4, false, null));
    }

    public IType[] chooseInterfaces(Shell shell) {
        return this.chooseTypes(shell, null, 4, true, null);
    }

    public IType chooseException(Shell shell) {
        return DefaultTypeDialog.getSingleValue(this.chooseTypes(shell, this.getExceptionSearchScope(), 2, false, "*Exception*"));
    }

    public IType[] chooseExceptions(Shell shell) {
        return this.chooseTypes(shell, this.getExceptionSearchScope(), 2, true, "*Exception*");
    }

    private IType[] chooseTypes(Shell shell, IJavaSearchScope scope, int style, boolean multi, String filter) {
        if (scope == null) {
            scope = this.myScope == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])this.myScope);
        }
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)DefaultTypeDialog.getWorkbenchWindow(), (IJavaSearchScope)scope, (int)style, (boolean)multi, (String)(filter == null ? "" : filter));
            dialog.setTitle(this.myTitle);
            dialog.setMessage(this.myMessage);
            dialog.setInitialSelections(INITIAL_SELECTIONS);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                IType[] types = new IType[result.length];
                System.arraycopy(result, 0, types, 0, result.length);
                return types;
            }
            return this.myCurrentSelection;
        }
        catch (JavaModelException ex) {
            PropertiesPlugin.getInstance().getLog().log(ex.getStatus());
            return null;
        }
    }

    public void setScope(IJavaElement[] javaElements) {
        this.myScope = javaElements;
    }

    public void setCurrentSelection(IType[] currentlySelected) {
        this.myCurrentSelection = currentlySelected;
    }

    private IJavaSearchScope getExceptionSearchScope() {
        if (this.myScope == null) {
            return null;
        }
        HashSet<IJavaProject> projects = new HashSet<IJavaProject>();
        int i = 0;
        while (i < this.myScope.length) {
            IJavaProject jp = (IJavaProject)this.myScope[i].getAncestor(2);
            if (jp != null) {
                projects.add(jp);
            }
            ++i;
        }
        if (projects.isEmpty()) {
            return null;
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])((AbstractCollection)projects).toArray(new IJavaProject[projects.size()]));
    }

    private static IWorkbenchWindow getWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private static IType getSingleValue(IType[] types) {
        return types != null && types.length > 0 ? types[0] : null;
    }
}

