/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.properties.internal;

import com.tssap.selena.properties.IPropertyEditor;
import com.tssap.selena.properties.IPropertyViewer;
import com.tssap.selena.properties.internal.PropertiesPlugin;
import com.tssap.selena.ui.IPropertySupport;
import com.tssap.selena.ui.internal.PropertySupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;

public class DefaultPropertySupport
extends PropertySupport
implements IPropertySupport,
IExecutableExtension {
    private static final String ATTR_VIEWER = "viewer";
    private static final String ATTR_EDITOR = "editor";
    private IPropertyViewer myViewer;
    private IPropertyEditor myEditor;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        String viewerID = config.getAttribute(ATTR_VIEWER);
        String editorID = config.getAttribute(ATTR_EDITOR);
        if (viewerID == null || editorID == null) {
            throw new CoreException((IStatus)new Status(4, "com.togethersoft.selena.properties", 0, "Required attributes (editor, viewer) missed", null));
        }
        this.myViewer = PropertiesPlugin.getInstance().getPropertyViewer(viewerID);
        this.myEditor = PropertiesPlugin.getInstance().getPropertyEditor(editorID);
        if (this.myEditor == null || this.myViewer == null) {
            throw new CoreException((IStatus)new Status(4, "com.togethersoft.selena.properties", 0, "Unknown viewer id(" + viewerID + ") or editor id(" + editorID + ")", null));
        }
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return this.myEditor.createCellEditor(this, parent, null);
    }

    protected ITreeContentProvider createContentProvider() {
        return this.myViewer.getContentProvider();
    }

    protected ILabelProvider createLabelProvider() {
        return this.myViewer.getLabelProvider();
    }

    protected IPropertyViewer getViewer() {
        return this.myViewer;
    }

    protected IPropertyEditor getEditor() {
        return this.myEditor;
    }
}

