/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.ArithmeticExpression;
import com.sap.sql.tree.BetweenPredicate;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.ConcatenationExpression;
import com.sap.sql.tree.ExistsPredicate;
import com.sap.sql.tree.InListPredicate;
import com.sap.sql.tree.InSubqueryPredicate;
import com.sap.sql.tree.LikePredicate;
import com.sap.sql.tree.NullPredicate;
import com.sap.sql.tree.QuantifiedComparisonPredicate;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.RowValueElementList;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.SetFunction;
import java.util.Vector;

public class CheckSubQueryVisitor
extends CheckVisitor {
    private boolean currentIsQuery = false;

    public CheckSubQueryVisitor(Vector errorLog) {
        super(errorLog);
    }

    private void logError(String key) {
        String txt = CommonSQLParserErrors.msg(key);
        this.errorLog.add(new LogEntry(txt, 0, 0));
    }

    public void visitArithmeticExpression(ArithmeticExpression x) {
        if (this.currentIsQuery) {
            this.logError("subQueryArithmeticNotAllowed");
            this.currentIsQuery = false;
        }
    }

    public void visitBetweenPredicate(BetweenPredicate x) {
        if (this.currentIsQuery) {
            this.logError("subQueryBetweenNotAllowed");
            this.currentIsQuery = false;
        }
    }

    public void visitComparisonPredicate(ComparisonPredicate x) {
        if (this.currentIsQuery) {
            if (x.getLeftOperand() instanceof QuerySpecification) {
                this.logError("subQueryComparisonLeftNotAllowed");
            }
            this.currentIsQuery = false;
        }
    }

    public void visitConcatenationExpression(ConcatenationExpression x) {
        if (this.currentIsQuery) {
            this.logError("subQueryConcatNotAllowed");
            this.currentIsQuery = false;
        }
    }

    public void visitExistsPredicate(ExistsPredicate x) {
        this.currentIsQuery = false;
    }

    public void visitInListPredicate(InListPredicate x) {
        if (this.currentIsQuery) {
            this.logError("subQueryInNotAllowed");
            this.currentIsQuery = false;
        }
    }

    public void visitInSubqueryPredicate(InSubqueryPredicate x) {
        if (this.currentIsQuery) {
            if (x.getValue() instanceof QuerySpecification) {
                this.logError("subQueryInNotAllowed");
            }
            this.currentIsQuery = false;
        }
    }

    public void visitLikePredicate(LikePredicate x) {
        if (this.currentIsQuery) {
            this.logError("subQueryLikeNotAllowed");
            this.currentIsQuery = false;
        }
    }

    public void visitNullPredicate(NullPredicate x) {
        if (this.currentIsQuery) {
            this.logError("subQueryIsNullNotAllowed");
            this.currentIsQuery = false;
        }
    }

    public void visitQuantifiedComparisonPredicate(QuantifiedComparisonPredicate x) {
        if (this.currentIsQuery) {
            if (x.getValue() instanceof QuerySpecification) {
                this.logError("subQueryComparisonLeftNotAllowed");
            }
            this.currentIsQuery = false;
        }
    }

    public void visitQuerySpecificationBefore(QuerySpecification x) {
        this.currentIsQuery = false;
    }

    public void visitQuerySpecification(QuerySpecification x) {
        this.currentIsQuery = true;
    }

    public void visitRowValueElementList(RowValueElementList x) {
        if (this.currentIsQuery) {
            this.logError("subQueryRowValueElementListNotAllowed");
            this.currentIsQuery = false;
        }
    }

    public void visitSelectSublist(SelectSublist x) {
        if (this.currentIsQuery) {
            this.logError("subQuerySelectListNotAllowed");
            this.currentIsQuery = false;
        }
    }

    public void visitSetClause(SetClause x) {
        if (this.currentIsQuery) {
            this.logError("subQuerySetClauseNotAllowed");
            this.currentIsQuery = false;
        }
    }

    public void visitSetFunction(SetFunction x) {
    }
}

