/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.cts.tp.net;

import com.sap.bc.cts.tp.log.Trace;
import com.sap.bc.cts.tp.net.Connection;
import com.sap.bc.cts.tp.net.ExtendedServiceIF;
import com.sap.bc.cts.tp.net.Manager;
import com.sap.bc.cts.tp.net.Service;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;

final class Worker
implements Runnable {
    private static final Trace trace = Trace.getTrace(class$com$sap$bc$cts$tp$net$Worker == null ? (class$com$sap$bc$cts$tp$net$Worker = Worker.class$("com.sap.bc.cts.tp.net.Worker")) : class$com$sap$bc$cts$tp$net$Worker);
    private Manager manager = null;
    private int number = 0;
    private boolean work = true;
    static /* synthetic */ Class class$com$sap$bc$cts$tp$net$Worker;

    Worker(Manager _manager, int _number) {
        this.manager = _manager;
        this.number = _number;
    }

    public void run() {
        Connection connection = null;
        Service s = null;
        Socket c = null;
        while (this.work) {
            connection = this.manager.getNextConnection();
            if (null != connection) {
                if (connection.startUsing()) {
                    c = connection.getClient();
                    s = connection.getService();
                    try {
                        if (connection.getNetComm() != null && s instanceof ExtendedServiceIF) {
                            ((ExtendedServiceIF)s).serve(connection.getNetComm());
                            trace.debug("Worker #" + this.number + " worked on connection #" + s.getNumber());
                        } else {
                            InputStream in = c.getInputStream();
                            OutputStream out = c.getOutputStream();
                            if (null != in && null != out) {
                                s.serve(in, out);
                                trace.debug("Worker #" + this.number + " worked on connection #" + s.getNumber());
                            }
                        }
                        connection.finishedUsing();
                    }
                    catch (InterruptedIOException iioe) {
                        trace.debug("Worker #" + this.number + " connection #" + s.getNumber() + " kept silent");
                        connection.finishedUsing();
                    }
                    catch (IOException ioe) {
                        trace.debug("Worker #" + this.number + " connection #" + s.getNumber() + " is broken." + ioe.getMessage());
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        String backTrace = null;
                        if (null != stringWriter) {
                            ioe.printStackTrace(printWriter);
                            printWriter.close();
                            backTrace = stringWriter.toString();
                        }
                        trace.debug("StackTrace: " + backTrace);
                        connection.setClosing();
                        connection.finishedUsing();
                        this.manager.endConnection();
                        try {
                            Thread.sleep(this.manager.getWorkerTimeout());
                        }
                        catch (InterruptedException ie) {}
                    }
                    continue;
                }
                trace.debug("Worker #" + this.number + " got connection #" + connection.getService().getNumber() + " thas it in use already");
                try {
                    Thread.sleep(this.manager.getWorkerTimeout());
                }
                catch (InterruptedException ie) {}
                continue;
            }
            trace.debug("Worker #" + this.number + " got no (null) connection from manager");
            try {
                Thread.sleep(this.manager.getWorkerTimeout());
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    void pleaseStop() {
        trace.debug("Worker #" + this.number + " was asked to stop.");
        this.work = false;
    }

    public String toString() {
        return new String("number " + this.number);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

