/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.cts.tp.net;

import com.sap.bc.cts.tp.log.Trace;
import com.sap.bc.cts.tp.net.SocketTimeoutViewException;
import com.sap.bc.cts.tp.net.SocketTimeoutViewIF;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

public class NetComm {
    private static final Trace trace = Trace.getTrace(class$com$sap$bc$cts$tp$net$NetComm == null ? (class$com$sap$bc$cts$tp$net$NetComm = NetComm.class$("com.sap.bc.cts.tp.net.NetComm")) : class$com$sap$bc$cts$tp$net$NetComm);
    public static String eocs = "$&^#";
    static final String EOL = System.getProperty("line.separator");
    private OutputStreamWriter writer;
    private InputStreamReader reader;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SocketTimeoutViewIF socketTimeoutView = null;
    private char[] writeHdr = new char[12];
    private char[] readHdr = new char[12];
    private char[] sendBuf = new char[0];
    private boolean bufferedSend = false;
    private StringBuffer collectorStringBuffer = null;
    private StringTokenizer receivedTokens = null;
    private int originalSocketTimeout = -1;
    private boolean blocking = false;
    static /* synthetic */ Class class$com$sap$bc$cts$tp$net$NetComm;

    public NetComm(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        InputStreamReader inR = new InputStreamReader(inputStream);
        this.writer = new OutputStreamWriter(outputStream);
        this.reader = new InputStreamReader(inputStream);
    }

    public NetComm(InputStream inputStream, OutputStream outputStream, SocketTimeoutViewIF socketTimeoutView) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.writer = new OutputStreamWriter(outputStream);
        this.reader = new InputStreamReader(inputStream);
        this.socketTimeoutView = socketTimeoutView;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public NetComm(InputStream inputStream, OutputStream outputStream, boolean _bufferedSend) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.writer = new OutputStreamWriter(outputStream);
        this.reader = new InputStreamReader(inputStream);
        this.bufferedSend = _bufferedSend;
    }

    public void setbufferedSend(boolean _bufferedSend) {
        this.bufferedSend = _bufferedSend;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public String receive() throws IOException {
        String string;
        trace.entering("receive()");
        try {
            String returnString = null;
            if (null != this.receivedTokens) {
                if (this.receivedTokens.hasMoreTokens()) {
                    returnString = this.receivedTokens.nextToken();
                    trace.debug("NetComm.receive() from it's buffer returns ['" + returnString + "'].");
                    String string2 = returnString;
                    Object var9_5 = null;
                    trace.exiting("receive()");
                    return string2;
                }
                this.receivedTokens = null;
            }
            int receivedHeaderBytes = -1;
            try {
                receivedHeaderBytes = this.receiveHdr(this.readHdr);
            }
            catch (IOException ioe) {
                trace.debug("Caught IOException during read of header bytes (" + receivedHeaderBytes + "," + new String(this.readHdr) + "):" + ioe.getMessage());
                if (ioe instanceof InterruptedIOException) {
                    trace.debug("  throwing InterruptedIOException(net.id_000001)");
                    throw new InterruptedIOException(ioe.getMessage());
                }
                trace.debug("  throwing IOException(net.id_000001)");
                throw new IOException("net.id_000001: Caught IOException during read of header bytes (" + receivedHeaderBytes + "," + new String(this.readHdr) + "):" + ioe.getMessage());
            }
            if (receivedHeaderBytes < 0) {
                trace.debug("EOF while reading length");
                throw new IOException("EOF while reading length");
            }
            if (receivedHeaderBytes < this.readHdr.length) {
                trace.debug("Did not receive complete set of header bytes (" + receivedHeaderBytes + "," + new String(this.readHdr) + ")" + EOL + "  throwing IOException(net.id_000002)");
                throw new IOException("net.id_000002: Did not receive complete set of header bytes (" + receivedHeaderBytes + "," + new String(this.readHdr) + ")");
            }
            String str = new String(this.readHdr).trim();
            trace.debug("received length String: '" + str + "'.");
            int msglen = 0;
            try {
                msglen = Integer.parseInt(str);
                trace.debug("length String translates to the following number: '" + msglen + "'.");
            }
            catch (NumberFormatException nfe) {
                trace.debug("the length string does not translate to a number" + EOL + "  throwing IOException(net.id_000003)");
                throw new IOException("net.id_000003: Length information in Header (" + str + ") does not translate to a number");
            }
            char[] msg = new char[msglen];
            int receivedMessageBytes = 0;
            try {
                receivedMessageBytes = this.receiveMsg(msg);
            }
            catch (IOException ioe) {
                trace.debug("Caught IOException during read of message bytes (" + receivedMessageBytes + "," + new String(msg) + "):" + ioe.getMessage());
                if (ioe instanceof InterruptedIOException) {
                    trace.debug("  throwing InterruptedIOException(net.id_000005)");
                    throw new InterruptedIOException(ioe.getMessage());
                }
                trace.debug("  throwing IOException(net.id_000005)");
                throw new IOException("net.id_000005: Caught IOException during read of message bytes (" + receivedMessageBytes + "," + new String(msg) + "):" + ioe.getMessage());
            }
            if (receivedMessageBytes < 0) {
                trace.debug("EOF while reading message (" + new String(msg).trim() + ")" + EOL + " throwing IOException(net.id_000004)");
                throw new IOException("net.id_000004: EOF while reading message(" + new String(msg).trim() + ")");
            }
            if (receivedMessageBytes < msglen) {
                trace.debug("Did not receive complete set of message bytes (" + receivedMessageBytes + "," + new String(msg).trim() + ")" + EOL + "  throwing IOException(net.id_000006)");
                throw new IOException("net.id_000006: Did not receive complete set of message bytes (" + receivedMessageBytes + "," + new String(msg).trim() + ")");
            }
            returnString = new String(msg);
            this.receivedTokens = new StringTokenizer(returnString, "\n", false);
            int tokenCount = this.receivedTokens.countTokens();
            if (tokenCount <= 1) {
                this.receivedTokens = null;
            } else if (this.receivedTokens.hasMoreTokens()) {
                returnString = this.receivedTokens.nextToken();
                if (!this.receivedTokens.hasMoreTokens()) {
                    this.receivedTokens = null;
                }
            } else {
                this.receivedTokens = null;
            }
            trace.debug("NetComm.receive() is returning ['" + returnString + "'].");
            string = returnString;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            trace.exiting("receive()");
            throw throwable;
        }
        Object var9_6 = null;
        trace.exiting("receive()");
        return string;
    }

    public synchronized void send(String str) {
        trace.entering("send(" + str + ").");
        if (this.bufferedSend) {
            if (null == this.collectorStringBuffer) {
                this.collectorStringBuffer = new StringBuffer(str);
            } else {
                this.collectorStringBuffer.append('\n');
                this.collectorStringBuffer.append(str);
            }
        }
        if (str.equals(eocs) || !this.bufferedSend) {
            String collectedString = null;
            collectedString = this.bufferedSend ? this.collectorStringBuffer.toString() : str;
            this.collectorStringBuffer = null;
            int strLen = collectedString.length();
            this.sendBuf = new char[strLen];
            collectedString.getChars(0, strLen, this.sendBuf, 0);
            this.send(this.sendBuf, 0, strLen);
        }
        trace.exiting("send(...)");
    }

    public void setHeaderLen(int headerLen) {
        this.readHdr = new char[headerLen];
        this.writeHdr = new char[headerLen];
    }

    public int getHeaderLen() {
        return this.readHdr.length;
    }

    private void fillWriteHdr(int length) {
        String s = String.valueOf(length);
        int n = s.length();
        int m = this.writeHdr.length - n;
        int i = 0;
        while (i < m) {
            this.writeHdr[i] = 32;
            ++i;
        }
        i = 0;
        while (i < n) {
            this.writeHdr[m++] = s.charAt(i);
            ++i;
        }
    }

    private int receiveHdr(char[] msg) throws IOException {
        return this.receive(msg, true, msg.length);
    }

    private int receiveMsg(char[] msg) throws IOException {
        return this.receive(msg, false, msg.length);
    }

    private int receiveMsg(char[] msg, int msglen) throws IOException {
        return this.receive(msg, false, msglen);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int receive(char[] msg, boolean isHeader, int msglen) throws IOException {
        int n;
        boolean firstByteReceived = !isHeader;
        this.initSoTimeout();
        if (firstByteReceived) {
            this.setSoTimeoutBlocking();
        }
        int offset = 0;
        int read = -1;
        int remaining = msglen;
        try {
            while (remaining > 0) {
                try {
                    read = 0;
                    read = this.reader.read(msg, offset, remaining);
                }
                catch (InterruptedIOException iioe) {
                    if (!firstByteReceived) {
                        trace.debug("Caught InterruptedIOException before the first Byte was read. Throwing InterruptedIOException(net.id_000100: " + iioe.getMessage() + ").");
                        throw new InterruptedIOException("net.id_000100: " + iioe.getMessage());
                    }
                    trace.debug("Caught InterruptedIOException after the first Byte was read. That is OK. Start reading again.");
                }
                if (read < 0) {
                    int iioe = -1;
                    Object var10_13 = null;
                    this.resetSoTimeout();
                    if (remaining <= 0) return iioe;
                    trace.debug("Method \"receive(char[])\" could not read all requested bytes. There are still " + remaining + " bytes to read");
                    return iioe;
                }
                firstByteReceived = true;
                this.setSoTimeoutBlocking();
                offset += read;
                remaining -= read;
            }
            if (this.reader.markSupported()) {
                try {
                    this.reader.mark(65536);
                    this.reader.reset();
                }
                catch (IOException ioeReader) {
                    trace.debug("Caught IOException during mark/reset operation (" + ioeReader.getMessage() + ")");
                }
            } else {
                trace.debug("Reader does not support marks.");
            }
            n = msglen - remaining;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.resetSoTimeout();
            if (remaining <= 0) throw throwable;
            trace.debug("Method \"receive(char[])\" could not read all requested bytes. There are still " + remaining + " bytes to read");
            throw throwable;
        }
        Object var10_14 = null;
        this.resetSoTimeout();
        if (remaining <= 0) return n;
        trace.debug("Method \"receive(char[])\" could not read all requested bytes. There are still " + remaining + " bytes to read");
        return n;
    }

    private void initSoTimeout() {
        this.blocking = false;
        if (null != this.socketTimeoutView) {
            try {
                this.originalSocketTimeout = this.socketTimeoutView.getSoTimeout();
            }
            catch (SocketTimeoutViewException e) {
                trace.debug("SocketTimeoutViewException occured during getSoTimeout(): " + e.getMessage());
                this.originalSocketTimeout = -1;
            }
        }
    }

    private void setSoTimeoutBlocking() {
        if (!this.blocking && -1 != this.originalSocketTimeout && null != this.socketTimeoutView) {
            try {
                this.socketTimeoutView.setSoTimeout(0);
            }
            catch (SocketTimeoutViewException e) {
                trace.debug("SocketTimeoutViewException occured during setSoTimeout(0): " + e.getMessage());
            }
        }
        this.blocking = true;
    }

    private void resetSoTimeout() {
        if (this.blocking && -1 != this.originalSocketTimeout && null != this.socketTimeoutView) {
            try {
                this.socketTimeoutView.setSoTimeout(this.originalSocketTimeout);
            }
            catch (SocketTimeoutViewException e) {
                trace.debug("SocketTimeoutViewException occured during setSoTimeout(" + this.originalSocketTimeout + "): " + e.getMessage());
            }
        }
        this.blocking = false;
    }

    private synchronized void send(char[] msg) {
        this.send(msg, 0, msg.length);
    }

    private synchronized void send(char[] msg, int off, int len) {
        try {
            this.fillWriteHdr(len);
            this.writer.write(this.writeHdr, 0, this.writeHdr.length);
            this.writer.write(msg, off, len);
            this.writer.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

