/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.cts.tp.net;

import com.sap.bc.cts.tp.log.Logger;
import com.sap.bc.cts.tp.log.Trace;
import com.sap.bc.cts.tp.net.Admin;
import com.sap.bc.cts.tp.net.Connection;
import com.sap.bc.cts.tp.net.ExtendedServiceIF;
import com.sap.bc.cts.tp.net.ManagerInfo;
import com.sap.bc.cts.tp.net.NetComm;
import com.sap.bc.cts.tp.net.Servant;
import com.sap.bc.cts.tp.net.Service;
import com.sap.bc.cts.tp.net.SocketTimeoutView;
import com.sap.bc.cts.tp.net.Timestamp;
import com.sap.bc.cts.tp.net.Worker;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class Manager
implements Runnable {
    private static final Logger log = Logger.getLogger();
    private static final Trace trace = Trace.getTrace(class$com$sap$bc$cts$tp$net$Manager == null ? (class$com$sap$bc$cts$tp$net$Manager = Manager.class$("com.sap.bc.cts.tp.net.Manager")) : class$com$sap$bc$cts$tp$net$Manager);
    private Admin admin = null;
    private int admin_port = 0;
    private Thread admin_engine = null;
    private final String admin_port_s = new String("AdminPort");
    private boolean stillRunning = true;
    private boolean listen = true;
    private int maxConnections = 10;
    private int maxServants = 10;
    private final String maxConnections_s = new String("MaxConnections");
    private final String maxServants_s = new String("MaxServants");
    private ManagerInfo managerInfo = null;
    private ThreadGroup group = null;
    private Thread engine = null;
    private Vector connections = null;
    private Vector servants = null;
    private int currentConnection = 0;
    private int currentServant = 0;
    private int worker = 0;
    private int connection = 0;
    private int numberOfServants = 0;
    private final String workerTimeout_s = new String("workerTimeout");
    private int workerTimeout = 1000;
    private int listenerTimeout = 30000;
    static /* synthetic */ Class class$com$sap$bc$cts$tp$net$Manager;

    public Manager(ThreadGroup _group, int _maxConnections, int _maxServants, int _admin_port, ManagerInfo _managerInfo) {
        this.maxConnections = _maxConnections;
        this.connections = new Vector(this.maxConnections, this.maxConnections);
        this.maxServants = _maxServants;
        this.servants = new Vector(this.maxServants);
        this.group = _group;
        this.managerInfo = _managerInfo;
        this.admin_port = _admin_port;
        this.startAdmin();
        this.engine = new Thread(this.group, this, "Manager");
        this.engine.setDaemon(true);
        this.engine.start();
    }

    public void run() {
        this.tellProperty(this.maxConnections_s, new String("" + this.maxConnections));
        this.tellProperty(this.maxServants_s, new String("" + this.maxServants));
        this.tellProperty(this.workerTimeout_s, new String("" + this.workerTimeout));
        while (this.stillRunning) {
            this.check();
            this.printServants();
            this.printConnections();
            try {
                Manager manager = this;
                synchronized (manager) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.stopConnections();
        this.stopServants();
        this.admin.stopRunning();
        System.exit(-1);
    }

    public void stopRunning() {
        this.stillRunning = false;
        this.group.interrupt();
    }

    public boolean getStillRunning() {
        return this.stillRunning;
    }

    private void startAdmin() {
        trace.debug("Starting Admin Server listening on port " + this.admin_port);
        ThreadGroup tg = new ThreadGroup("Admin");
        this.admin = new Admin(this, this.admin_port);
        this.admin_engine = new Thread(tg, this.admin, "Admin");
        this.admin_engine.setDaemon(true);
        this.admin_engine.start();
        Thread.yield();
    }

    private Servant startServant() {
        ++this.worker;
        Worker wr = new Worker(this, this.worker);
        Thread tn = new Thread(this.group, wr, "Worker #" + this.worker);
        tn.start();
        return new Servant(tn, wr);
    }

    public synchronized void check() {
        int i = this.connections.size() - 1;
        while (i >= 0) {
            Connection c = (Connection)this.connections.elementAt(i);
            if (null != c) {
                Socket s = c.getClient();
                if (null == s || c.isClosed()) {
                    this.removeConnection(c);
                } else {
                    this.tellNewConnection(c);
                }
            }
            --i;
        }
        int i2 = 0;
        while (i2 < this.servants.size()) {
            Servant sv = (Servant)this.servants.elementAt(i2);
            Thread t = sv.getThread();
            if (!t.isAlive()) {
                Servant nsv = this.startServant();
                this.servants.setElementAt(nsv, i2);
                this.tellDelServant(sv);
                this.tellNewServant(nsv);
            } else {
                this.tellNewServant(sv);
            }
            ++i2;
        }
        if (!this.admin_engine.isAlive()) {
            this.startAdmin();
        }
        if (null != this.managerInfo) {
            this.managerInfo.check();
        }
    }

    synchronized void addConnection(Socket _socket, Service _service) {
        if (null == _socket) {
            trace.debug("Connection was nor created because socket was 'null' ");
        } else {
            try {
                String hostName;
                InetAddress inetAddress = _socket.getInetAddress();
                int remotePort = _socket.getPort();
                try {
                    hostName = _socket.getInetAddress().getHostName();
                }
                catch (SecurityException e) {
                    trace.debug("Unable to lookup host name for address " + inetAddress, e);
                    hostName = "<unable to lookup due to security restrictions>";
                }
                log.info("Opened client connection to " + hostName + " (IP address " + inetAddress + ", remote port " + remotePort + ")");
                Connection l_conn = null;
                if (_service instanceof ExtendedServiceIF) {
                    SocketTimeoutView socketTimeoutView = SocketTimeoutView.createSocketTimeoutView(_socket);
                    NetComm nc = new NetComm(_socket.getInputStream(), _socket.getOutputStream(), socketTimeoutView);
                    l_conn = new Connection(_socket, _service, nc);
                } else {
                    l_conn = new Connection(_socket, _service);
                }
                ++this.connection;
                _service.setNumber(this.connection);
                trace.debug("Connection #" + this.connection + " created and added to administrative structures");
                this.connections.addElement(l_conn);
                this.tellNewConnection(l_conn);
                if (this.numberOfServants < this.maxServants) {
                    Servant sv = this.startServant();
                    ++this.numberOfServants;
                    this.servants.addElement(sv);
                    this.tellNewServant(sv);
                }
            }
            catch (IOException ioEx) {
                trace.debug("Connection was nor created because IO-Error occurred", ioEx);
            }
        }
        this.notify();
    }

    synchronized void removeConnection(Connection _connection) {
        trace.debug("Removing Connection " + _connection.toString());
        _connection.startUsing();
        Socket s = _connection.getClient();
        Service service = _connection.getService();
        service.endIt(null, null);
        this.tellDelConnection(_connection);
        this.connections.removeElement(_connection);
        trace.debug("Connection " + _connection.toString() + " removed.");
        try {
            s.getInputStream().close();
            s.getOutputStream().close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            log.info("Close client connection to " + s.getInetAddress() + ", remote port " + s.getPort());
            s.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public synchronized void endConnection() {
        this.notify();
    }

    public synchronized Connection getConnection(int num) {
        if (0 <= num && num < this.connections.size()) {
            return (Connection)this.connections.elementAt(num);
        }
        return null;
    }

    public synchronized Connection getNextConnection() {
        Connection rc = null;
        if (0 == this.connections.size()) {
            rc = null;
            this.currentConnection = 0;
            return rc;
        }
        if (this.currentConnection >= this.connections.size()) {
            this.currentConnection = 0;
        }
        rc = (Connection)this.connections.elementAt(this.currentConnection);
        ++this.currentConnection;
        return rc;
    }

    public synchronized void printConnections() {
        Connection t_conn = null;
        Socket c = null;
        Service s = null;
        int i = 0;
        while (i < this.connections.size()) {
            t_conn = (Connection)this.connections.elementAt(i);
            c = t_conn.getClient();
            s = t_conn.getService();
            trace.debug(Timestamp.get() + ": " + "Connection #" + i + "  Client: " + c.toString());
            trace.debug(Timestamp.get() + ": " + "Connection #" + i + " Service: " + s.toString());
            ++i;
        }
    }

    public synchronized void printServants() {
        Thread tn = null;
        Worker wr = null;
        Servant sv = null;
        int i = 0;
        while (i < this.servants.size()) {
            sv = (Servant)this.servants.elementAt(i);
            tn = sv.getThread();
            wr = sv.getWorker();
            trace.debug(Timestamp.get() + ": " + "Thread #" + i + ":" + tn.toString());
            trace.debug(Timestamp.get() + ": " + "Worker #" + i + ":" + wr.toString());
            ++i;
        }
    }

    private void tellNewConnection(Connection _connection) {
        String res = null;
        if (null != this.managerInfo) {
            trace.debug("tellNewConnection: " + _connection.toString());
            res = this.managerInfo.setConnection(_connection.getClient().getInetAddress().getHostName(), Integer.toString(_connection.getClient().getPort()), Integer.toString(_connection.getClient().getLocalPort()), Integer.toString(_connection.getService().getNumber()) + " " + _connection.getService().toString());
            trace.debug("tellNewConnection: " + res);
        } else {
            trace.debug("tellNewConnectio: null == this.managerInfo");
        }
    }

    private void tellDelConnection(Connection _connection) {
        if (null != this.managerInfo) {
            trace.debug("tellDelConnection: " + _connection.toString());
            trace.debug("tellDelConnection: " + this.managerInfo.delConnection(_connection.getClient().getInetAddress().getHostName(), Integer.toString(_connection.getClient().getPort())));
        } else {
            trace.debug("tellDelConnection: null == this.managerInfo");
        }
    }

    private void tellNewServant(Servant _servant) {
        if (null != this.managerInfo) {
            int number = this.servants.indexOf(_servant);
            trace.debug("tellNewServant: " + number + " " + _servant.toString());
            trace.debug("tellNewServant: " + this.managerInfo.setServant(_servant.toString()));
        } else {
            trace.debug("tellNewServant: null == this.managerInfo");
        }
    }

    private void tellDelServant(Servant _servant) {
        if (null != this.managerInfo) {
            trace.debug("tellDelServant: " + _servant.toString());
            trace.debug("tellDelServant: " + this.managerInfo.delServant(_servant.toString()));
        } else {
            trace.debug("tellDelServant: null == this.managerInfo");
        }
    }

    private void tellProperty(String _name, String _value) {
        if (null != this.managerInfo) {
            String value = null;
            value = null == _value ? "null" : _value;
            trace.debug("tellProperty: " + _name + " " + value);
            trace.debug("tellProperty: " + this.managerInfo.setProperty(_name, value));
        } else {
            trace.debug("tellProperty: null == this.managerInfo");
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxServants() {
        return this.maxServants;
    }

    public synchronized Servant getNextServant() {
        if (0 == this.servants.size()) {
            return null;
        }
        ++this.currentServant;
        if (this.currentServant >= this.servants.size()) {
            this.currentServant = 0;
        }
        return (Servant)this.servants.elementAt(this.currentServant);
    }

    public int getNumberOfServants() {
        return this.servants.size();
    }

    public int getNumberOfConnections() {
        return this.connections.size();
    }

    public int getListenerTimeout() {
        return this.listenerTimeout;
    }

    public int getWorkerTimeout() {
        return this.workerTimeout;
    }

    public void setMaxConnections(int _maxConnections) {
        this.maxConnections = _maxConnections;
        this.tellProperty(this.maxConnections_s, new String("" + this.maxConnections));
    }

    public void setMaxServants(int _maxServants) {
        Servant sv = null;
        while (_maxServants < this.numberOfServants) {
            sv = this.getNextServant();
            if (null == sv) break;
            sv.stop();
            this.tellDelServant(sv);
            this.servants.removeElement(sv);
            --this.numberOfServants;
        }
        this.maxServants = _maxServants;
        this.tellProperty(this.maxServants_s, new String("" + this.maxServants));
    }

    public void setWorkerTimeout(int _workerTimeout) {
        this.workerTimeout = _workerTimeout;
        this.tellProperty(this.workerTimeout_s, new String("" + this.workerTimeout));
    }

    public synchronized boolean tooManyConnections() {
        return this.connections.size() > this.maxConnections;
    }

    public void stopServants() {
        Servant sv = null;
        int i = this.servants.size() - 1;
        while (i >= 0) {
            sv = (Servant)this.servants.elementAt(i);
            sv.stop();
            this.servants.removeElement(sv);
            --i;
        }
    }

    public synchronized void stopConnections() {
        Connection con = null;
        long startTime = System.currentTimeMillis();
        long runTime = 0L;
        while (this.connections.size() > 0 && runTime < 25000L) {
            int i = this.connections.size() - 1;
            while (i >= 0) {
                con = (Connection)this.connections.elementAt(i);
                if (null != con && con.startUsing()) {
                    this.removeConnection(con);
                }
                --i;
            }
            runTime = System.currentTimeMillis() - startTime;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

