/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.cts.tp.net;

import com.sap.bc.cts.tp.log.Trace;
import com.sap.bc.cts.tp.net.Manager;
import com.sap.bc.cts.tp.net.ServerSocketFactory;
import com.sap.bc.cts.tp.net.ServiceFactory;
import com.sap.bc.cts.tp.net.SocketTimeoutView;
import com.sap.bc.cts.tp.net.TimeoutControlledServiceFactory;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Listener
implements Runnable {
    private static final Trace trace = Trace.getTrace(class$com$sap$bc$cts$tp$net$Listener == null ? (class$com$sap$bc$cts$tp$net$Listener = Listener.class$("com.sap.bc.cts.tp.net.Listener")) : class$com$sap$bc$cts$tp$net$Listener);
    private final ServerSocketFactory seSoFactory;
    private final Manager manager;
    private final int port;
    private final ServiceFactory serviceFactory;
    private ServerSocket listenSocket = null;
    static /* synthetic */ Class class$com$sap$bc$cts$tp$net$Listener;

    public Listener(Manager manager, int port, ServiceFactory serviceFactory, ServerSocketFactory seSoFactory) {
        this.seSoFactory = seSoFactory;
        this.manager = manager;
        this.port = port;
        this.serviceFactory = serviceFactory;
        try {
            this.listenSocket = this.createServerSocket(this.port);
            this.listenSocket.setSoTimeout(manager.getListenerTimeout());
        }
        catch (IOException ioe) {
            trace.debug("Could not create ServerSocket", ioe);
        }
    }

    public Listener(Manager manager, int port, ServiceFactory serviceFactory) {
        this(manager, port, serviceFactory, null);
    }

    private ServerSocket createServerSocket(int port) throws IOException {
        if (this.seSoFactory != null) {
            return this.seSoFactory.create(port);
        }
        return new ServerSocket(port);
    }

    public ServerSocket getServerSocket() {
        return this.listenSocket;
    }

    public void run() {
        while (this.manager.getStillRunning()) {
            try {
                Socket client = this.listenSocket.accept();
                client.setSoTimeout(this.manager.getWorkerTimeout());
                if (this.serviceFactory instanceof TimeoutControlledServiceFactory) {
                    SocketTimeoutView socketTimeoutView = SocketTimeoutView.createSocketTimeoutView(client);
                    this.manager.addConnection(client, ((TimeoutControlledServiceFactory)this.serviceFactory).makeService(this.manager, socketTimeoutView));
                    continue;
                }
                this.manager.addConnection(client, this.serviceFactory.makeService(this.manager));
            }
            catch (InterruptedIOException iioe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        try {
            this.listenSocket.close();
        }
        catch (InterruptedIOException iioe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.listenSocket = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

