/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.cts.tp.net;

import com.sap.bc.cts.tp.log.Logger;
import com.sap.bc.cts.tp.log.Trace;
import com.sap.bc.cts.tp.net.Connection;
import com.sap.bc.cts.tp.net.ExtendedServiceIF;
import com.sap.bc.cts.tp.net.Manager;
import com.sap.bc.cts.tp.net.NetComm;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

final class AdminLogik
implements ExtendedServiceIF {
    private static final Logger log = Logger.getLogger();
    private static final Trace trace = Trace.getTrace(class$com$sap$bc$cts$tp$net$AdminLogik == null ? (class$com$sap$bc$cts$tp$net$AdminLogik = AdminLogik.class$("com.sap.bc.cts.tp.net.AdminLogik")) : class$com$sap$bc$cts$tp$net$AdminLogik);
    private Manager manager = null;
    private int number = 0;
    private static final String[] requests = new String[]{"get number of connections", "#connections", "get maximal number of connections", "get number of servants", "#servants", "get maximal number of servants", "connections++", "connections--", "servants++", "servants--", "managerlog", "connectionlog", "servantlog", "workerTimeout", "check", "connections", "delcon", "shutdown", null};
    private Vector v = null;
    static /* synthetic */ Class class$com$sap$bc$cts$tp$net$AdminLogik;

    public AdminLogik(Manager _manager) {
        this.manager = _manager;
    }

    public void serve(InputStream in, OutputStream out) throws InterruptedIOException, IOException {
        NetComm nc = new NetComm(in, out);
        this.serve(nc);
    }

    public void serve(NetComm nc) throws InterruptedIOException, IOException {
        String from_s = null;
        String to_s = null;
        from_s = nc.receive();
        trace.debug("Request from admin client: " + from_s);
        try {
            to_s = this.process(from_s);
            if (null != to_s) {
                nc.send(to_s);
            }
            nc.send(NetComm.eocs);
        }
        catch (Exception e) {
            log.fatal("Unexpected Error in AdminLogik", e);
            log.fatal("Exiting.");
            System.exit(12);
        }
    }

    public void endIt(InputStream _in, OutputStream _out) {
        try {
            if (null != _in) {
                _in.close();
            }
            if (null != _out) {
                _out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return new String("AdminLogik");
    }

    public void setNumber(int _number) {
        this.number = _number;
    }

    public int getNumber() {
        return this.number;
    }

    public void setLogging(PrintWriter _out) {
    }

    private String process(String _input) {
        Manager m = this.manager;
        String rs = null;
        if (_input.equalsIgnoreCase(requests[0]) || _input.equalsIgnoreCase(requests[1])) {
            rs = new String("Current number of connections is: " + m.getNumberOfConnections());
        } else if (_input.equalsIgnoreCase(requests[2])) {
            rs = new String("Maximal allowed number of connections is: " + m.getMaxConnections());
        } else if (_input.equalsIgnoreCase(requests[3]) || _input.equalsIgnoreCase(requests[4])) {
            rs = new String("Current number of servants is: " + m.getNumberOfServants());
        } else if (_input.equalsIgnoreCase(requests[5])) {
            rs = new String("Maximal allowed number of servants is: " + m.getMaxServants());
        } else if (_input.equalsIgnoreCase(requests[6])) {
            int con_i = m.getMaxConnections();
            m.setMaxConnections(++con_i);
            rs = new String("Maximal number of Connections increased to " + con_i);
        } else if (_input.equalsIgnoreCase(requests[7])) {
            int con_i = m.getMaxConnections();
            if (1 == con_i) {
                rs = new String("Cannot decrease maximal number of Connections below 1");
            } else {
                m.setMaxConnections(--con_i);
                rs = new String("Maximal number of Connections decreased to " + con_i);
            }
        } else if (_input.equalsIgnoreCase(requests[8])) {
            int sv_i = m.getMaxServants();
            m.setMaxServants(++sv_i);
            rs = new String("Maximal number of Servants increased to " + sv_i);
        } else if (_input.equalsIgnoreCase(requests[9])) {
            int sv_i = m.getMaxServants();
            if (1 == sv_i) {
                rs = new String("Cannot decrease maximal number of Servants below 1");
            } else {
                m.setMaxServants(--sv_i);
                rs = new String("Maximal number of Servants decreased to " + sv_i);
            }
        } else if (_input.startsWith(requests[10])) {
            rs = requests[10] + " not supported anymore";
            log.warning(rs);
        } else if (_input.startsWith(requests[11])) {
            rs = requests[11] + " not supported anymore";
            log.warning(rs);
        } else if (_input.startsWith(requests[12])) {
            rs = requests[12] + " not supported anymore";
            log.warning(rs);
        } else if (_input.startsWith(requests[13])) {
            StringTokenizer strtok = new StringTokenizer(_input, " ", false);
            String timeout = strtok.nextToken();
            timeout = strtok.nextToken();
            boolean isint = true;
            int timeout_i = 1000;
            try {
                timeout_i = Integer.parseInt(timeout);
            }
            catch (NumberFormatException nfe) {
                isint = false;
                rs = new String("Error: " + requests[13] + " has to be followed by a number");
            }
            if (isint) {
                m.setWorkerTimeout(timeout_i);
                rs = new String("Set Workertimeout to " + timeout_i);
            }
        } else if (_input.equalsIgnoreCase(requests[14])) {
            m.check();
            rs = new String("Notified Manager to check his administrative structures.");
        } else if (_input.equalsIgnoreCase(requests[15])) {
            int num_c = m.getNumberOfConnections();
            StringBuffer sb = new StringBuffer();
            this.v = new Vector(num_c);
            Connection c = null;
            int i = 0;
            while (i < num_c) {
                c = m.getConnection(i);
                if (null == c) break;
                this.v.addElement(c);
                sb.append(i + ": " + c.toString() + "\n");
                ++i;
            }
            rs = sb.toString();
        } else if (_input.startsWith(requests[16])) {
            StringTokenizer strtok = new StringTokenizer(_input, " ", false);
            String num = strtok.nextToken();
            num = strtok.nextToken();
            boolean isint = true;
            int num_i = -1;
            try {
                num_i = Integer.parseInt(num);
            }
            catch (NumberFormatException nfe) {
                isint = false;
                rs = new String("Error: " + requests[16] + " has to be followed by a number");
            }
            if (isint) {
                if (null != this.v) {
                    if (0 <= num_i && num_i < this.v.size()) {
                        Connection c = (Connection)this.v.elementAt(num_i);
                        c.setClosing();
                        m.check();
                        rs = new String("Set connection \"" + c.toString() + "\" to closing");
                    } else {
                        rs = new String("Connection number '" + num_i + "' is not defined.\n" + "It might help to refresh the information storage by using \"" + requests[15] + "\" again.");
                    }
                } else {
                    rs = new String("Error: no connections stored. Use \"" + requests[15] + "\" first.");
                }
            }
        } else if (_input.startsWith(requests[17])) {
            rs = new String("Shutting down Semaphore Server");
            this.manager.stopRunning();
        } else {
            StringBuffer sb = new StringBuffer("Sorry I do not understand!\n Please choose one of the following:");
            int rii = 0;
            while (null != requests[rii]) {
                sb.append("\n" + requests[rii]);
                ++rii;
            }
            rs = sb.toString();
        }
        return rs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

