/*
 * Decompiled with CFR 0.152.
 */
package com.sap.bc.cts.tp.log;

import com.sap.bc.cts.tp.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;

final class StdLogger
extends Logger {
    StdLogger() {
    }

    public void info(String message) {
        System.out.println(message);
    }

    public void warning(String message) {
        System.err.println(message);
    }

    public void warning(String message, Throwable throwable) {
        this.warning(message + ": " + throwable);
        this.warning(this.stackTraceToString(throwable));
    }

    public void error(String message) {
        System.err.println(message);
    }

    public void error(String message, Throwable throwable) {
        this.error(message + ": " + throwable);
        this.error(this.stackTraceToString(throwable));
    }

    public void fatal(String message) {
        System.err.println(message);
    }

    public void fatal(String message, Throwable throwable) {
        this.fatal(message + ": " + throwable);
        this.fatal(this.stackTraceToString(throwable));
    }

    private String stackTraceToString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        sw.flush();
        return sw.toString();
    }
}

