/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.util.eclipse;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SapPortalPluginsLogger {
    public static String LOG_NAME = "sap-plugin.log";
    private static final int MAX_SIZE = 1000000;
    private static final String ERROR = "ERROR LEVEL";
    private static final String INFO = "INFO LEVEL";
    private static final String DEBUG = "DEBUG LEVEL";
    private static final String WARNING = "WARNING LEVEL";
    private static SapPortalPluginsLogger mm_instance = null;
    boolean mm_tracemode = false;
    boolean mm_enableLog = false;
    PrintStream mm_output = null;

    private SapPortalPluginsLogger(String filepath, boolean enable, boolean tracemode) throws Exception {
        try {
            this.mm_enableLog = enable;
            this.mm_tracemode = tracemode;
            try {
                File file = new File(filepath);
                if (file.exists() && file.length() > 1000000L) {
                    file.delete();
                }
            }
            catch (RuntimeException e) {
                SapPortalPluginsLogger.logError((Object)this, e);
            }
            this.mm_output = new PrintStream(new FileOutputStream(filepath, true));
        }
        catch (Exception ioe) {
            SapPortalPluginsLogger.logError((Object)this, ioe);
            throw ioe;
        }
    }

    public static void initLogger(String filepath, boolean enable, boolean tracemode) throws Exception {
        mm_instance = new SapPortalPluginsLogger(filepath, enable, tracemode);
    }

    public static void release() {
        if (mm_instance != null) {
            mm_instance._release();
        }
    }

    private void _release() {
        if (this.mm_output != null) {
            this.mm_output.flush();
            this.mm_output.close();
            this.mm_output = null;
            this.mm_tracemode = false;
            this.mm_enableLog = false;
        }
    }

    private static void logException(Object emitter, String level, Throwable e, String message) {
        String date = new SimpleDateFormat("dd.MM.yy '/' HH:mm").format(new Date());
        StringBuffer content = new StringBuffer();
        content.append("[");
        content.append(date);
        content.append("] #");
        content.append(level);
        content.append("# ");
        if (emitter != null) {
            content.append(emitter.getClass().getName());
            content.append(" > ");
        }
        if (message == null) {
            content.append("No Information");
        } else {
            content.append(message);
        }
        if (e != null) {
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(ostr));
            content.append("\r\n");
            content.append(ostr.toString());
        }
        if (mm_instance != null) {
            if (SapPortalPluginsLogger.mm_instance.mm_tracemode) {
                System.err.println(content);
            }
            if (SapPortalPluginsLogger.mm_instance.mm_output != null && SapPortalPluginsLogger.mm_instance.mm_enableLog) {
                SapPortalPluginsLogger.mm_instance.mm_output.println(content);
                SapPortalPluginsLogger.mm_instance.mm_output.checkError();
            }
        }
    }

    public static void logError(Object emitter, Throwable e, String message) {
        SapPortalPluginsLogger.logException(emitter, ERROR, e, message);
    }

    public static void logError(Object emitter, Throwable e) {
        SapPortalPluginsLogger.logException(emitter, ERROR, e, null);
    }

    public static void logError(Object emitter, String message) {
        SapPortalPluginsLogger.logException(emitter, ERROR, null, message);
    }

    public static void logWarning(Object emitter, Throwable e, String message) {
        SapPortalPluginsLogger.logException(emitter, ERROR, e, message);
    }

    public static void logWarning(Object emitter, Throwable e) {
        SapPortalPluginsLogger.logException(emitter, ERROR, e, null);
    }

    public static void logWarning(Object emitter, String message) {
        SapPortalPluginsLogger.logException(emitter, ERROR, null, message);
    }

    public static void logDebug(Object emitter, String message) {
        SapPortalPluginsLogger.logException(emitter, DEBUG, null, message);
    }

    public static void logInfo(Object emitter, String message) {
        SapPortalPluginsLogger.logException(emitter, DEBUG, null, message);
    }

    public static void logInfo(Object emitter, String message, Throwable e) {
        SapPortalPluginsLogger.logException(emitter, DEBUG, e, message);
    }

    public void activeTraceMode(boolean p) {
        this.mm_tracemode = p;
    }

    public boolean isTraceMode() {
        return this.mm_tracemode;
    }

    public static void main(String[] args) {
        try {
            SapPortalPluginsLogger.initLogger("log.txt", true, false);
            SapPortalPluginsLogger.logError((Object)"", "message error");
            SapPortalPluginsLogger.logError(null, new Exception("test"), "message error");
            int i = 0;
            while (i < 20000) {
                SapPortalPluginsLogger.logWarning(null, new Exception("test"), "message error");
                ++i;
            }
            SapPortalPluginsLogger.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isEnableLog() {
        if (mm_instance != null) {
            return SapPortalPluginsLogger.mm_instance.mm_enableLog;
        }
        return false;
    }

    public static boolean isTracemode() {
        if (mm_instance != null) {
            return SapPortalPluginsLogger.mm_instance.mm_tracemode;
        }
        return false;
    }

    public void setEnableLog(boolean enableLog) {
        if (mm_instance != null) {
            SapPortalPluginsLogger.mm_instance.mm_enableLog = enableLog;
        }
    }

    public void setTracemode(boolean tracemode) {
        if (mm_instance != null) {
            SapPortalPluginsLogger.mm_instance.mm_tracemode = tracemode;
        }
    }
}

