/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.ui.widgets;

import com.sap.netweaver.ep.core.preferences.IServerConfig;
import com.sap.netweaver.ep.core.preferences.IServerConfigSelector;
import com.sap.netweaver.ep.core.preferences.Server;
import com.sap.netweaver.ep.core.preferences.ServerConfig;
import com.sap.netweaver.ep.ui.EnterprisePortalPlugin;
import com.sap.netweaver.ep.ui.preferences.PreferencePage;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ServerComponent
implements IServerConfigSelector {
    private static final String SERVERS = "Servers";
    private Composite mm_container;
    private Group mm_group;
    private Table mm_table;
    private static int PASSWD_COL = 2;
    private Button mm_buttonAdvanced;
    private Label mm_serverDetails;
    private TableViewer mm_tviewer;
    private TableContentProvider mm_cp;
    private Vector mm_data;

    public ServerComponent(Composite container) {
        this.mm_container = container;
        this.createTable();
        this.addListeners();
        this.createTablesColumns();
        if (!this.passwordsToRemember()) {
            this.invalidatePasswords();
        }
        this.initializeTable();
        this.initializeTableSelection();
        this.createDetailsField();
        this.createButton();
    }

    private void createTable() {
        this.mm_group = new Group(this.mm_container, 32);
        this.mm_group.setText(SERVERS);
        this.mm_group.setLayout((Layout)new GridLayout());
        this.mm_group.setLayoutData((Object)new GridData(1808));
        int style = 67588;
        this.mm_table = new Table((Composite)this.mm_group, style);
        GridData gd = new GridData(1808);
        gd.heightHint = 120;
        this.mm_table.setLayoutData((Object)gd);
        this.mm_tviewer = new TableViewer(this.mm_table);
        this.mm_cp = new TableContentProvider();
        this.mm_tviewer.setContentProvider((IContentProvider)this.mm_cp);
        this.mm_tviewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
    }

    private void addListeners() {
        final TableEditor editor = new TableEditor(this.mm_table);
        this.mm_table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = ServerComponent.this.mm_table.getClientArea();
                Point pt = new Point(event.x, event.y);
                TableItem[] selectedItems = ServerComponent.this.mm_table.getSelection();
                if (selectedItems == null || selectedItems.length != 1) {
                    return;
                }
                int selectedIndex = ServerComponent.this.mm_table.indexOf(ServerComponent.this.mm_table.getSelection()[0]);
                int index = ServerComponent.this.mm_table.getTopIndex();
                while (index < ServerComponent.this.mm_table.getItemCount()) {
                    boolean visible = false;
                    TableItem item = ServerComponent.this.mm_table.getItem(index);
                    Text text = new Text((Composite)ServerComponent.this.mm_table, 0);
                    text.setEchoChar('*');
                    Rectangle rect = item.getBounds(PASSWD_COL);
                    if (rect.contains(pt)) {
                        Listener textListener = new Listener(this, item, text){
                            private final /* synthetic */ TableItem val$item;
                            private final /* synthetic */ Text val$text;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$item = val$item;
                                this.val$text = val$text;
                            }

                            public void handleEvent(Event e) {
                                switch (e.type) {
                                    case 16: {
                                        Server s = (Server)this.val$item.getData();
                                        String pwd = this.val$text.getText();
                                        if (pwd.trim().equals("")) {
                                            s.setPasswd(null);
                                        } else {
                                            s.setPasswd(pwd);
                                        }
                                        this.val$item.setText(ServerComponent.access$100(), ServerComponent.access$300(1.access$200(this.this$1), this.val$text.getText()));
                                        this.val$text.dispose();
                                        break;
                                    }
                                    default: {
                                        System.out.println("Method handleEvent: case not implemented");
                                    }
                                }
                            }
                        };
                        text.addListener(16, textListener);
                        editor.horizontalAlignment = 16384;
                        editor.grabHorizontal = true;
                        editor.minimumWidth = 50;
                        editor.setEditor((Control)text, item, PASSWD_COL);
                        if (item.getData() != null && item.getData() instanceof Server) {
                            Server s = (Server)item.getData();
                            if (s.getPassword() != null) {
                                text.setText(s.getPassword());
                            } else {
                                text.setText("");
                            }
                        }
                        text.setFocus();
                    } else {
                        Server s = (Server)ServerConfig.getServerList().elementAt(selectedIndex);
                        ServerComponent.this.mm_serverDetails.setText("Host: " + s.getHost() + "  Port: " + s.getPort() + "  Login: " + s.getLogin());
                    }
                    if (!visible && rect.intersects(clientArea)) {
                        visible = true;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }

            static /* synthetic */ ServerComponent access$200(1 x0) {
                return x0.ServerComponent.this;
            }
        });
        this.mm_table.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = ServerComponent.this.mm_table.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = ServerComponent.this.mm_table.getTopIndex();
                while (index < ServerComponent.this.mm_table.getItemCount()) {
                    boolean visible = false;
                    TableItem item = ServerComponent.this.mm_table.getItem(index);
                    int i = 0;
                    while (i < 3) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            if (i == 1) {
                                Server s = (Server)ServerConfig.getServerList().elementAt(index);
                                ServerComponent.this.mm_table.setToolTipText("Alias:" + s.getAlias() + "\n" + "Host: " + s.getHost() + "\n" + "Port: " + s.getPort());
                            } else {
                                ServerComponent.this.mm_table.setToolTipText(null);
                            }
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    public void createTablesColumns() {
        this.mm_table.setLinesVisible(true);
        this.mm_table.setHeaderVisible(true);
        TableColumn columnAlias = new TableColumn(this.mm_table, 0);
        columnAlias.setText("Alias");
        columnAlias.setWidth(120);
        TableColumn columnLogin = new TableColumn(this.mm_table, 0);
        columnLogin.setText("Login");
        columnLogin.setWidth(80);
        TableColumn columnPasswd = new TableColumn(this.mm_table, 0);
        columnPasswd.setText("Password");
        columnPasswd.setWidth(80);
        TableColumn columnDesc = new TableColumn(this.mm_table, 0);
        columnDesc.setText("Description");
        columnDesc.setWidth(300);
        this.mm_table.setSize(this.mm_table.computeSize(400, 150));
    }

    private String toStar(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            sb.append('*');
            ++i;
        }
        return sb.toString();
    }

    private void initializeTable() {
        Vector serversList = ServerConfig.getServerList();
        if (serversList != null) {
            this.setTable(serversList);
        }
    }

    private void setTable(Vector v) {
        this.mm_tviewer.setInput((Object)v);
    }

    public void createButton() {
        Composite comp = new Composite((Composite)this.mm_group, 0);
        GridLayout gl = new GridLayout(3, false);
        comp.setLayout((Layout)gl);
        this.mm_buttonAdvanced = new Button(comp, 131080);
        this.mm_buttonAdvanced.setText("Configure servers settings...");
        this.mm_buttonAdvanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePage page = new PreferencePage();
                page.setTitle(page.getTitle());
                ServerComponent.this.showPreferencePage(page.getPageId(), (IPreferencePage)page);
                Vector v = ServerConfig.getServerList();
                int i = 0;
                while (i < v.size()) {
                    Server s = (Server)v.get(i);
                    System.out.println("Server: " + s.getPassword());
                    ++i;
                }
            }
        });
    }

    protected void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.mm_container.getShell(), manager);
        BusyIndicator.showWhile((Display)this.mm_container.getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            {
                this.val$targetNode = val$targetNode;
            }

            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                dialog.open();
            }
        });
        this.setTable(ServerConfig.getServerList());
        this.initializeTableSelection();
    }

    public void setVisible(boolean b) {
        this.mm_table.setVisible(b);
        this.mm_buttonAdvanced.setVisible(b);
        this.mm_group.setVisible(b);
    }

    public void createDetailsField() {
        this.mm_serverDetails = new Label((Composite)this.mm_group, 0x1000000);
        this.mm_serverDetails.setLayoutData((Object)new GridData(256));
    }

    private void initializeTableSelection() {
        int ind;
        Server targetServer = ServerConfig.getLastConfig();
        if (targetServer == null) {
            targetServer = ServerConfig.getDefaultConfig();
        }
        if (targetServer != null && (ind = this.indexForElement(targetServer)) != -1) {
            this.mm_table.setSelection(ind);
            this.mm_table.showSelection();
        }
    }

    private void invalidatePasswords() {
        Vector serversList = ServerConfig.getServerList();
        int i = 0;
        while (i < serversList.size()) {
            ((Server)serversList.elementAt(i)).setPasswd(null);
            ++i;
        }
    }

    private int indexForElement(Server s) {
        TableItem[] items = this.mm_table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData().equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void saveOptions() {
        Server s = this.getSelectedServer();
        if (s != null) {
            ServerConfig.setLastConfig(s.getAlias());
        }
    }

    public Server getSelectedServer() {
        int ind = this.mm_table.getSelectionIndex();
        if (ind != -1) {
            return (Server)this.mm_table.getItem(ind).getData();
        }
        return null;
    }

    private boolean passwordsToRemember() {
        IPreferenceStore store = EnterprisePortalPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PreferencePage.ID_REMEMBER_PASSWORDS);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.mm_table.addSelectionListener(listener);
    }

    public void addPaintListener(PaintListener listener) {
        this.mm_table.addPaintListener(listener);
    }

    public IServerConfig getSelectedServerConfig() {
        Server server = this.getSelectedServer();
        if (server != null) {
            this.saveOptions();
            return server;
        }
        return null;
    }

    public boolean isServerDefined() {
        return this.mm_table.getItemCount() != 0;
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object arg0, int arg1) {
            if (arg0 instanceof Server) {
                Server s = (Server)arg0;
                switch (arg1) {
                    case 0: {
                        return s.getAlias();
                    }
                    case 1: {
                        return s.getLogin();
                    }
                    case 2: {
                        if (s.getPassword() == null) {
                            return "";
                        }
                        return ServerComponent.this.toStar(s.getPassword());
                    }
                    case 3: {
                        return s.getDescription();
                    }
                }
                return "//TO ADD";
            }
            return null;
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object arg0) {
            return ServerComponent.this.mm_data.toArray();
        }

        public void dispose() {
            ServerComponent.this.mm_tviewer.getLabelProvider().dispose();
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null && newInput instanceof Vector) {
                ServerComponent.this.mm_data = (Vector)newInput;
            }
        }
    }
}

