/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.ui.preferences;

import com.sap.netweaver.ep.core.preferences.Server;
import com.sap.netweaver.ep.core.preferences.ServerConfig;
import com.sap.netweaver.ep.ui.EnterprisePortalPlugin;
import com.sap.netweaver.ep.ui.widgets.ServerInputDialog;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected static final int NIL_VALUE = 0;
    protected static final int ADD_STATE = 1;
    protected static final int REMOVE_STATE = 2;
    protected static final int EDIT_STATE = 3;
    protected static final int COPY_STATE = 4;
    public static final String P_ALIAS = "alias";
    public static final String P_HOST = "host";
    public static final String P_PORT = "port";
    public static final String P_LOGIN = "login";
    public static final String P_DESCRIPTION = "description";
    private StringFieldEditor mm_alias;
    private StringFieldEditor mm_host;
    private StringFieldEditor mm_port;
    private StringFieldEditor mm_login;
    private StringFieldEditor mm_description;
    private Composite mm_parent;
    private Table mm_table;
    private Group mm_groupServer;
    private Button mm_defaultRememberPasswords = null;
    public static String LABEL_REMEMBER_PASSWORDS = "Yes, I want to remember passwords for deployment";
    public static String ID_REMEMBER_PASSWORDS = "com.sap.developmentTools.passwords";
    public static boolean DEFAULT_REMEMBER_PASSWORDS = false;
    public IPreferenceStore mm_store = EnterprisePortalPlugin.getDefault().getPreferenceStore();
    private Button mm_buttonRemove;
    private Button mm_buttonCopy;
    private Button mm_buttonEdit;
    private Button mm_buttonAdd;
    private int mm_state;
    private Vector mm_data;
    private CheckboxTableViewer mm_tviewer;
    private TableContentProvider mm_cp;

    public PreferencePage() {
        super(1);
        this.setPreferenceStore(this.mm_store);
        this.setDescription("Enter information to define your servers");
        this.setErrorMessage(null);
    }

    public void init(IWorkbench workbench) {
        this.initializeDefaults(this.mm_store);
    }

    public void initializeDefaults(IPreferenceStore store) {
        store.setDefault(ID_REMEMBER_PASSWORDS, DEFAULT_REMEMBER_PASSWORDS);
    }

    private void initializeTable() {
        int ind;
        Vector serversList = ServerConfig.loadServerList();
        this.setTable(serversList);
        Server def = ServerConfig.getDefaultConfig();
        if (def != null && (ind = this.indexForElement(def)) != -1) {
            TableItem item = this.mm_table.getItem(ind);
            item.setChecked(def.isDefault());
        }
    }

    private void setTable(Vector v) {
        this.mm_tviewer.setInput((Object)v);
    }

    public void createFieldEditors() {
    }

    protected Control createContents(Composite composite) {
        this.mm_parent = composite;
        this.mm_defaultRememberPasswords = new Button(composite, 32);
        this.mm_defaultRememberPasswords.setText(LABEL_REMEMBER_PASSWORDS);
        this.mm_defaultRememberPasswords.setSelection(this.mm_store.getBoolean(ID_REMEMBER_PASSWORDS));
        this.mm_groupServer = new Group(composite, 32);
        this.mm_groupServer.setText("Servers definition");
        this.mm_groupServer.setLayout((Layout)new GridLayout());
        this.mm_groupServer.setLayoutData((Object)new GridData(1794));
        int style = 67618;
        this.mm_table = new Table((Composite)this.mm_groupServer, style);
        GridData tableGridData = new GridData(1808);
        tableGridData.heightHint = 120;
        this.mm_table.setLayoutData((Object)tableGridData);
        this.mm_table.setLinesVisible(true);
        this.mm_table.setHeaderVisible(true);
        this.mm_tviewer = new CheckboxTableViewer(this.mm_table);
        this.mm_cp = new TableContentProvider(this);
        this.mm_tviewer.setContentProvider((IContentProvider)this.mm_cp);
        this.mm_tviewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.mm_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TableItem item = (TableItem)e.item;
                    Server s = (Server)item.getData();
                    boolean value = item.getChecked();
                    int i = 0;
                    while (i < PreferencePage.this.mm_data.size()) {
                        ((Server)PreferencePage.this.mm_data.get(i)).setDefault(false);
                        ++i;
                    }
                    s.setDefault(value);
                    PreferencePage.this.deselectAll();
                    item.setChecked(value);
                }
                if (PreferencePage.this.mm_table.getSelectionCount() == 0) {
                    PreferencePage.this.mm_buttonRemove.setEnabled(false);
                    PreferencePage.this.mm_buttonEdit.setEnabled(false);
                    PreferencePage.this.mm_buttonCopy.setEnabled(false);
                } else if (PreferencePage.this.mm_table.getSelectionCount() == 1) {
                    PreferencePage.this.mm_buttonRemove.setEnabled(true);
                    PreferencePage.this.mm_buttonEdit.setEnabled(true);
                    PreferencePage.this.mm_buttonCopy.setEnabled(true);
                } else {
                    PreferencePage.this.mm_buttonRemove.setEnabled(true);
                    PreferencePage.this.mm_buttonEdit.setEnabled(false);
                    PreferencePage.this.mm_buttonCopy.setEnabled(false);
                }
            }
        });
        this.mm_table.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                PreferencePage.this.doEditAction();
            }
        });
        TableColumn columnDefault = new TableColumn(this.mm_table, 0);
        columnDefault.setText("Default");
        columnDefault.setWidth(50);
        TableColumn columnAlias = new TableColumn(this.mm_table, 0);
        columnAlias.setText("Alias");
        columnAlias.setWidth(120);
        TableColumn columnHost = new TableColumn(this.mm_table, 0);
        columnHost.setText("Host");
        columnHost.setWidth(80);
        TableColumn columnPort = new TableColumn(this.mm_table, 0);
        columnPort.setText("Port");
        columnPort.setWidth(50);
        TableColumn columnLogin = new TableColumn(this.mm_table, 0);
        columnLogin.setText("Login");
        columnLogin.setWidth(80);
        TableColumn columnDescription = new TableColumn(this.mm_table, 131072);
        columnDescription.setText("Description");
        columnDescription.setWidth(100);
        this.mm_table.setSize(this.mm_table.computeSize(-1, 250));
        this.initializeTable();
        Composite compositeListButtons = new Composite((Composite)this.mm_groupServer, 0);
        RowLayout lbRowLayout = new RowLayout(256);
        lbRowLayout.pack = false;
        lbRowLayout.type = 256;
        lbRowLayout.marginLeft = 5;
        lbRowLayout.marginTop = 5;
        lbRowLayout.marginRight = 5;
        lbRowLayout.marginBottom = 5;
        lbRowLayout.spacing = 5;
        compositeListButtons.setLayout((Layout)lbRowLayout);
        this.mm_buttonAdd = new Button(compositeListButtons, 0);
        this.mm_buttonAdd.setText("Add...");
        this.mm_buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePage.this.doAddAction();
            }
        });
        this.mm_buttonEdit = new Button(compositeListButtons, 0);
        this.mm_buttonEdit.setText("Edit...");
        this.mm_buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePage.this.doEditAction();
            }
        });
        this.mm_buttonCopy = new Button(compositeListButtons, 0);
        this.mm_buttonCopy.setText("Copy...");
        this.mm_buttonCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePage.this.doCopyAction();
            }
        });
        this.mm_buttonRemove = new Button(compositeListButtons, 0);
        this.mm_buttonRemove.setText("Remove");
        this.mm_buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePage.this.doRemoveAction();
            }
        });
        this.mm_buttonRemove.setEnabled(false);
        this.mm_buttonEdit.setEnabled(false);
        this.mm_buttonCopy.setEnabled(false);
        return super.createContents(composite);
    }

    protected void performDefaults() {
        Vector serversList = ServerConfig.loadServerList();
        this.setTable(serversList);
        Server def = ServerConfig.getDefaultConfig();
        if (def != null) {
            this.mm_tviewer.setChecked((Object)def, true);
        }
    }

    public boolean performOk() {
        ServerConfig.saveConfiguration(this.mm_data);
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(ID_REMEMBER_PASSWORDS, this.mm_defaultRememberPasswords.getSelection());
        return true;
    }

    private void deselectAll() {
        TableItem[] items = this.mm_table.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(false);
            ++i;
        }
    }

    private int indexForElement(Server s) {
        TableItem[] items = this.mm_table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData().equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getObject() {
        try {
            return ((Object)((Object)this)).getClass().newInstance();
        }
        catch (InstantiationException ie) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
    }

    public String getPageId() {
        return "com.sap.netweaver.ep.ui.preferences.PreferencePage";
    }

    public String getTitle() {
        return "SAP Enterprise Portal";
    }

    protected int getStateValue() {
        return this.mm_state;
    }

    protected void setStateValue(int v) {
        this.mm_state = v;
    }

    private Object getSelectedElement() {
        ISelection ss = this.mm_tviewer.getSelection();
        return ss;
    }

    private void doAddAction() {
        ServerInputDialog diag = new ServerInputDialog(this.getShell(), this, "Add New Server Settings", ServerInputDialog.ADD_OPERATION);
        diag.open();
        if (diag.getReturnCode() == 0) {
            this.mm_state = 1;
            Server toAdd = new Server(diag.getAliasValue(), diag.getHostValue(), diag.getPortValue(), diag.getLoginValue(), diag.getDescriptionValue());
            this.mm_tviewer.setInput((Object)toAdd);
        }
    }

    private void doEditAction() {
        IStructuredSelection ss = (IStructuredSelection)this.getSelectedElement();
        if (!ss.isEmpty()) {
            Server os = (Server)ss.getFirstElement();
            ServerInputDialog diag = new ServerInputDialog(this.getShell(), this, "Change Server Settings", os.getAlias(), os.getHost(), os.getPort(), os.getLogin(), os.getDescription(), ServerInputDialog.EDIT_OPERATION);
            diag.open();
            if (diag.getReturnCode() == 0) {
                this.mm_state = 3;
                Server ns = new Server(diag.getAliasValue(), diag.getHostValue(), diag.getPortValue(), diag.getLoginValue(), diag.getDescriptionValue(), os.isDefault());
                Server[] sa = new Server[]{os, ns};
                this.mm_tviewer.setInput((Object)sa);
            }
        }
    }

    private void doRemoveAction() {
        Object s = this.getSelectedElement();
        Iterator it = ((IStructuredSelection)s).iterator();
        while (it.hasNext()) {
            this.mm_state = 2;
            this.mm_tviewer.setInput(it.next());
        }
        this.mm_buttonRemove.setEnabled(false);
        this.mm_buttonEdit.setEnabled(false);
        this.mm_buttonCopy.setEnabled(false);
    }

    private void doCopyAction() {
        IStructuredSelection ss = (IStructuredSelection)this.getSelectedElement();
        if (!ss.isEmpty()) {
            Server os = (Server)ss.getFirstElement();
            ServerInputDialog diag = new ServerInputDialog(this.getShell(), this, "Duplicate Server Settings", "Copy_Of_" + os.getAlias(), os.getHost(), os.getPort(), os.getLogin(), os.getDescription(), ServerInputDialog.COPY_OPERATION);
            diag.open();
            if (diag.getReturnCode() == 0) {
                this.mm_state = 4;
                Server toAdd = new Server(diag.getAliasValue(), diag.getHostValue(), diag.getPortValue(), diag.getLoginValue(), diag.getDescriptionValue());
                this.mm_tviewer.setInput((Object)toAdd);
            }
        }
    }

    public Vector getElements() {
        return this.mm_data;
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object arg0, int arg1) {
            if (arg0 instanceof Server) {
                Server s = (Server)arg0;
                switch (arg1) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return s.getAlias();
                    }
                    case 2: {
                        return s.getHost();
                    }
                    case 3: {
                        return String.valueOf(s.getPort());
                    }
                    case 4: {
                        return s.getLogin();
                    }
                    case 5: {
                        return s.getDescription();
                    }
                }
                return "//TO ADD";
            }
            return null;
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        private PreferencePage mm_pp;

        public TableContentProvider(PreferencePage pp) {
            this.mm_pp = pp;
        }

        public Object[] getElements(Object arg0) {
            return PreferencePage.this.mm_data.toArray();
        }

        public void dispose() {
            PreferencePage.this.mm_tviewer.getLabelProvider().dispose();
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            PreferencePage.this.mm_tviewer = (CheckboxTableViewer)v;
            if (newInput != null && newInput instanceof Server) {
                switch (this.mm_pp.getStateValue()) {
                    case 1: {
                        this.addServer((Server)newInput);
                        PreferencePage.this.setStateValue(0);
                        break;
                    }
                    case 2: {
                        this.removeServer((Server)newInput);
                        PreferencePage.this.setStateValue(0);
                        break;
                    }
                    case 4: {
                        this.addServer((Server)newInput);
                        PreferencePage.this.setStateValue(0);
                        break;
                    }
                }
            }
            if (newInput != null && this.mm_pp.getStateValue() == 3) {
                Server os = ((Server[])newInput)[0];
                Server ns = ((Server[])newInput)[1];
                os.setAlias(ns.getAlias());
                os.setHost(ns.getHost());
                os.setPort(ns.getPort());
                os.setLogin(ns.getLogin());
                os.setDescription(ns.getDescription());
                PreferencePage.this.setStateValue(0);
            }
            if (newInput != null && newInput instanceof Vector) {
                PreferencePage.this.mm_data = (Vector)((Vector)newInput).clone();
            }
            if (newInput == null && PreferencePage.this.mm_data == null) {
                PreferencePage.this.mm_data = new Vector();
            }
        }

        public void addServer(Server s) {
            if (PreferencePage.this.mm_data.contains(s)) {
                MessageDialog diag = new MessageDialog(PreferencePage.this.mm_parent.getShell(), "Server definition error", null, "Duplicate Alias", 1, new String[]{"OK"}, 0);
                diag.open();
            } else {
                PreferencePage.this.mm_data.add(s);
            }
        }

        public void removeServer(Server s) {
            PreferencePage.this.mm_data.remove(s);
        }
    }
}

